/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerCommandNotFoundException;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerCompose;
import org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsole;
import org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsoleUtils;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class DockerComposeUpJob
extends Job {
    private final IDockerConnection connection;
    private final String workingDir;
    private final ILaunchConfiguration launchConfiguration;
    private final DockerComposeConsole dockerComposeConsole;

    public DockerComposeUpJob(IDockerConnection connection, String workingDir, ILaunchConfiguration launchConfiguration) {
        super(JobMessages.getString("DockerComposeUp.title"));
        this.connection = connection;
        this.workingDir = workingDir;
        this.launchConfiguration = launchConfiguration;
        this.dockerComposeConsole = DockerComposeConsoleUtils.findConsole(connection, workingDir);
    }

    protected IStatus run(IProgressMonitor monitor) {
        String dockerComposeInstallDir = Activator.getDefault().getPreferenceStore().getString("dockerComposeInstallDir");
        Thread commandThread = new Thread(() -> {
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.dockerComposeConsole);
            try {
                Process dockerComposeSystemProcess = DockerCompose.getInstance().up(this.connection, dockerComposeInstallDir, this.workingDir);
                Launch launch = new Launch(this.launchConfiguration, "run", null);
                IProcess dockerComposeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)dockerComposeSystemProcess, (String)"docker-compose up");
                this.dockerComposeConsole.setDockerComposeProcess(dockerComposeProcess);
                int exitCode = dockerComposeSystemProcess.waitFor();
                if (exitCode != 0) {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)JobMessages.getString("DockerCompose.dialog.title"), (String)JobMessages.getString("DockerComposeUp.start.error")));
                }
            }
            catch (DockerCommandNotFoundException e) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)JobMessages.getString("DockerCompose.dialog.title"), (String)e.getMessage()));
            }
            catch (InterruptedException | DockerException e) {
                Display.getDefault().asyncExec(() -> DockerComposeUpJob.lambda$3((Exception)e));
                Activator.log(e);
            }
        });
        commandThread.start();
        return Status.OK_STATUS;
    }

    private static /* synthetic */ void lambda$3(Exception exception) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)JobMessages.getString("DockerCompose.dialog.title"), (String)exception.getMessage());
    }
}

