/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DisplayContainerLogCommandHandler
extends AbstractHandler {
    private static final String CONTAINER_LOG_TITLE = "ContainerLog.title";
    private static final String ERROR_LOGGING_CONTAINER = "ContainerLogError.msg";

    public Object execute(ExecutionEvent event) {
        IDockerContainerConfig config;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (selectedContainers.size() != 1 || connection == null) {
            return null;
        }
        IDockerContainer container = selectedContainers.get(0);
        String id = container.id();
        String name = container.name();
        IDockerContainerInfo info = connection.getContainerInfo(id);
        if (info != null && (config = info.config()) != null && config.tty()) {
            RunConsole.attachToTerminal(connection, id, null);
            return null;
        }
        try {
            RunConsole rc = RunConsole.findConsole(id);
            if (rc != null) {
                if (!rc.isAttached()) {
                    rc.attachToConsole(connection);
                }
                Display.getDefault().syncExec(() -> rc.setTitle(DVMessages.getFormattedString(CONTAINER_LOG_TITLE, name)));
                OutputStream stream = rc.getOutputStream();
                EnumDockerLoggingStatus status = ((DockerConnection)connection).loggingStatus(id);
                if (status != EnumDockerLoggingStatus.LOGGING_ACTIVE && !((DockerConnection)connection).getContainerInfo(id).config().tty()) {
                    rc.clearConsole();
                    ((DockerConnection)connection).logContainer(id, stream);
                }
                rc.showConsole();
            }
        }
        catch (InterruptedException | DockerException e) {
            Display.getDefault().syncExec(() -> DisplayContainerLogCommandHandler.lambda$1(id, (Exception)e));
        }
        return null;
    }

    private static /* synthetic */ void lambda$1(String string, Exception exception) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(ERROR_LOGGING_CONTAINER, string), (String)exception.getMessage());
    }
}

