/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.CallTypeEnum;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseCallPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseKindPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseMethodCallPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ParameterMatchingPage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrationWizard
extends Wizard
implements INewWizard {
    private ChooseKindPage _chooseKindPage;
    private ChooseCallPage _chooseCallPage;
    private ChooseMethodCallPage _chooseMethodCallPage;
    private ParameterMatchingPage _parameterMatchingPage;
    private ISelection _selection;
    private Pattern _pattern;
    private Call _selectCall;
    private List<Call> _chooseMethodCallList;
    private CallTypeEnum _defaultKind;
    private Object _editItem;
    private TransactionalEditingDomain _editingDomain;

    public OrchestrationWizard(Pattern pattern, CallTypeEnum defaultKind, Object eidtItem, TransactionalEditingDomain editingDomain) {
        this.setNeedsProgressMonitor(true);
        this._pattern = pattern;
        this._defaultKind = defaultKind;
        this._editItem = eidtItem;
        this._editingDomain = editingDomain;
    }

    public boolean canFinish() {
        if (this._chooseKindPage != null && (this._chooseKindPage.getKind() == CallTypeEnum.BACK_CALL || this._chooseKindPage.getKind() == CallTypeEnum.SUPERPATTERN_CALL)) {
            return true;
        }
        if (this._chooseKindPage != null && this._chooseKindPage.getKind() == CallTypeEnum.METHOD_CALL && this._defaultKind == CallTypeEnum.ADD) {
            return this._chooseMethodCallPage.canFinish();
        }
        return this._chooseCallPage.canFinish();
    }

    public void addPages() {
        this.setWindowTitle(Messages.OrchestrationWizard_title);
        if (this._defaultKind.equals((Object)CallTypeEnum.ADD)) {
            this._chooseKindPage = new ChooseKindPage(this._selection);
            this.addPage((IWizardPage)this._chooseKindPage);
        }
        this._chooseCallPage = new ChooseCallPage(this._pattern, this._selection, this._editItem);
        this.addPage((IWizardPage)this._chooseCallPage);
        this._chooseMethodCallPage = new ChooseMethodCallPage(this._pattern, this._selection, this._editItem);
        this.addPage((IWizardPage)this._chooseMethodCallPage);
        if (this._defaultKind.equals((Object)CallTypeEnum.PATTERN_CALL) || this._defaultKind.equals((Object)CallTypeEnum.ADD)) {
            this._parameterMatchingPage = new ParameterMatchingPage(this._selection, this._pattern, this._editingDomain);
            Pattern patternCallee = null;
            if (this._editItem instanceof PatternCall) {
                patternCallee = ((PatternCall)this._editItem).getCalled();
            }
            this._parameterMatchingPage.setPatternCallee(patternCallee);
            this.addPage((IWizardPage)this._parameterMatchingPage);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        WizardPage nextPage;
        if (page instanceof ChooseKindPage) {
            CallTypeEnum kind = ((ChooseKindPage)page).getKind();
            if (kind == CallTypeEnum.METHOD_CALL && this._defaultKind.equals((Object)CallTypeEnum.ADD)) {
                nextPage = this._chooseMethodCallPage;
            } else {
                if (this._chooseKindPage.getKind() == CallTypeEnum.BACK_CALL || this._chooseKindPage.getKind() == CallTypeEnum.SUPERPATTERN_CALL) {
                    return null;
                }
                nextPage = this._chooseCallPage;
            }
        } else {
            nextPage = this._parameterMatchingPage;
        }
        return nextPage;
    }

    public boolean performFinish() {
        if (this._chooseKindPage != null && this._chooseKindPage.getKind() == CallTypeEnum.BACK_CALL) {
            this._selectCall = PatternFactory.eINSTANCE.createBackCall();
        } else if (this._chooseKindPage != null && this._chooseKindPage.getKind() == CallTypeEnum.SUPERPATTERN_CALL) {
            this._selectCall = PatternFactory.eINSTANCE.createSuperCall();
        } else if (this._chooseKindPage != null && this._chooseKindPage.getKind() == CallTypeEnum.METHOD_CALL) {
            this._chooseMethodCallList = this._chooseMethodCallPage.getChooseMethodCallList();
            this._selectCall = this._chooseMethodCallPage.getChooseCall();
        } else {
            this._selectCall = this._chooseCallPage.getChooseCall();
        }
        return true;
    }

    public boolean performCancel() {
        List<RecordingCommand> parameterMatchingCommands;
        if (this._parameterMatchingPage != null && this._editItem != null && (parameterMatchingCommands = this._parameterMatchingPage.getParameterMatchingCommands()) != null) {
            Iterator<RecordingCommand> it = parameterMatchingCommands.iterator();
            while (it.hasNext()) {
                if (this._editingDomain.getCommandStack().canUndo()) {
                    this._editingDomain.getCommandStack().undo();
                }
                it.next();
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._selection = selection;
    }

    public Call getSelectCall() {
        return this._selectCall;
    }

    public List<Call> getSelectMethodCallList() {
        return this._chooseMethodCallList;
    }

    public CallTypeEnum getDefaultKind() {
        return this._defaultKind;
    }
}

