/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.gef.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the {@link org.eclipse.draw2d.FigureCanvas} component from the gef toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-08-04T06:17:59.359Z")
public interface FigureCanvasActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler {
    
    
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkFigureExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkFigureExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkToolExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkToolExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result clickFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result clickInFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public Result selectTool(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks
        ) ;
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public Result clickConnection(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkConnectionExistence(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkConnectionExistence(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result dragFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkFigureProperty(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @since 4.1
         */
        public Result checkFigureProperty(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param anchorType 
         *        the anchor type
         * @param numberOfAnchors 
         *        Number of Anchors
         * @param comparisonMethod 
         *        the comparison method
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkAnchorCount(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable AnchorType anchorType,
            @Nullable Integer numberOfAnchors,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param anchorType 
         *        the anchor type
         * @param numberOfAnchors 
         *        Number of Anchors
         * @param comparisonMethod 
         *        the comparison method
         * @since 4.1
         */
        public Result checkAnchorCount(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable AnchorType anchorType,
            @Nullable Integer numberOfAnchors,
            @Nullable NumberComparisonOperator comparisonMethod
        ) ;
        
        /**
         * Verifies if an anchor has a connection or not
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param hasConnection 
         *        whether a connection is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkAnchorHasConnection(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean hasConnection,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * Verifies if an anchor has a connection or not
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param hasConnection 
         *        whether a connection is expected or not
         * @since 4.1
         */
        public Result checkAnchorHasConnection(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean hasConnection
        ) ;
        
        /**
         * Checks a property from a Figure in a ConnectionEditPart
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkConnectionFigureProperty(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * Checks a property from a Figure in a ConnectionEditPart
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @since 4.1
         */
        public Result checkConnectionFigureProperty(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator
        ) ;
        
} 