/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.ICodanBuilder;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.dialogs.CustomizeProblemDialog;
import org.eclipse.cdt.codan.internal.ui.preferences.FieldEditorOverlayPage;
import org.eclipse.cdt.codan.internal.ui.preferences.ProblemsTreeEditor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.ui.ICEditor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CodanPreferencePage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    private static final String EMPTY_STRING = "";
    private IProblemProfile profile;
    private ISelectionChangedListener problemSelectionListener;
    private ArrayList<IProblem> selectedProblems;
    private Button infoButton;
    private ProblemsTreeEditor checkedTreeEditor;

    public CodanPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.cdt.codan.core"));
        this.problemSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CodanPreferencePage.this.infoButton != null && event.getSelection() instanceof ITreeSelection) {
                    ITreeSelection s = (ITreeSelection)event.getSelection();
                    ArrayList<IProblem> list = new ArrayList<IProblem>();
                    for (Object o : s) {
                        if (!(o instanceof IProblem)) continue;
                        list.add((IProblem)o);
                    }
                    CodanPreferencePage.this.setSelectedProblems(list);
                }
            }
        };
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.cdt.codan.internal.ui.preferences.CodanPreferencePage";
    }

    public void createFieldEditors() {
        this.checkedTreeEditor = new ProblemsTreeEditor(this.getFieldEditorParent(), this.profile);
        this.addField(this.checkedTreeEditor);
        this.checkedTreeEditor.getTreeViewer().addSelectionChangedListener(this.problemSelectionListener);
        this.checkedTreeEditor.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CodanPreferencePage.this.openCustomizeDialog();
            }
        });
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        this.checkedTreeEditor.getTreeViewer().getControl().setLayoutData((Object)layoutData);
    }

    @Override
    protected Control createContents(Composite parent) {
        this.profile = this.isPropertyPage() ? this.getRegistry().getResourceProfileWorkingCopy((IResource)this.getElement()) : this.getRegistry().getWorkspaceProfile();
        Composite comp = (Composite)super.createContents(parent);
        this.createInfoControl(parent);
        return comp;
    }

    private void createInfoControl(Composite comp) {
        Composite info = new Composite(comp, 0);
        info.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        info.setLayout((Layout)layout);
        this.infoButton = new Button(info, 8);
        this.infoButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 1).create());
        this.infoButton.setText(CodanUIMessages.CodanPreferencePage_Customize);
        this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodanPreferencePage.this.openCustomizeDialog();
            }
        });
        this.restoreWidgetValues();
    }

    protected void setSelectedProblems(ArrayList<IProblem> list) {
        this.selectedProblems = list;
        this.updateProblemInfo();
    }

    protected ICheckersRegistry getRegistry() {
        return CodanRuntime.getInstance().getCheckersRegistry();
    }

    @Override
    public boolean performOk() {
        this.saveWidgetValues();
        IResource resource = (IResource)this.getElement();
        this.getRegistry().updateProfile(resource, null);
        boolean success = super.performOk();
        if (success) {
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            CodanPreferencePage.asynchronouslyUpdateMarkers(resource);
        }
        return success;
    }

    private void saveWidgetValues() {
        String id = !this.hasSelectedProblems() ? EMPTY_STRING : this.selectedProblems.get(0).getId();
        this.getDialogSettings().put(this.getWidgetId(), id);
    }

    private void restoreWidgetValues() {
        String id = this.getDialogSettings().get(this.getWidgetId());
        if (id != null && !id.isEmpty() && this.checkedTreeEditor != null) {
            IProblem problem = this.profile.findProblem(id);
            if (problem != null) {
                this.checkedTreeEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)problem), true);
            }
        } else {
            this.setSelectedProblems(null);
        }
        this.updateProblemInfo();
    }

    private IDialogSettings getDialogSettings() {
        return CodanUIActivator.getDefault().getDialogSettings();
    }

    protected String getWidgetId() {
        return String.valueOf(this.getPageId()) + ".selection";
    }

    private void updateProblemInfo() {
        this.infoButton.setEnabled(this.hasSelectedProblems());
    }

    public void init(IWorkbench workbench) {
    }

    protected void openCustomizeDialog() {
        if (!this.hasSelectedProblems()) {
            return;
        }
        IProblem[] selected = this.selectedProblems.toArray(new IProblem[this.selectedProblems.size()]);
        CustomizeProblemDialog dialog = new CustomizeProblemDialog(this.getShell(), selected, (IResource)this.getElement());
        dialog.open();
        this.checkedTreeEditor.getTreeViewer().refresh(true);
    }

    private boolean hasSelectedProblems() {
        return this.selectedProblems != null && !this.selectedProblems.isEmpty();
    }

    private static void asynchronouslyUpdateMarkers(final IResource resource) {
        final HashSet<IFile> filesToUpdate = new HashSet<IFile>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow active = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = active.getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IEditorReference partRef = iEditorReferenceArray[n2];
            IEditorPart editor = partRef.getEditor(false);
            if (editor instanceof ICEditor && (file = (IFile)editor.getEditorInput().getAdapter(IFile.class)) != null && resource.getFullPath().isPrefixOf(file.getFullPath())) {
                filesToUpdate.add(file);
            }
            ++n2;
        }
        Job job = new Job(CodanUIMessages.CodanPreferencePage_Update_markers){

            protected IStatus run(IProgressMonitor monitor) {
                final SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + 2 * filesToUpdate.size()));
                CodanPreferencePage.removeMarkersForDisabledProblems(resource, (IProgressMonitor)submonitor.newChild(1));
                if (filesToUpdate.isEmpty()) {
                    return Status.OK_STATUS;
                }
                for (final IFile file : filesToUpdate) {
                    ITranslationUnit tu = CoreModelUtil.findTranslationUnit((IFile)file);
                    if (tu == null) continue;
                    tu = CModelUtil.toWorkingCopy((ITranslationUnit)tu);
                    ASTProvider.getASTProvider().runOnAST((ICElement)tu, ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)submonitor.newChild(1), new ASTCache.ASTRunnable(){

                        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                            ICodanBuilder builder = CodanRuntime.getInstance().getBuilder();
                            if (ast != null) {
                                builder.processResource((IResource)file, (IProgressMonitor)submonitor.newChild(1), CheckerLaunchMode.RUN_AS_YOU_TYPE, (Object)ast);
                            } else {
                                builder.processResource((IResource)file, (IProgressMonitor)submonitor.newChild(1), CheckerLaunchMode.RUN_ON_FILE_OPEN, null);
                            }
                            return Status.OK_STATUS;
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        job.setRule(ruleFactory.markerRule(resource));
        job.setSystem(true);
        job.schedule();
    }

    private static void removeMarkersForDisabledProblems(IResource resource, IProgressMonitor monitor) {
        CheckersRegistry chegistry = CheckersRegistry.getInstance();
        HashSet<String> markerTypes = new HashSet<String>();
        for (IChecker checker : chegistry) {
            Collection problems = chegistry.getRefProblems(checker);
            for (IProblem problem : problems) {
                markerTypes.add(problem.getMarkerType());
            }
        }
        try {
            CodanPreferencePage.removeMarkersForDisabledProblems(chegistry, markerTypes, resource, monitor);
        }
        catch (CoreException e) {
            CodanUIActivator.log(e);
        }
    }

    private static void removeMarkersForDisabledProblems(CheckersRegistry chegistry, Set<String> markerTypes, IResource resource, IProgressMonitor monitor) throws CoreException {
        if (!resource.isAccessible()) {
            return;
        }
        IResource[] children = null;
        if (resource instanceof IContainer) {
            children = ((IContainer)resource).members();
        }
        int numChildren = children == null ? 0 : children.length;
        int childWeight = 10;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + numChildren * childWeight));
        IProblemProfile resourceProfile = null;
        for (String markerType : markerTypes) {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers(markerType, false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem;
                IMarker marker = iMarkerArray[n2];
                String problemId = (String)marker.getAttribute("id");
                if (resourceProfile == null) {
                    resourceProfile = chegistry.getResourceProfile(resource);
                }
                if ((problem = resourceProfile.findProblem(problemId)) != null && !problem.isEnabled()) {
                    marker.delete();
                }
                ++n2;
            }
        }
        progress.worked(1);
        if (children != null) {
            IResource[] iResourceArray = children;
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                IResource child = iResourceArray[n3];
                if (monitor.isCanceled()) {
                    return;
                }
                CodanPreferencePage.removeMarkersForDisabledProblems(chegistry, markerTypes, child, (IProgressMonitor)progress.newChild(childWeight));
                ++n3;
            }
        }
    }
}

