/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.rcptt.internal.launching.aut.BaseAut;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchState;

public class AutLaunchStorage {
    private List<BaseAutLaunch> launches = new ArrayList<BaseAutLaunch>();
    private Map<String, BaseAutLaunch> byId = new HashMap<String, BaseAutLaunch>();
    private Map<ILaunch, BaseAutLaunch> byLaunch = new HashMap<ILaunch, BaseAutLaunch>();
    private Map<BaseAut, List<BaseAutLaunch>> byAut = new HashMap<BaseAut, List<BaseAutLaunch>>();

    public synchronized List<AutLaunch> getAll() {
        this.filterTerminated();
        return new ArrayList<AutLaunch>(this.launches);
    }

    public synchronized void add(BaseAutLaunch launch) {
        this.launches.add(launch);
        this.byId.put(launch.getId(), launch);
        this.byLaunch.put(launch.getLaunch(), launch);
        List<BaseAutLaunch> list = this.byAut.get(launch.getAut());
        if (list == null) {
            list = new ArrayList<BaseAutLaunch>();
            this.byAut.put(launch.getAut(), list);
        }
        list.add(launch);
    }

    public synchronized boolean remove(BaseAutLaunch launch) {
        this.byId.remove(launch.getId());
        this.byLaunch.remove(launch.getLaunch());
        List<BaseAutLaunch> list = this.byAut.get(launch.getAut());
        if (list != null) {
            list.remove(launch);
            if (list.isEmpty()) {
                this.byAut.remove(launch.getAut());
            }
        }
        return this.launches.remove(launch);
    }

    public synchronized void replaceLaunch(BaseAutLaunch aut, ILaunch newLaunch, ILaunch oldLaunch) {
        this.byLaunch.remove(oldLaunch);
        this.byLaunch.put(newLaunch, aut);
    }

    public synchronized BaseAutLaunch removeByLaunch(ILaunch config) {
        BaseAutLaunch aut = this.getByLaunch(config);
        if (aut != null) {
            this.remove(aut);
        }
        return aut;
    }

    public synchronized List<AutLaunch> getByAut(BaseAut aut) {
        this.filterTerminated();
        List<BaseAutLaunch> list = this.byAut.get(aut);
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AutLaunch>(list);
    }

    public synchronized BaseAutLaunch getCurrent(BaseAut aut) {
        this.filterTerminated();
        List<BaseAutLaunch> list = this.byAut.get(aut);
        if (list != null && list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public synchronized BaseAutLaunch getById(String id) {
        return this.byId.get(id);
    }

    public synchronized BaseAutLaunch getByLaunch(ILaunch launch) {
        BaseAutLaunch baseAutLaunch = this.byLaunch.get(launch);
        if (baseAutLaunch != null) {
            return baseAutLaunch;
        }
        String id = launch.getAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID");
        if (id != null) {
            return this.byId.get(id);
        }
        return null;
    }

    private void filterTerminated() {
        ArrayList<BaseAutLaunch> terminated = new ArrayList<BaseAutLaunch>();
        for (BaseAutLaunch launch : this.launches) {
            if (launch.getState() != AutLaunchState.TERMINATE) continue;
            terminated.add(launch);
        }
        for (BaseAutLaunch launch : terminated) {
            this.remove(launch);
        }
    }
}

