/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalLabelProviderExtension;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalLabelProviderExtension2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.AliasField;
import org.eclipse.php.internal.core.codeassist.AliasMethod;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.Messages;
import org.eclipse.php.internal.ui.util.PHPModelLabelProvider;

public class PHPCompletionProposalLabelProvider
extends CompletionProposalLabelProvider
implements ICompletionProposalLabelProviderExtension,
ICompletionProposalLabelProviderExtension2 {
    private static final PHPModelLabelProvider fLabelProvider = new PHPModelLabelProvider();
    private static final String ENCLOSING_TYPE_SEPARATOR = String.valueOf('\\');

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        return this.createStyledMethodProposalLabel(methodProposal).toString();
    }

    protected String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        return this.createStyledOverrideMethodProposalLabel(methodProposal).toString();
    }

    public StyledString createStyledOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StyledString nameBuffer = new StyledString();
        IMethod method = (IMethod)methodProposal.getModelElement();
        if (method instanceof FakeConstructor && method.getParent() instanceof AliasType) {
            AliasType aliasType = (AliasType)method.getParent();
            nameBuffer.append(aliasType.getAlias());
        } else if (method instanceof AliasMethod) {
            AliasMethod aliasMethod = (AliasMethod)method;
            nameBuffer.append(aliasMethod.getAlias());
        } else {
            nameBuffer.append(method.getElementName());
        }
        nameBuffer.append('(');
        this.appendStyledParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        this.appendMethodType(nameBuffer, methodProposal);
        this.appendQualifier(nameBuffer, method.getParent(), Messages.PHPCompletionProposalOverride);
        return nameBuffer;
    }

    protected void appendMethodType(StyledString nameBuffer, CompletionProposal methodProposal) {
        if (this.showMethodReturnType()) {
            IMethod method = (IMethod)methodProposal.getModelElement();
            if (method instanceof AliasMethod) {
                method = (IMethod)((AliasMethod)method).getMethod();
            }
            if (method == null) {
                return;
            }
            try {
                String type;
                if (method.isConstructor() || !method.exists()) {
                    return;
                }
                nameBuffer.append(this.getReturnTypeSeparator(), StyledString.DECORATIONS_STYLER);
                if (PHPFlags.isNullable((int)method.getFlags())) {
                    nameBuffer.append("?", StyledString.DECORATIONS_STYLER);
                }
                if ((type = method.getType()) == null) {
                    type = (method.getFlags() & 0x2000000) != 0 ? "mixed" : "void";
                }
                nameBuffer.append(type, StyledString.DECORATIONS_STYLER);
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
    }

    protected void appendFieldType(StyledString nameBuffer, CompletionProposal methodProposal) {
        IField element = (IField)methodProposal.getModelElement();
        if (element instanceof AliasField) {
            element = (IField)((AliasField)element).getField();
        }
        if (element == null) {
            return;
        }
        try {
            if (!element.exists()) {
                return;
            }
            String type = element.getType();
            if (type != null) {
                nameBuffer.append(this.getReturnTypeSeparator(), StyledString.DECORATIONS_STYLER);
                nameBuffer.append(type, StyledString.DECORATIONS_STYLER);
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
    }

    private boolean showMethodReturnType() {
        return PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("methodreturntype");
    }

    public String createTypeProposalLabel(CompletionProposal typeProposal) {
        return this.createStyledTypeProposalLabel(typeProposal).toString();
    }

    protected String createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append(proposal.getName());
        IField field = (IField)proposal.getModelElement();
        if (field.getParent() != null) {
            nameBuffer.append(" - ");
            IModelElement parent = field.getParent();
            nameBuffer.append(parent.getElementName());
        }
        return nameBuffer.toString();
    }

    protected String createTypeProposalLabel(String fullName) {
        return super.createTypeProposalLabel(fullName);
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof ArchiveProjectFragment) {
            return DLTKPluginImages.DESC_OBJS_JAR;
        }
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createImageDescriptor(proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createTypeImageDescriptor(proposal);
    }

    public String createFieldProposalLabel(CompletionProposal proposal) {
        return this.createStyledFieldProposalLabel(proposal).toString();
    }

    public ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createFieldImageDescriptor(proposal);
    }

    public ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createMethodImageDescriptor(proposal);
    }

    public StyledString createStyledFieldProposalLabel(CompletionProposal proposal) {
        StyledString buffer = new StyledString();
        if (proposal.getModelElement() instanceof AliasField) {
            AliasField aliasField = (AliasField)proposal.getModelElement();
            buffer.append(aliasField.getAlias());
        } else {
            buffer.append(proposal.getName());
        }
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 8) {
            this.appendFieldType(buffer, proposal);
            if (!proposal.getName().startsWith("$")) {
                this.appendQualifier(buffer, element.getParent());
            }
        }
        return buffer;
    }

    public StyledString createStyledLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 5: 
            case 9: 
            case 10: {
                return this.createStyledMethodProposalLabel(proposal);
            }
            case 6: {
                return this.createStyledOverrideMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createStyledTypeProposalLabel(proposal);
            }
            case 1: {
                return this.createStyledFieldProposalLabel(proposal);
            }
            case 4: 
            case 8: {
                return this.createStyledSimpleLabelWithType(proposal);
            }
            case 2: {
                return this.createStyledKeywordLabel(proposal);
            }
            case 3: 
            case 11: {
                return this.createStyledSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    protected StyledString createStyledMethodProposalLabel(CompletionProposal methodProposal) {
        StyledString nameBuffer = new StyledString();
        IMethod method = (IMethod)methodProposal.getModelElement();
        if (method instanceof FakeConstructor && method.getParent() instanceof AliasType) {
            AliasType aliasType = (AliasType)method.getParent();
            nameBuffer.append(aliasType.getAlias());
        } else if (method instanceof AliasMethod) {
            AliasMethod aliasMethod = (AliasMethod)method;
            nameBuffer.append(aliasMethod.getAlias());
        } else {
            nameBuffer.append(method.getElementName());
        }
        nameBuffer.append('(');
        this.appendStyledParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        this.appendMethodType(nameBuffer, methodProposal);
        this.appendQualifier(nameBuffer, method.getParent());
        return nameBuffer;
    }

    protected StyledString appendStyledParameterList(StyledString buffer, CompletionProposal methodProposal) {
        Integer paramLimit;
        String[] parameterNames = methodProposal.findParameterNames(null);
        IMethod method = (IMethod)methodProposal.getModelElement();
        if (method instanceof AliasMethod) {
            method = (IMethod)((AliasMethod)method).getMethod();
        }
        IParameter[] parameters = null;
        boolean isVariadic = false;
        try {
            if (method != null) {
                parameters = method.getParameters();
                if (PHPFlags.isVariadic((int)method.getFlags())) {
                    isVariadic = true;
                }
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        if (parameterNames != null && (paramLimit = (Integer)methodProposal.getAttribute("org.eclipse.dltk.uiCompletionProposal#ParameterLimit")) != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i >= paramLimit) break;
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                if (parameters != null && i < parameters.length && PHPFlags.isReference((int)parameters[i].getFlags())) {
                    buffer.append("&");
                }
                if (isVariadic && i + 1 == parameterNames.length) {
                    buffer.append("...");
                }
                buffer.append(parameterNames[i]);
                ++i;
            }
            return buffer;
        }
        return this.appendStyledParameterSignature(buffer, parameterNames, parameters, isVariadic);
    }

    protected StyledString appendStyledParameterSignature(StyledString buffer, String[] parameterNames, IParameter[] parameters, boolean isVariadic) {
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                if (parameters != null && i < parameters.length && PHPFlags.isReference((int)parameters[i].getFlags())) {
                    buffer.append("&");
                }
                if (isVariadic && i + 1 == parameterNames.length) {
                    buffer.append("...");
                }
                buffer.append(parameterNames[i]);
                ++i;
            }
        }
        return buffer;
    }

    public String createLabel(CompletionProposal proposal) {
        return this.createStyledLabel(proposal).toString();
    }

    public StyledString createStyledKeywordLabel(CompletionProposal proposal) {
        return new StyledString(proposal.getName());
    }

    public StyledString createStyledSimpleLabel(CompletionProposal proposal) {
        return new StyledString(proposal.getName());
    }

    public StyledString createStyledTypeProposalLabel(CompletionProposal typeProposal) {
        StyledString nameBuffer = new StyledString();
        IType type = (IType)typeProposal.getModelElement();
        if (type instanceof AliasType) {
            AliasType aliasType = (AliasType)type;
            nameBuffer.append(aliasType.getAlias());
        } else {
            nameBuffer.append(typeProposal.getName());
        }
        boolean isNamespace = false;
        try {
            isNamespace = PHPFlags.isNamespace((int)type.getFlags());
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        if (!isNamespace) {
            this.appendQualifier(nameBuffer, (IModelElement)type);
            if (type.getParent() != null) {
                nameBuffer.append(" - ", StyledString.DECORATIONS_STYLER);
                nameBuffer.append(type.getParent().getElementName(), StyledString.QUALIFIER_STYLER);
            }
        }
        return nameBuffer;
    }

    public StyledString createStyledSimpleLabelWithType(CompletionProposal proposal) {
        ILocalVariable var;
        String type;
        StyledString buffer = new StyledString(proposal.getName());
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 13 && element.exists() && (type = (var = (ILocalVariable)element).getType()) != null) {
            buffer.append(this.getReturnTypeSeparator(), StyledString.DECORATIONS_STYLER);
            buffer.append(type, StyledString.QUALIFIER_STYLER);
        }
        return buffer;
    }

    protected String createSimpleLabelWithType(CompletionProposal proposal) {
        return this.createStyledSimpleLabelWithType(proposal).toString();
    }

    protected void appendQualifier(StyledString buffer, IModelElement modelElement) {
        this.appendQualifier(buffer, modelElement, Messages.PHPCompletionProposalQualifier);
    }

    protected void appendQualifier(StyledString buffer, IModelElement modelElement, String suffix) {
        String name;
        block6: {
            if (modelElement == null) {
                return;
            }
            name = null;
            if (modelElement instanceof IType) {
                IType type = (IType)modelElement;
                try {
                    if (PHPFlags.isAnonymous((int)type.getFlags())) {
                        name = "__anonymous";
                        break block6;
                    }
                    name = type.getTypeQualifiedName(ENCLOSING_TYPE_SEPARATOR);
                }
                catch (ModelException modelException) {}
            } else {
                name = modelElement.getElementName();
            }
        }
        buffer.append(' ');
        buffer.append(NLS.bind((String)suffix, (Object[])new String[]{name}), StyledString.QUALIFIER_STYLER);
    }
}

