/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.trace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egf.core.trace.Category;
import org.eclipse.egf.core.trace.Configuration;
import org.eclipse.egf.core.trace.Filter;
import org.eclipse.egf.core.trace.TraceFactory;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.trace.ITracePreferences;
import org.eclipse.egf.pattern.trace.TraceState;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.osgi.service.prefs.BackingStoreException;

public class TracePreferencesManager
implements ITracePreferences {
    public void save(TraceState state, Configuration configuration) throws BackingStoreException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Resource eResource = configuration.eResource();
        if (eResource == null) {
            XMLResourceImpl res = new XMLResourceImpl();
            res.getContents().add((Object)configuration);
            eResource = res;
        }
        eResource.save((OutputStream)out, new HashMap());
        String configurationStr = new String(out.toByteArray());
        IEclipsePreferences node = new ConfigurationScope().getNode(EGFPatternPlugin.getDefault().getPluginID());
        node.put("org.eclipse.egf.core.trace.filters", configurationStr);
        node.put("org.eclipse.egf.core.trace.enable", state.getLabel());
        node.flush();
    }

    public Configuration getDefaultConfiguration() {
        Configuration configuration = TraceFactory.eINSTANCE.createConfiguration();
        Category emfCategory = TraceFactory.eINSTANCE.createCategory();
        emfCategory.setName("Emf generation");
        emfCategory.setActive(true);
        configuration.getCategories().add((Object)emfCategory);
        Filter filter = TraceFactory.eINSTANCE.createFilter();
        filter.setComment("<!--{}-->");
        filter.setPattern(".*XML");
        emfCategory.getFilters().add((Object)filter);
        filter = TraceFactory.eINSTANCE.createFilter();
        filter.setComment("<!--{}-->");
        filter.setPattern(".*Xml");
        emfCategory.getFilters().add((Object)filter);
        filter = TraceFactory.eINSTANCE.createFilter();
        filter.setComment("# ");
        filter.setPattern(".*Properties");
        emfCategory.getFilters().add((Object)filter);
        filter = TraceFactory.eINSTANCE.createFilter();
        filter.setComment(": ");
        filter.setPattern(".*MF");
        emfCategory.getFilters().add((Object)filter);
        filter = TraceFactory.eINSTANCE.createFilter();
        filter.setComment("//");
        filter.setPattern("org\\.eclipse\\.egf\\.emf\\.pattern.*");
        emfCategory.getFilters().add((Object)filter);
        emfCategory.getFilters().add((Object)filter);
        XMLResourceImpl res = new XMLResourceImpl();
        res.getContents().add((Object)configuration);
        return configuration;
    }

    public Configuration loadConfiguration() throws IOException {
        IEclipsePreferences node = new ConfigurationScope().getNode(EGFPatternPlugin.getDefault().getPluginID());
        String configurationStr = node.get("org.eclipse.egf.core.trace.filters", null);
        XMLResourceImpl res = new XMLResourceImpl();
        if (configurationStr == null || "".equals(configurationStr)) {
            Configuration configuration = this.getDefaultConfiguration();
            res.getContents().add((Object)configuration);
            return configuration;
        }
        res.load((InputStream)new ByteArrayInputStream(configurationStr.getBytes()), new HashMap());
        return (Configuration)res.getContents().get(0);
    }

    public TraceState loadState() throws IOException {
        IEclipsePreferences node = new ConfigurationScope().getNode(EGFPatternPlugin.getDefault().getPluginID());
        String state = node.get("org.eclipse.egf.core.trace.enable", TraceState.NEVER.getLabel());
        return TraceState.get(state);
    }
}

