/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeature;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureSettingDelegate;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;

public class QueryBasedFeatureSettingDelegateFactory
implements EStructuralFeature.Internal.SettingDelegate.Factory {
    private final Map<Notifier, WeakReference<AdvancedViatraQueryEngine>> engineMap = new WeakHashMap<Notifier, WeakReference<AdvancedViatraQueryEngine>>();
    private final Map<String, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> specificationMap = new HashMap<String, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>>();
    private final ListMultimap<ViatraQueryEngine, QueryBasedFeature> delayedFeatures = ArrayListMultimap.create();

    public Map<String, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> getSpecificationMap() {
        return this.specificationMap;
    }

    protected ListMultimap<ViatraQueryEngine, QueryBasedFeature> getDelayedFeatures() {
        return this.delayedFeatures;
    }

    protected AdvancedViatraQueryEngine getEngineForNotifier(Notifier notifier, boolean dynamicEMFMode) {
        if (dynamicEMFMode) {
            WeakReference<AdvancedViatraQueryEngine> reference = this.engineMap.get(notifier);
            if (reference != null && reference.get() != null) {
                return (AdvancedViatraQueryEngine)reference.get();
            }
            AdvancedViatraQueryEngine unmanagedEngine = AdvancedViatraQueryEngine.createUnmanagedEngine((QueryScope)new EMFScope(notifier, new BaseIndexOptions().withDynamicEMFMode(dynamicEMFMode)));
            this.engineMap.put(notifier, new WeakReference<AdvancedViatraQueryEngine>(unmanagedEngine));
            return unmanagedEngine;
        }
        return AdvancedViatraQueryEngine.from((ViatraQueryEngine)ViatraQueryEngine.on((QueryScope)new EMFScope(notifier)));
    }

    public Optional<QueryBasedFeatureSettingDelegate> getSettingDelegate(EStructuralFeature eStructuralFeature) {
        EStructuralFeature.Internal internalFeature;
        EStructuralFeature.Internal.SettingDelegate delegate;
        QueryBasedFeatureSettingDelegate settingDelegate = null;
        if (eStructuralFeature instanceof EStructuralFeature.Internal && (delegate = (internalFeature = (EStructuralFeature.Internal)eStructuralFeature).getSettingDelegate()) instanceof QueryBasedFeatureSettingDelegate) {
            settingDelegate = (QueryBasedFeatureSettingDelegate)delegate;
        }
        return Optional.ofNullable(settingDelegate);
    }

    public EStructuralFeature.Internal.SettingDelegate createSettingDelegate(EStructuralFeature eStructuralFeature) {
        EStructuralFeature.Internal.SettingDelegate result = null;
        IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpec = this.findQuerySpecification(eStructuralFeature);
        if (querySpec != null) {
            result = querySpec instanceof BaseGeneratedEMFQuerySpecification ? this.createSettingDelegate(eStructuralFeature, querySpec, false, false) : this.createSettingDelegate(eStructuralFeature, querySpec, true, true);
        } else {
            return new BasicSettingDelegate.Stateless(eStructuralFeature){

                protected boolean isSet(InternalEObject owner) {
                    return false;
                }

                protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
                    if (this.eStructuralFeature.isMany()) {
                        return ECollections.EMPTY_ELIST;
                    }
                    return null;
                }
            };
        }
        return result;
    }

    public IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> findQuerySpecification(EStructuralFeature eStructuralFeature) {
        IQuerySpecification querySpec = null;
        EAnnotation annotation = eStructuralFeature.getEAnnotation("org.eclipse.viatra.query.querybasedfeature");
        if (annotation != null) {
            String patternFQN = (String)annotation.getDetails().get((Object)"patternFQN");
            if (this.specificationMap.containsKey(patternFQN)) {
                querySpec = this.specificationMap.get(patternFQN);
            } else {
                IQuerySpecificationRegistry registry = QuerySpecificationRegistry.getInstance();
                querySpec = (IQuerySpecification)registry.getDefaultView().getEntry(patternFQN).get();
            }
        }
        return querySpec;
    }

    public EStructuralFeature.Internal.SettingDelegate createSettingDelegate(EStructuralFeature eStructuralFeature, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification, boolean isResourceScope, boolean dynamicEMFMode) {
        Preconditions.checkArgument((querySpecification != null ? 1 : 0) != 0, (String)"Query specification cannot be null!");
        return new QueryBasedFeatureSettingDelegate(eStructuralFeature, this, querySpecification, isResourceScope, dynamicEMFMode);
    }
}

