/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstant;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqual2Exp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsKindOfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OperationCallExp;

public class ReferencesVisitor
extends AbstractExtendingCGModelVisitor<List<Object>, Object> {
    public static final @NonNull ReferencesVisitor INSTANCE = new ReferencesVisitor((Object)null);

    protected ReferencesVisitor(@Nullable Object context) {
        super(context);
    }

    protected @NonNull List<@Nullable Object> append(@NonNull List<@Nullable Object> iterables, Object ... objects) {
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                @Nullable Object object = objectArray[n2];
                iterables.add(object);
                ++n2;
            }
        }
        return iterables;
    }

    @Override
    public @NonNull List<@Nullable Object> visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException("Unsupported " + this.getClass().getName() + " visit");
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGCallExp(@NonNull CGCallExp cgElement) {
        return this.append((List)super.visitCGCallExp(cgElement), cgElement.getSource());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGCastExp(@NonNull CGCastExp cgElement) {
        return this.append((List)super.visitCGCastExp(cgElement), cgElement.getExecutorType());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGConstant(@NonNull CGConstant cgElement) {
        return this.append((List)super.visitCGConstant(cgElement), cgElement.getConstantValue());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGConstantExp(@NonNull CGConstantExp cgElement) {
        return this.append((List)super.visitCGConstantExp(cgElement), cgElement.getReferredConstant());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGEcoreOperation(@NonNull CGEcoreOperation cgElement) {
        return this.append((List)super.visitCGEcoreOperation(cgElement), cgElement.getEOperation());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGElement(@NonNull CGElement cgElement) {
        return new ArrayList<Object>();
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGElementId(@NonNull CGElementId cgElement) {
        return this.append((List)super.visitCGElementId(cgElement), cgElement.getASTypeId());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGExecutorOperation(@NonNull CGExecutorOperation cgElement) {
        return this.append((List)super.visitCGExecutorOperation(cgElement), cgElement.getUnderlyingOperationId());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGExecutorProperty(@NonNull CGExecutorProperty cgElement) {
        return this.append((List)super.visitCGExecutorProperty(cgElement), cgElement.getUnderlyingPropertyId());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGExecutorType(@NonNull CGExecutorType cgElement) {
        return this.append((List)super.visitCGExecutorType(cgElement), cgElement.getUnderlyingTypeId());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull List<@Nullable Object> visitCGIsEqual2Exp(@NonNull CGIsEqual2Exp cgElement) {
        @Nullable List elements = (List)super.visitCGIsEqual2Exp(cgElement);
        Element ast = cgElement.getAst();
        if (ast instanceof OperationCallExp) {
            elements.add(((OperationCallExp)ast).getReferredOperation());
        }
        return elements;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull List<@Nullable Object> visitCGIsEqualExp(@NonNull CGIsEqualExp cgElement) {
        @Nullable List elements = (List)super.visitCGIsEqualExp(cgElement);
        Element ast = cgElement.getAst();
        if (ast instanceof OperationCallExp) {
            elements.add(((OperationCallExp)ast).getReferredOperation());
        }
        return elements;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull List<@Nullable Object> visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgElement) {
        @Nullable List elements = (List)super.visitCGIsInvalidExp(cgElement);
        Element ast = cgElement.getAst();
        if (ast instanceof OperationCallExp) {
            elements.add(((OperationCallExp)ast).getReferredOperation());
        }
        return elements;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull List<@Nullable Object> visitCGIsKindOfExp(@NonNull CGIsKindOfExp cgElement) {
        @Nullable List elements = (List)super.visitCGIsKindOfExp(cgElement);
        Element ast = cgElement.getAst();
        if (ast instanceof OperationCallExp) {
            elements.add(((OperationCallExp)ast).getReferredOperation());
        }
        return elements;
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGIterationCallExp(@NonNull CGIterationCallExp cgElement) {
        return this.append((List)super.visitCGIterationCallExp(cgElement), cgElement.getReferredIteration(), cgElement.getBody());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGNamedElement(@NonNull CGNamedElement cgElement) {
        return this.append((List)super.visitCGNamedElement(cgElement), cgElement.getName());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGOperationCallExp(@NonNull CGOperationCallExp cgElement) {
        List<@Nullable Object> elements = this.append((List)super.visitCGOperationCallExp(cgElement), cgElement.getReferredOperation());
        elements.addAll(cgElement.getArguments());
        return elements;
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGOppositePropertyCallExp(@NonNull CGOppositePropertyCallExp cgElement) {
        return this.append((List)super.visitCGOppositePropertyCallExp(cgElement), cgElement.getReferredProperty());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGPropertyCallExp(@NonNull CGPropertyCallExp cgElement) {
        return this.append((List)super.visitCGPropertyCallExp(cgElement), cgElement.getReferredProperty());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGTypeExp(@NonNull CGTypeExp cgElement) {
        return this.append((List)super.visitCGTypeExp(cgElement), cgElement.getASTypeId());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGTypedElement(@NonNull CGTypedElement cgElement) {
        return this.append((List)super.visitCGTypedElement(cgElement), cgElement.getASTypeId());
    }

    @Override
    public @NonNull List<@Nullable Object> visitCGVariableExp(@NonNull CGVariableExp cgElement) {
        return this.append((List)super.visitCGVariableExp(cgElement), cgElement.getReferredVariable());
    }
}

