/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder;

import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class MainExpressionPage
extends WizardPage
implements SelectionListener {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String CASE_EXPRESSION = "CASE";
    public static final String CONSTANT_EXPRESSION = "Constant";
    public static final String FUNCTION_EXPRESSION = "Function";
    public static final String CAST_EXPRESSION = "CAST";
    public static final String SUBQUERY_EXPRESSION = "SUBQUERY";
    public static final String EXPRESSIONS_BY_OPERATORS = "Expressions by operators";
    private QueryValueExpression inputSQLExpression;
    private QueryValueExpression updatedSQLExpression;
    private Button addFunctionExpressionButton;
    private Button addCaseExpressionButton;
    private Button addCastExpressionButton;
    private Button addConstantExpressionButton;
    private Button addSubQueryButton;
    private Button expressionsConnectedByOperatorButton;
    private SQLDomainModel sqlDomainModel;

    public MainExpressionPage(SQLDomainModel domainModel, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_MAIN_EXPRESSION_HEADING);
        this.setTitle(Messages._UI_WIZARD_MAIN_EXPRESSION_HEADING);
        this.setDescription(Messages._UI_WIZARD_MAIN_EXPRESSION_EXPL);
        this.updatedSQLExpression = this.inputSQLExpression = sqlExpr;
        this.sqlDomainModel = domainModel;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainPanel, "org.eclipse.datatools.sqltools.sqlbuilder.sqle0010");
        GridLayout mainPanelLayout = new GridLayout();
        mainPanel.setLayout((Layout)mainPanelLayout);
        this.createExpressionComponentsGroup(mainPanel);
        this.setControl((Control)mainPanel);
    }

    private void createExpressionComponentsGroup(Composite mainPanel) {
        VendorHelper vendorHelper;
        Composite expressionButtonsPanel = new Composite(mainPanel, 0);
        GridLayout expressionButtonsPanelLayout = new GridLayout();
        expressionButtonsPanel.setLayout((Layout)expressionButtonsPanelLayout);
        expressionButtonsPanel.setLayoutData((Object)ViewUtility.createFill());
        this.addFunctionExpressionButton = new Button(expressionButtonsPanel, 16);
        this.addFunctionExpressionButton.setText(Messages._UI_RADIO_FUNCTION);
        this.addFunctionExpressionButton.setLayoutData((Object)ViewUtility.createVerticalFill());
        this.addFunctionExpressionButton.addSelectionListener((SelectionListener)this);
        this.addFunctionExpressionButton.setSelection(true);
        this.addCaseExpressionButton = new Button(expressionButtonsPanel, 16);
        this.addCaseExpressionButton.setText(Messages._UI_RADIO_CASE);
        this.addCaseExpressionButton.setLayoutData((Object)ViewUtility.createVerticalFill());
        this.addCaseExpressionButton.addSelectionListener((SelectionListener)this);
        this.addCastExpressionButton = new Button(expressionButtonsPanel, 16);
        this.addCastExpressionButton.setText(Messages._UI_RADIO_CAST);
        this.addCastExpressionButton.setLayoutData((Object)ViewUtility.createVerticalFill());
        this.addCastExpressionButton.addSelectionListener((SelectionListener)this);
        if (!(this.sqlDomainModel == null || this.sqlDomainModel.getVendor() == null || (vendorHelper = this.sqlDomainModel.getVendor()).isDB2() || vendorHelper.isMSSQLServer() || vendorHelper.isCloudscape())) {
            this.addCastExpressionButton.setEnabled(false);
        }
        this.addConstantExpressionButton = new Button(expressionButtonsPanel, 16);
        this.addConstantExpressionButton.setText(Messages._UI_RADIO_CONSTANT);
        this.addConstantExpressionButton.setLayoutData((Object)ViewUtility.createVerticalFill());
        this.addConstantExpressionButton.addSelectionListener((SelectionListener)this);
        this.addSubQueryButton = new Button(expressionButtonsPanel, 16);
        this.addSubQueryButton.setText(Messages._UI_RADIO_SUBQUERY);
        this.addSubQueryButton.setLayoutData((Object)ViewUtility.createVerticalFill());
        this.addSubQueryButton.addSelectionListener((SelectionListener)this);
        this.expressionsConnectedByOperatorButton = new Button(expressionButtonsPanel, 16);
        this.expressionsConnectedByOperatorButton.setText(Messages._UI_RADIO_OPERATORS);
        this.expressionsConnectedByOperatorButton.setLayoutData((Object)ViewUtility.createVerticalFill());
        this.expressionsConnectedByOperatorButton.addSelectionListener((SelectionListener)this);
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public void widgetDefaultSelected(SelectionEvent se) {
    }

    public void widgetSelected(SelectionEvent se) {
    }

    public boolean canFlipToNextPage() {
        return this.addFunctionExpressionButton.getSelection() || this.addCaseExpressionButton.getSelection() || this.addCastExpressionButton.getSelection() || this.addConstantExpressionButton.getSelection() || this.addSubQueryButton.getSelection() || this.expressionsConnectedByOperatorButton.getSelection();
    }

    public String getExpressionType() {
        String type = this.addFunctionExpressionButton.getSelection() ? FUNCTION_EXPRESSION : (this.addCaseExpressionButton.getSelection() ? CASE_EXPRESSION : (this.addCastExpressionButton.getSelection() ? CAST_EXPRESSION : (this.addConstantExpressionButton.getSelection() ? CONSTANT_EXPRESSION : (this.addSubQueryButton.getSelection() ? SUBQUERY_EXPRESSION : (this.expressionsConnectedByOperatorButton.getSelection() ? EXPRESSIONS_BY_OPERATORS : "")))));
        return type;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setPageComplete(false);
        }
    }
}

