/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractPairwisePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class CheckLessThanValuesBasedOnPathAndPredicate
extends AbstractPairwisePlanNode {
    private final ValueComparator valueComparator = new ValueComparator();

    public CheckLessThanValuesBasedOnPathAndPredicate(SailConnection connection, Resource[] dataGraph, PlanNode parent, IRI predicate, StatementMatcher.Variable<Resource> subject, StatementMatcher.Variable<Value> object, SparqlFragment targetQueryFragment, Shape shape, ConstraintComponent constraintComponent, boolean produceValidationReports) {
        super(connection, dataGraph, parent, predicate, subject, object, targetQueryFragment, shape, constraintComponent, produceValidationReports);
    }

    @Override
    Set<Value> getInvalidValues(Set<Value> valuesByPath, Set<Value> valuesByPredicate) {
        HashSet<Value> ret = new HashSet<Value>();
        for (Value value : valuesByPath) {
            for (Value value1 : valuesByPredicate) {
                boolean lessThan = QueryEvaluationUtility.compare(value, value1, Compare.CompareOp.LT).orElse(false);
                if (lessThan) continue;
                ret.add(value);
            }
        }
        return ret;
    }
}

