/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import java.io.PrintWriter;
import java.net.URL;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaAnnotationHandler;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.util.SchemaUtil;
import org.eclipse.pde.internal.core.util.XMLComponentRegistry;
import org.xml.sax.helpers.DefaultHandler;

public class VirtualSchemaObject
implements ISchemaObject {
    private final String fName;
    private final Object fDescription;
    private int fType;

    public VirtualSchemaObject(String name, Object description, int type) {
        this.fName = name;
        this.fDescription = description;
        this.fType = type;
    }

    public String getDescription() {
        if (this.fDescription instanceof String) {
            return (String)this.fDescription;
        }
        if (this.fDescription instanceof IPluginExtensionPoint) {
            return this.getSchemaDescription((IPluginExtensionPoint)this.fDescription);
        }
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public ISchemaObject getParent() {
        return null;
    }

    public ISchema getSchema() {
        return null;
    }

    public void setParent(ISchemaObject parent) {
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void write(String indent, PrintWriter writer) {
    }

    public int getVType() {
        return this.fType;
    }

    public void setVType(int type) {
        this.fType = type;
    }

    private String getSchemaDescription(IPluginExtensionPoint point) {
        URL url;
        String description = null;
        if (point != null && (description = XMLComponentRegistry.Instance().getDescription(point.getFullId(), 2)) == null && (url = SchemaRegistry.getSchemaURL((IPluginExtensionPoint)point)) != null) {
            SchemaAnnotationHandler handler = new SchemaAnnotationHandler();
            SchemaUtil.parseURL((URL)url, (DefaultHandler)handler);
            description = handler.getDescription();
            XMLComponentRegistry.Instance().putDescription(point.getFullId(), description, 2);
        }
        return description;
    }
}

