/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.core.persistence.IPersistenceModelFactory;
import org.eclipse.rcptt.core.persistence.zip.PersistenceZipModelFactory;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class PersistenceFactoryManager {
    private List<IPersistenceModelFactory> managers = null;
    private static PersistenceFactoryManager instance = null;
    private IPersistenceModelFactory topPriority = null;

    private PersistenceFactoryManager() {
    }

    private void initialize() {
        if (this.managers != null) {
            return;
        }
        this.managers = new ArrayList<IPersistenceModelFactory>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.core.persistence");
        int top = -1;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            if ("persistence".equals(cfg.getName())) {
                try {
                    IPersistenceModelFactory provider = (IPersistenceModelFactory)cfg.createExecutableExtension("class");
                    String priority = cfg.getAttribute("priority");
                    int prio = 0;
                    if (priority != null) {
                        try {
                            prio = Integer.parseInt(priority);
                        }
                        catch (NumberFormatException e) {
                            RcpttPlugin.log(e);
                        }
                    }
                    if (prio > top) {
                        top = prio;
                        this.topPriority = provider;
                    }
                    this.managers.add(provider);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public IPersistenceModelFactory getDefaultFactory() {
        if (this.topPriority != null) {
            return this.topPriority;
        }
        return new PersistenceZipModelFactory();
    }

    public synchronized IPersistenceModelFactory[] getFactories() {
        this.initialize();
        return this.managers.toArray(new IPersistenceModelFactory[this.managers.size()]);
    }

    public static synchronized PersistenceFactoryManager getInstance() {
        if (instance == null) {
            instance = new PersistenceFactoryManager();
        }
        return instance;
    }
}

