/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.SuperContext;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.scenario.UnresolvedContext;
import org.eclipse.rcptt.core.scenario.UnresolvedVerification;
import org.eclipse.rcptt.core.utils.ModelCycleDetector;
import org.eclipse.rcptt.core.utils.SortingUtils;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.ecl.debug.core.DebuggerTransport;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.EmptySuperContextExecutable;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.ExecutionSession;
import org.eclipse.rcptt.internal.launching.GroupExecutable;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.Q7Process;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.internal.launching.TestEngineManager;
import org.eclipse.rcptt.internal.launching.TestSuiteExecutable;
import org.eclipse.rcptt.internal.launching.UnresolvedContextExecutable;
import org.eclipse.rcptt.internal.launching.UnresolvedVerificationExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclContextExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclDebugContextExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclDebugTestExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclDebugVerificationExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclScenarioExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclVerificationExecutable;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.ILaunchListener;
import org.eclipse.rcptt.launching.TestCaseDebugger;

public class Q7LaunchManager {
    public static final String Q7_TEST_SUITE_LAUNCH_ID = "org.eclipse.rcptt.launching.scenarios";
    private static boolean headless = false;
    private final Map<String, ExecThread> threads = new HashMap<String, ExecThread>();
    private final List<ILaunchListener> listeners;
    private final List<ExecutionSession> sessions = new ArrayList<ExecutionSession>();
    private static final String EXPT_ID = "org.eclipse.rcptt.launching.listeners";
    private static final String ATTR_CLASS = "class";
    private static final String PREFERENCE_HISTORY_MAX_EXECUTIONS_COUNT = "history_max_executions_count";
    private static final int HISTORY_MAX_EXECUTIONS_DEFAULT = 30;
    private boolean debuggingActive = false;

    public static boolean isConnectionException(IStatus status) {
        return status.getMessage().equals("Connection reset") || status.getMessage().equals("Connection refused: connect");
    }

    public static void makeHeadless() {
        headless = true;
    }

    public static synchronized Q7LaunchManager getInstance() {
        if (SingletonHolder.INSTANCE == null) {
            SingletonHolder.INSTANCE = new Q7LaunchManager();
        }
        return SingletonHolder.INSTANCE;
    }

    private Q7LaunchManager() {
        IConfigurationElement[] elements;
        ArrayList<ILaunchListener> list = new ArrayList<ILaunchListener>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String uiAttr = element.getAttribute("ui");
            if (!headless || !"true".equals(uiAttr)) {
                try {
                    ILaunchListener listener = (ILaunchListener)element.createExecutableExtension(ATTR_CLASS);
                    list.add(listener);
                }
                catch (CoreException e) {
                    Q7LaunchingPlugin.log(e);
                }
            }
            ++n2;
        }
        this.listeners = list;
    }

    public synchronized boolean isRunning() {
        return !this.threads.isEmpty();
    }

    public synchronized void stop(IStatus result) {
        for (String launch : new HashSet<String>(this.threads.keySet())) {
            ExecThread thread = this.threads.get(launch);
            if (thread == null) continue;
            thread.stop(result);
            this.threads.remove(launch);
        }
    }

    public synchronized void addListener(ILaunchListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ILaunchListener listener) {
        this.listeners.add(listener);
    }

    public void execute(IQ7NamedElement[] elements, AutLaunch aut, Q7TestLaunch launch, IWorkspaceFinder finder, Map<IQ7NamedElement, List<List<String>>> namedVariants, BiFunction<String, Integer, DebuggerTransport> debugTransport) throws CoreException {
        if (ModelCycleDetector.hasCycles((IQ7NamedElement[])elements)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Can't execute testcases/testsuites. Circles detected."));
        }
        if (finder == null) {
            finder = WorkspaceFinder.getInstance();
        }
        Q7Process process = new Q7Process((ILaunch)launch, aut, debugTransport);
        ExecutableFactory executableFabric = new ExecutableFactory(aut, finder, process.getDebugger());
        Executable[] executables = executableFabric.map(elements, namedVariants, aut.getCapability());
        if (executableFabric.unresolvedItems.size() > 0 && !this.checkContinueOnUnresolved()) {
            return;
        }
        ExecutionSession session = new ExecutionSession(launch.getLaunchConfiguration().getName(), executables, aut, launch);
        int maxEntries = this.getMaxHistoryEntries();
        while (this.sessions.size() >= maxEntries) {
            ExecutionSession rSession = this.sessions.remove(0);
            rSession.dispose();
        }
        if (!this.cancelDebugExecution(aut, null)) {
            launch.terminate();
            return;
        }
        launch.setSession(session);
        this.execute(session, process);
    }

    private boolean checkContinueOnUnresolved() {
        Status status = new Status(4, "org.eclipse.rcptt.launching", 123129, "There are unresolved test suite items. Build the project to find them.", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (prompter != null) {
            try {
                Object result = prompter.handleStatus((IStatus)status, null);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(e);
            }
        }
        return true;
    }

    public boolean cancelDebugExecution(AutLaunch aut, Object shell) throws DebugException {
        ArrayList<ExecutionSession> toDispose = new ArrayList<ExecutionSession>();
        for (ExecutionSession rSession : this.sessions) {
            if (!rSession.isDebugging(aut)) continue;
            toDispose.add(rSession);
        }
        if (toDispose.size() > 0 && !this.checkCancelDebugExecutionStatus(shell)) {
            return false;
        }
        this.sessions.removeAll(toDispose);
        for (ExecutionSession executionSession : toDispose) {
            executionSession.getLaunch().terminate();
            while (executionSession.isRunning()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Q7LaunchingPlugin.log(e);
                }
            }
        }
        return true;
    }

    private boolean checkCancelDebugExecutionStatus(Object shell) {
        Status status = new Status(1, "org.eclipse.rcptt.launching", 7707, "Debug session are active.", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (prompter != null) {
            try {
                Object result = prompter.handleStatus((IStatus)status, shell);
                if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                    return false;
                }
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(e);
            }
        }
        return true;
    }

    public int getMaxHistoryEntries() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.rcptt.launching");
        int count = node.getInt(PREFERENCE_HISTORY_MAX_EXECUTIONS_COUNT, 0);
        if (count == 0) {
            count = 30;
        }
        return count;
    }

    public void setMaxHistoryEntries(int maxEntries) {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.rcptt.launching");
        node.put(PREFERENCE_HISTORY_MAX_EXECUTIONS_COUNT, "" + maxEntries);
    }

    public IExecutionSession[] getExecutionSessions() {
        return this.sessions.toArray(new IExecutionSession[this.sessions.size()]);
    }

    public boolean removeExecutionSession(IExecutionSession session) {
        ExecutionSession es = (ExecutionSession)session;
        boolean result = this.sessions.remove(es);
        if (result) {
            es.dispose();
        }
        return result;
    }

    public void shutdown() {
        for (ExecutionSession session : this.sessions) {
            session.dispose();
        }
    }

    private synchronized void execute(ExecutionSession session, Q7Process process) {
        String launchId = process.getLaunch().getLaunchConfiguration().getName();
        SessionRunnable sessionRunnable = new SessionRunnable(launchId, session, process);
        this.execute(launchId, session, sessionRunnable);
    }

    public void execute(String launchId, ExecutionSession session, Runnable runnable) {
        this.sessions.add(session);
        ExecThread existing = this.threads.get(launchId);
        if (existing != null) {
            existing.stop((IStatus)new Status(8, "org.eclipse.rcptt.core", "Launching execution of " + launchId));
        }
        ExecThread execThread = new ExecThread(session, runnable, launchId);
        this.threads.put(launchId, execThread);
        execThread.start();
    }

    public static boolean isTestSuiteLauch(ILaunch launch) {
        if (launch != null && launch.getLaunchConfiguration() != null) {
            try {
                return launch.getLaunchConfiguration().getType().getIdentifier().equals(Q7_TEST_SUITE_LAUNCH_ID);
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(e);
            }
        }
        return false;
    }

    private void updateSessionCounters(ExecutionSession session, IStatus status) {
        if (!status.isOK()) {
            session.oneFailed();
        } else {
            session.oneFinished();
        }
    }

    public synchronized boolean isDebuggingActive() {
        return this.debuggingActive;
    }

    private void updateDebuggingActive(IExecutionSession exclude) {
        for (IExecutionSession iExecutionSession : this.sessions) {
            if (!iExecutionSession.isRunning() || iExecutionSession == exclude) continue;
            IExecutable[] iExecutableArray = iExecutionSession.getExecutables();
            int n = iExecutableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutable e = iExecutableArray[n2];
                if (e.isDebug()) {
                    this.debuggingActive = true;
                    return;
                }
                ++n2;
            }
        }
        this.debuggingActive = false;
    }

    public synchronized boolean isElementUnderDebugging(IQ7Element element) {
        for (ExecutionSession es : this.sessions) {
            if (!es.isRunning()) continue;
            Executable[] executableArray = es.getExecutables();
            int n = executableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Executable e = executableArray[n2];
                if (e.isDebug() && e.getActualElement().getResource().equals((Object)element.getResource())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private synchronized void fireStarted(IExecutionSession session) {
        this.updateDebuggingActive(null);
        for (ILaunchListener listener : this.listeners) {
            listener.started(session);
        }
    }

    private synchronized void fireLaunchStatusChanged(IExecutable ... executable) {
        for (ILaunchListener listener : this.listeners) {
            listener.launchStatusChanged(executable);
        }
    }

    private synchronized void fireFinished(IExecutionSession session) {
        this.updateDebuggingActive(session);
        for (ILaunchListener listener : this.listeners) {
            listener.finished();
        }
    }

    public synchronized boolean isDebuggingActive(AutLaunch aut) {
        for (ExecutionSession s : this.sessions) {
            if (!s.isDebugging(aut)) continue;
            return true;
        }
        return false;
    }

    private static class ContextVariant {
        List<String> name;
        Map<IContext, IContext> choices;

        ContextVariant() {
            this.name = new ArrayList<String>();
            this.choices = new HashMap<IContext, IContext>();
        }

        ContextVariant(String name, IContext superContext, IContext childContext) {
            this.name = ImmutableList.of((Object)name);
            this.choices = ImmutableMap.of((Object)superContext, (Object)childContext);
        }

        ContextVariant(ContextVariant first, ContextVariant second) {
            this.name = ImmutableList.builder().addAll(first.name).addAll(second.name).build();
            this.choices = ImmutableMap.builder().putAll(first.choices).putAll(second.choices).build();
        }
    }

    private static class ExecThread {
        public final ExecutionSession session;
        public final Thread thread;
        public final Job job;
        private boolean complete = false;

        public ExecThread(final ExecutionSession session, final Runnable runnable, String launchId) {
            this.session = session;
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            runnable.run();
                        }
                        catch (Throwable e) {
                            session.stop(RcpttPlugin.createStatus((Throwable)e));
                            complete = true;
                        }
                    }
                    finally {
                        complete = true;
                    }
                }
            }, "RCPTT Execution-" + launchId);
            this.job = new Job("Executing " + launchId){

                /*
                 * Exception decompiling
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
        }

        public void start() {
            this.job.schedule();
        }

        public void stop(IStatus result) {
            this.session.stop(result);
            this.job.cancel();
        }
    }

    public static class ExecutableFactory {
        private final AutLaunch launch;
        private final IWorkspaceFinder finder;
        private final TestCaseDebugger debugger;
        private final Set<ITestSuite> unresolvedItems = new HashSet<ITestSuite>();

        public ExecutableFactory(AutLaunch launch, IWorkspaceFinder finder, TestCaseDebugger debugger) {
            this.launch = launch;
            this.finder = finder;
            this.debugger = debugger;
        }

        private Executable makeContextExecutable(IContext context, ContextVariant variant) throws ModelException {
            boolean debug = this.debugger != null;
            NamedElement element = context.getNamedElement();
            if (element instanceof SuperContext) {
                return new EmptySuperContextExecutable(this.launch, context, debug);
            }
            if (element instanceof GroupContext) {
                ArrayList<IContext> children = new ArrayList<IContext>();
                for (String contextId : ((GroupContext)element).getContextReferences()) {
                    children.add(RcpttCore.getInstance().findContext((IQ7NamedElement)context, false, contextId, this.finder));
                }
                ArrayList<Executable> plan = new ArrayList<Executable>();
                this.addContextExecutables(plan, children, variant);
                EclContextExecutable root = !debug ? new EclContextExecutable(this.launch, context, debug) : new EclDebugContextExecutable(this.launch, context, this.debugger);
                return new GroupExecutable(root, plan);
            }
            if (element instanceof UnresolvedContext) {
                return new UnresolvedContextExecutable(this.launch, context, debug);
            }
            return !debug ? new EclContextExecutable(this.launch, context, debug) : new EclDebugContextExecutable(this.launch, context, this.debugger);
        }

        private void addContextExecutables(Collection<Executable> plan, List<IContext> contexts, ContextVariant variant) throws ModelException {
            for (IContext c : contexts) {
                while (variant.choices.containsKey(c)) {
                    c = variant.choices.get(c);
                }
                plan.add(this.makeContextExecutable(c, variant));
            }
        }

        private Executable makeVerificationExecutable(IVerification verification, ExecutionPhase phase) throws ModelException {
            boolean debug;
            boolean bl = debug = this.debugger != null;
            if (verification.getNamedElement() instanceof UnresolvedVerification) {
                return new UnresolvedVerificationExecutable(this.launch, verification, debug, phase);
            }
            return !debug ? new EclVerificationExecutable(this.launch, verification, debug, phase) : new EclDebugVerificationExecutable(this.launch, verification, this.debugger, phase);
        }

        private void addVerificationExecutables(Collection<Executable> plan, Executable parent, IVerification[] verifications, String verificationPhase, ExecutionPhase phase) {
            IVerification[] iVerificationArray = verifications;
            int n = verifications.length;
            int n2 = 0;
            while (n2 < n) {
                IVerification v = iVerificationArray[n2];
                try {
                    if (v.getType().supportsPhase(verificationPhase)) {
                        plan.add(this.makeVerificationExecutable(v, phase));
                    }
                }
                catch (ModelException e) {
                    Q7LaunchingPlugin.log("Failed to populate verifications for executable: " + parent.getName(), e);
                }
                ++n2;
            }
        }

        private List<ContextVariant> getContextVariants(IContext context) {
            try {
                NamedElement element = context.getNamedElement();
                if (element instanceof SuperContext) {
                    SuperContext superContext = (SuperContext)element;
                    ArrayList<ContextVariant> variants = new ArrayList<ContextVariant>();
                    for (String contextRef : superContext.getContextReferences()) {
                        IContext result = RcpttCore.getInstance().findContext((IQ7NamedElement)context, false, contextRef, this.finder);
                        for (ContextVariant subVariant : this.getContextVariants(result)) {
                            if (result == null) continue;
                            ContextVariant selectResultVariant = new ContextVariant(result.getElementName(), context, result);
                            variants.add(new ContextVariant(selectResultVariant, subVariant));
                        }
                    }
                    if (!variants.isEmpty()) {
                        return variants;
                    }
                } else if (element instanceof GroupContext) {
                    ArrayList<IContext> children = new ArrayList<IContext>();
                    for (String contextId : ((GroupContext)element).getContextReferences()) {
                        children.add(RcpttCore.getInstance().findContext((IQ7NamedElement)context, false, contextId, this.finder));
                    }
                    return this.getContextVariants(children);
                }
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
            return ImmutableList.of((Object)new ContextVariant());
        }

        private List<ContextVariant> getContextVariants(Collection<IContext> contexts) {
            ArrayList<ContextVariant> variants = new ArrayList<ContextVariant>();
            variants.add(new ContextVariant());
            for (IContext context : contexts) {
                List<ContextVariant> ctxVariants = this.getContextVariants(context);
                ArrayList<ContextVariant> oldVariants = variants;
                variants = new ArrayList(variants.size() * ctxVariants.size());
                for (ContextVariant oldVariant : oldVariants) {
                    for (ContextVariant ctxVariant : ctxVariants) {
                        variants.add(new ContextVariant(oldVariant, ctxVariant));
                    }
                }
            }
            return variants;
        }

        private List<Executable> makeExecutionPlans(ITestCase test, IContext[] contexts, IVerification[] verifications, List<List<String>> supportedVariants) {
            if (contexts == null) {
                contexts = new IContext[]{};
            }
            if (verifications == null) {
                verifications = new IVerification[]{};
            }
            ArrayList<Executable> result = new ArrayList<Executable>();
            for (ContextVariant variant : this.getContextVariants(Arrays.asList(contexts))) {
                ArrayList<Executable> plan = new ArrayList<Executable>();
                if (supportedVariants != null && !supportedVariants.contains(variant.name)) continue;
                EclScenarioExecutable parent = this.debugger == null ? new EclScenarioExecutable(this.launch, test) : new EclDebugTestExecutable(this.launch, test, this.debugger);
                parent.setVariantName(Lists.newArrayList(variant.name));
                this.addVerificationExecutables(plan, parent, verifications, "start", ExecutionPhase.START);
                try {
                    this.addContextExecutables(plan, Lists.newArrayList((Object[])contexts), variant);
                }
                catch (ModelException e) {
                    Q7LaunchingPlugin.log("Failed to populate contexts for executable: " + parent.getName(), e);
                }
                this.addVerificationExecutables(plan, parent, verifications, "run", ExecutionPhase.RUN);
                plan.add(parent);
                this.addVerificationExecutables(plan, parent, verifications, "finish", ExecutionPhase.FINISH);
                result.add(plan.size() > 1 ? new GroupExecutable(parent, plan) : parent);
            }
            return result;
        }

        public Executable[] map(IQ7NamedElement[] elements, Map<IQ7NamedElement, List<List<String>>> namedVariants, String capability) throws CoreException {
            ArrayList<Executable> executables = new ArrayList<Executable>();
            boolean debug = this.debugger != null;
            int i = 0;
            while (i < elements.length) {
                IQ7NamedElement element = elements[i];
                List<List<String>> supportedVariants = null;
                if (namedVariants != null) {
                    supportedVariants = namedVariants.get(element);
                }
                try {
                    if (element instanceof ITestCase) {
                        ITestCase test = (ITestCase)element;
                        IContext[] contexts = RcpttCore.getInstance().getContexts(test, this.finder, false, capability);
                        IVerification[] verifications = RcpttCore.getInstance().getVerifications(test, this.finder, false);
                        assert (!Arrays.asList(verifications).contains(null)) : "Null verification in " + test.getElementName();
                        executables.addAll(this.makeExecutionPlans(test, contexts, verifications, supportedVariants));
                    } else if (element instanceof ITestSuite) {
                        ITestSuite suite = (ITestSuite)element;
                        ISearchScope scope = Q7SearchCore.getSearchScope((ITestSuite)suite);
                        ArrayList<IQ7NamedElement> testSuiteItems = new ArrayList<IQ7NamedElement>();
                        TestSuiteItem[] testSuiteItemArray = suite.getItems();
                        int n = testSuiteItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TestSuiteItem item = testSuiteItemArray[n2];
                            IQ7NamedElement q7Element = Q7SearchCore.getTestSuiteItemElement((TestSuiteItem)item, (ISearchScope)scope);
                            if (q7Element == null) {
                                this.unresolvedItems.add(suite);
                            } else {
                                testSuiteItems.add(q7Element);
                            }
                            ++n2;
                        }
                        if (!suite.getTestSuite().isManuallyOrdered()) {
                            SortingUtils.sortNamedElements(testSuiteItems);
                        }
                        Executable[] children = this.map(testSuiteItems.toArray(new IQ7NamedElement[testSuiteItems.size()]), namedVariants, capability);
                        executables.add(new TestSuiteExecutable(this.launch, (ITestSuite)element, children, debug));
                    } else if (element instanceof IContext) {
                        IContext context = (IContext)element;
                        for (ContextVariant variant : this.getContextVariants(context)) {
                            executables.add(this.makeContextExecutable(context, variant));
                        }
                    } else {
                        IVerification verification = (IVerification)element;
                        executables.add(this.debugger == null ? new EclVerificationExecutable(this.launch, verification, debug, ExecutionPhase.AUTO) : new EclDebugVerificationExecutable(this.launch, verification, this.debugger, ExecutionPhase.AUTO));
                    }
                }
                catch (Throwable e) {
                    throw new CoreException(RcpttPlugin.createStatus((String)("Failed to process " + element.getName()), (Throwable)e));
                }
                ++i;
            }
            i = 0;
            while (i < executables.size()) {
                if (!(executables.get(i) instanceof TestSuiteExecutable)) {
                    executables.set(i, new PrepareExecutionWrapper(this.launch, (Executable)executables.get(i)));
                }
                ++i;
            }
            return executables.toArray(new Executable[executables.size()]);
        }
    }

    public static class SessionRunnable
    implements Runnable,
    IDebugEventSetListener {
        private final String launchId;
        private final ExecutionSession session;
        private final Q7Process q7Process;

        public SessionRunnable(String launchId, ExecutionSession session, Q7Process q7Process) {
            this.launchId = launchId;
            this.session = session;
            this.q7Process = q7Process;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                Object source = event.getSource();
                if (this.q7Process == source && event.getKind() == 8) {
                    Q7LaunchManager.getInstance().stop((IStatus)new Status(8, "org.eclipse.rcptt.launching", "Aut has been terminated"));
                }
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                this.session.resetCounters();
                this.session.setStartTime(new Date());
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
                Executable[] executables = this.session.getExecutables();
                Q7LaunchManager.getInstance().fireStarted(this.session);
                TestEngineManager.getInstance().fireSessionStarted(this.session);
                IStatus result = Status.OK_STATUS;
                try {
                    try {
                        ArrayList<Executable> massUpdateOnTerminate = new ArrayList<Executable>();
                        Executable.Listener listener = new Executable.Listener(){

                            @Override
                            public void onStatusChange(Executable executable) {
                                Q7LaunchManager.getInstance().fireLaunchStatusChanged(executable);
                                if (executable.getStatus() == IExecutable.State.RUNNING) {
                                    session.setActive(executable);
                                }
                            }

                            @Override
                            public void updateSessionCounters(Executable executable, IStatus status) {
                                Q7LaunchManager.getInstance().updateSessionCounters(session, status);
                            }
                        };
                        Executable[] executableArray = executables;
                        int n = executables.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Executable executable = executableArray[n2];
                            if (!this.session.isRunning()) {
                                massUpdateOnTerminate.add(executable);
                                executable.cancel(this.session.getResultStatus());
                            } else {
                                executable.addListener(listener);
                                try {
                                    executable.executeAndRememberResult();
                                    if (result.isOK()) {
                                        result = executable.getResultStatus();
                                    }
                                }
                                catch (Throwable throwable) {
                                    executable.removeListener(listener);
                                    this.session.setActive(null);
                                    Q7LaunchManager.getInstance().fireLaunchStatusChanged(executable);
                                    throw throwable;
                                }
                                executable.removeListener(listener);
                                this.session.setActive(null);
                                Q7LaunchManager.getInstance().fireLaunchStatusChanged(executable);
                                Q7LaunchManager.getInstance().fireLaunchStatusChanged(executable);
                            }
                            ++n2;
                        }
                        if (massUpdateOnTerminate.size() > 0) {
                            Q7LaunchManager.getInstance().fireLaunchStatusChanged(massUpdateOnTerminate.toArray(new Executable[massUpdateOnTerminate.size()]));
                        }
                        TestEngineManager.getInstance().fireSessionCompleted(this.session);
                    }
                    catch (Throwable e) {
                        result = RcpttPlugin.createStatus((Throwable)e);
                        Preconditions.checkNotNull((Object)result);
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        Q7LaunchManager q7LaunchManager = Q7LaunchManager.getInstance();
                        synchronized (q7LaunchManager) {
                            Q7LaunchManager.getInstance().threads.remove(this.launchId);
                        }
                        this.session.stop(result);
                        this.session.setEndTime(new Date());
                        Q7LaunchManager.getInstance().fireFinished(this.session);
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    Preconditions.checkNotNull((Object)result);
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    Q7LaunchManager q7LaunchManager = Q7LaunchManager.getInstance();
                    synchronized (q7LaunchManager) {
                        Q7LaunchManager.getInstance().threads.remove(this.launchId);
                    }
                    this.session.stop(result);
                    this.session.setEndTime(new Date());
                    Q7LaunchManager.getInstance().fireFinished(this.session);
                    throw throwable;
                }
                Preconditions.checkNotNull((Object)result);
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                Q7LaunchManager q7LaunchManager = Q7LaunchManager.getInstance();
                synchronized (q7LaunchManager) {
                    Q7LaunchManager.getInstance().threads.remove(this.launchId);
                }
                this.session.stop(result);
                this.session.setEndTime(new Date());
                Q7LaunchManager.getInstance().fireFinished(this.session);
            }
        }
    }

    private static class SingletonHolder {
        private static Q7LaunchManager INSTANCE = null;

        private SingletonHolder() {
        }
    }
}

