/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.PreferenceInitializer;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class Utils {
    private static final String[] PREFERRED_AUTH_METHODS = new String[]{"gssapi-with-mic", "publickey", "password", "keyboard-interactive"};
    private static final String[] PREFERRED_KEX_METHODS = new String[]{"diffie-hellman-group1-sha1", "diffie-hellman-group14-sha1", "diffie-hellman-group-exchange-sha1", "diffie-hellman-group-exchange-sha256"};
    private static final String[] PREFERRED_MAC_METHODS = new String[]{"hmac-md5", "hmac-sha1", "hmac-sha2-256", "hmac-sha1-96", "hmac-md5-96"};

    public static String getDefaultAuthMethods() {
        return Utils.getDefaultMethods(PREFERRED_AUTH_METHODS);
    }

    public static String getDefaultKEXMethods() {
        return Utils.getDefaultMethods(PREFERRED_KEX_METHODS);
    }

    public static String getDefaultMACMethods() {
        return Utils.getDefaultMethods(PREFERRED_MAC_METHODS);
    }

    private static String getDefaultMethods(String[] methods) {
        Object defaultValue = methods[0];
        int i = 1;
        while (i < methods.length) {
            defaultValue = (String)defaultValue + "," + methods[i];
            ++i;
        }
        return defaultValue;
    }

    public static String loadPrivateKeys(JSch jsch, String current_pkeys) {
        org.eclipse.core.runtime.Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        String ssh_home = preferences.getString("SSH2HOME");
        String pkeys = preferences.getString("PRIVATEKEY");
        if (ssh_home.length() == 0) {
            ssh_home = PreferenceInitializer.SSH_HOME_DEFAULT;
        }
        String[] pkey = pkeys.split(",");
        String[] _pkey = current_pkeys.split(",");
        Object result = "";
        String[] stringArray = pkey;
        int n = pkey.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            File file = new File(p);
            if (!file.isAbsolute()) {
                file = new File(ssh_home, p);
            }
            if (file.exists()) {
                boolean notyet = true;
                String[] stringArray2 = _pkey;
                int n3 = _pkey.length;
                int n4 = 0;
                while (n4 < n3) {
                    String _p = stringArray2[n4];
                    if (p.equals(_p)) {
                        notyet = false;
                        break;
                    }
                    ++n4;
                }
                try {
                    if (notyet) {
                        jsch.addIdentity(file.getPath());
                    }
                    result = ((String)result).length() == 0 ? p : (String)result + "," + p;
                }
                catch (JSchException e) {
                    JSchCorePlugin.log(4, "An error occurred loading the SSH2 private keys", e);
                }
            }
            ++n2;
        }
        return result;
    }

    public static Session createSession(JSch jsch, String username, String hostname, int port) throws JSchException {
        if (port == -1) {
            port = 22;
        }
        Session session = jsch.getSession(username, hostname, port);
        Utils.setProxy(session);
        Hashtable<String, String> config = new Hashtable<String, String>();
        config.put("PreferredAuthentications", Utils.getEnabledPreferredAuthMethods());
        config.put("kex", Utils.getEnabledPreferredKEXMethods());
        config.put("mac.c2s", Utils.getEnabledPreferredMACMethods());
        config.put("mac.s2c", Utils.getEnabledPreferredMACMethods());
        session.setConfig(config);
        return session;
    }

    public static void setProxy(Session session) {
        Proxy proxy = Utils.getProxyForHost(session.getHost(), "SOCKS");
        if (proxy == null) {
            proxy = Utils.getProxyForHost(session.getHost(), "HTTPS");
        }
        if (proxy != null) {
            session.setProxy(proxy);
        }
    }

    private static int getPort(IProxyData data) {
        int port = data.getPort();
        if (port == -1) {
            if (data.getType().equals("HTTP")) {
                port = 80;
            } else if (data.getType().equals("HTTPS")) {
                port = 443;
            } else if (data.getType().equals("SOCKS")) {
                port = 1080;
            }
        }
        return port;
    }

    private static IProxyData getProxyData(String host, String type) {
        IProxyService proxyService = JSchCorePlugin.getPlugin().getProxyService();
        if (proxyService == null) {
            return null;
        }
        IProxyData data = proxyService.getProxyDataForHost(host, type);
        if (data == null || data.getHost() == null || Utils.getJSchProxyType(data) == null) {
            return null;
        }
        return data;
    }

    private static String getJSchProxyType(IProxyData data) {
        if (data.getType().equals("HTTPS")) {
            return "HTTP";
        }
        if (data.getType().equals("SOCKS")) {
            return "SOCKS5";
        }
        return null;
    }

    public static Proxy getProxyForHost(String host, String proxyType) {
        IProxyService proxyService = JSchCorePlugin.getPlugin().getProxyService();
        if (proxyService == null) {
            return null;
        }
        boolean useProxy = proxyService.isProxiesEnabled();
        if (!useProxy) {
            return null;
        }
        ProxyHTTP proxy = null;
        IProxyData data = Utils.getProxyData(host, proxyType);
        if (data == null) {
            return null;
        }
        String _type = Utils.getJSchProxyType(data);
        if (_type == null) {
            return null;
        }
        String _host = data.getHost();
        int _port = Utils.getPort(data);
        boolean useAuth = data.isRequiresAuthentication();
        String _user = "";
        String _pass = "";
        if (useAuth) {
            _user = data.getUserId();
            _pass = data.getPassword();
        }
        String proxyhost = _host + ":" + _port;
        if (_type.equals("HTTP")) {
            proxy = new ProxyHTTP(proxyhost);
            if (useAuth) {
                proxy.setUserPasswd(_user, _pass);
            }
        } else if (_type.equals("SOCKS5")) {
            proxy = new ProxySOCKS5(proxyhost);
            if (useAuth) {
                ((ProxySOCKS5)proxy).setUserPasswd(_user, _pass);
            }
        }
        return proxy;
    }

    public static void migrateSSH2Preferences() {
        org.eclipse.core.runtime.Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("org.eclipse.jsch.core.hasMigratedSsh2Preferences")) {
            preferences.setValue("org.eclipse.jsch.core.hasMigratedSsh2Preferences", true);
            Utils.migrateSSH2Preferences((Preferences)InstanceScope.INSTANCE.getNode(""));
        }
    }

    public static void migrateSSH2Preferences(Preferences node) {
        try {
            if (node.nodeExists("org.eclipse.team.cvs.ssh2")) {
                Preferences jschPrefs;
                Preferences ssh2Prefs = node.node("org.eclipse.team.cvs.ssh2");
                String oldHome = ssh2Prefs.get("CVSSSH2PreferencePage.SSH2HOME", null);
                String oldKey = ssh2Prefs.get("CVSSSH2PreferencePage.PRIVATEKEY", null);
                if (oldHome != null) {
                    jschPrefs = node.node(JSchCorePlugin.ID);
                    jschPrefs.put("SSH2HOME", oldHome);
                    ssh2Prefs.remove("CVSSSH2PreferencePage.SSH2HOME");
                }
                if (oldKey != null) {
                    jschPrefs = node.node(JSchCorePlugin.ID);
                    jschPrefs.put("PRIVATEKEY", oldKey);
                    ssh2Prefs.remove("CVSSSH2PreferencePage.PRIVATEKEY");
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static String getEnabledPreferredAuthMethods() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_AUTH_METHODS", Utils.getDefaultAuthMethods(), null);
    }

    public static String getAvailableSSHAgents() {
        IdentityRepository[] repositories = JSchCorePlugin.getPlugin().getPluggedInIdentityRepositries();
        Object s = "";
        int i = 0;
        while (i < repositories.length) {
            IdentityRepository c = repositories[i];
            s = (String)s + c.getName();
            if (i + 1 < repositories.length) {
                s = (String)s + ",";
            }
            ++i;
        }
        return s;
    }

    public static String getMethodsOrder() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_AUTH_METHODS_ORDER", Utils.getDefaultAuthMethods(), null);
    }

    public static void setEnabledPreferredAuthMethods(String methods, String order) {
        IPreferencesService service = Platform.getPreferencesService();
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_AUTH_METHODS", methods);
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_AUTH_METHODS_ORDER", order);
    }

    public static String getSelectedSSHAgent() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_SSHAGENT", "", null);
    }

    public static void setSelectedSSHAgents(String methods) {
        IPreferencesService service = Platform.getPreferencesService();
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_SSHAGENT", methods);
    }

    public static String getEnabledPreferredKEXMethods() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_KEX_METHODS", Utils.getDefaultKEXMethods(), null);
    }

    public static String getKEXMethodsOrder() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_KEX_METHODS_ORDER", Utils.getDefaultKEXMethods(), null);
    }

    public static void setEnabledPreferredKEXMethods(String methods, String order) {
        IPreferencesService service = Platform.getPreferencesService();
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_KEX_METHODS", methods);
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_KEX_METHODS_ORDER", order);
    }

    public static String getEnabledPreferredMACMethods() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_MAC_METHODS", Utils.getDefaultMACMethods(), null);
    }

    public static String getMACMethodsOrder() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_MAC_METHODS_ORDER", Utils.getDefaultMACMethods(), null);
    }

    public static void setEnabledPreferredMACMethods(String methods, String order) {
        IPreferencesService service = Platform.getPreferencesService();
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_MAC_METHODS", methods);
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_MAC_METHODS_ORDER", order);
    }
}

