/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JarSelectionValidator
implements ISelectionStatusValidator {
    private final Class<?>[] fAcceptedTypes;
    private final boolean fAllowMultipleSelection;

    public JarSelectionValidator(Class<?>[] acceptedTypes, boolean allowMultipleSelection) {
        Assert.isNotNull(acceptedTypes);
        this.fAcceptedTypes = acceptedTypes;
        this.fAllowMultipleSelection = allowMultipleSelection;
    }

    public IStatus validate(Object[] elements) {
        if (this.isValidSelection(elements)) {
            return Status.OK_STATUS;
        }
        return Status.error((String)"", null);
    }

    private boolean isValidSelection(Object[] selection) {
        if (selection.length == 0) {
            return false;
        }
        if (!this.fAllowMultipleSelection && selection.length != 1) {
            return false;
        }
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!this.isValid(o)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isValid(Object element) {
        Class<?>[] classArray = this.fAcceptedTypes;
        int n = this.fAcceptedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> acceptedType = classArray[n2];
            if (acceptedType.isInstance(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

