/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.internal.core.info.GeneralInformationCollector;
import org.eclipse.ui.PlatformUI;

public class AdvancedInfoService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        final IProcess finalContext = context;
        if (PlatformUI.isWorkbenchRunning()) {
            final boolean[] complete = new boolean[1];
            final CoreException[] error = new CoreException[1];
            Thread askForInfoThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            boolean mustClientShutdown = false;
                            if (TeslaBridge.getClient() == null) {
                                mustClientShutdown = true;
                                TeslaBridge.setup();
                            }
                            try {
                                try {
                                    TeslaBridge.makeScreenshot(true, "Capturing debug information");
                                    AdvancedInformation info = TeslaBridge.getClient().getAdvancedInformation(null);
                                    AdvancedInfoService.this.returnGeneralInfo(info, finalContext);
                                    ReportHelper.addSnapshotWithData((INodeBuilder)ReportManager.getCurrentReportNode(), (EObject)info);
                                }
                                catch (CoreException e) {
                                    error[0] = e;
                                    if (mustClientShutdown) {
                                        TeslaBridge.shutdown();
                                    }
                                    complete[0] = true;
                                }
                            }
                            finally {
                                if (mustClientShutdown) {
                                    TeslaBridge.shutdown();
                                }
                                complete[0] = true;
                            }
                        }
                    });
                }
            }, "get-advanced-info thread");
            askForInfoThread.start();
            askForInfoThread.join(10000L);
            if (!complete[0]) {
                askForInfoThread.interrupt();
                this.returnGeneralInfo(null, finalContext);
            }
            if (error[0] != null) {
                return error[0].getStatus();
            }
        } else {
            this.returnGeneralInfo(null, finalContext);
        }
        return Status.OK_STATUS;
    }

    private void returnGeneralInfo(AdvancedInformation info, IProcess finalContext) throws CoreException {
        if (info == null) {
            info = InfoFactory.eINSTANCE.createAdvancedInformation();
        }
        GeneralInformationCollector.collectInformation((AdvancedInformation)info);
        finalContext.getOutput().write((Object)info);
    }
}

