/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.jobs;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.internal.core.jobs.IJob;

public abstract class JobManager {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected final Thread processingThread = new Thread(this::run, this.processName());
    private final AtomicReference<Throwable> error;
    private int enableCount;
    private int awaitingClients;
    private final Object delaySignal;

    public JobManager() {
        this.processingThread.setDaemon(true);
        this.processingThread.setPriority(4);
        this.error = new AtomicReference();
        this.enableCount = 1;
        this.awaitingClients = 0;
        this.delaySignal = new Object();
    }

    private synchronized int awaitingJobsCount() {
        return this.processingThread.isAlive() ? this.jobEnd - this.jobStart + 1 : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public synchronized void disable() {
        --this.enableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJobs(String jobFamily) throws InterruptedException {
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                jobManager = this;
                synchronized (jobManager) {
                    while (this.processingThread.isAlive() && this.executing) {
                        this.wait(50L);
                    }
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int i = this.jobStart;
                while (i <= this.jobEnd) {
                    currentJob = this.awaitingJobs[i];
                    if (currentJob != null) {
                        this.awaitingJobs[i] = null;
                        if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                            this.awaitingJobs[++loc] = currentJob;
                        } else {
                            currentJob.cancel();
                        }
                    }
                    ++i;
                }
                this.jobStart = 0;
                this.jobEnd = loc;
            }
        }
        finally {
            this.enable();
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        this.notifyAll();
    }

    public synchronized boolean isJobWaiting(IJob request) {
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (request.equals(this.awaitingJobs[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress) {
        return this.performConcurrentJob(searchJob, waitingPolicy, progress, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress, long timeout) {
        block39: {
            searchJob.ensureReadyToRun();
            this.start();
            concurrentJobWork = 100;
            if (progress != null) {
                progress.beginTask("", concurrentJobWork);
            }
            status = false;
            if (this.awaitingJobsCount() <= 0) break block39;
            switch (waitingPolicy) {
                case 1: {
                    try {
                        this.disable();
                        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
                    }
                    finally {
                        this.enable();
                    }
                    return status;
                }
                case 2: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    start = System.currentTimeMillis();
                    subProgress = null;
                    totalWork = this.awaitingJobsCount();
                    if (progress != null && totalWork > 0) {
                        subProgress = new SubProgressMonitor(progress, concurrentJobWork / 2);
                        subProgress.beginTask("", totalWork);
                        concurrentJobWork /= 2;
                    }
                    if (totalWork > 0) {
                        var12_11 = this.delaySignal;
                        synchronized (var12_11) {
                            this.delaySignal.notify();
                        }
                    }
                    originalPriority = (t = this.processingThread).isAlive() != false ? t.getPriority() : -1;
                    try {
                        if (t != null) {
                            t.setPriority(Thread.currentThread().getPriority());
                        }
                        var14_13 = this;
                        synchronized (var14_13) {
                            ++this.awaitingClients;
                        }
                        previousJob = null;
                        while ((awaitingWork = this.awaitingJobsCount()) > 0 && (timeout == -1L || System.currentTimeMillis() - start < timeout)) {
                            if (subProgress != null && subProgress.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            currentJob = this.currentJob();
                            if (currentJob != null && currentJob != previousJob) {
                                if (subProgress != null) {
                                    subProgress.subTask(NLS.bind((String)"Files to index ${0}", (Object)Integer.toString(awaitingWork)));
                                    subProgress.worked(1);
                                }
                                previousJob = currentJob;
                            }
                            Thread.sleep(50L);
                        }
                        if (timeout == -1L || System.currentTimeMillis() - start <= timeout) ** GOTO lbl85
                        var18_17 = this;
                    }
                    catch (InterruptedException e) {
                        try {
                            Thread.currentThread().interrupt();
                            throw new OperationCanceledException();
                        }
                        catch (Throwable var17_20) {
                            var18_18 = this;
                            synchronized (var18_18) {
                                --this.awaitingClients;
                            }
                            if (t != null && originalPriority > -1 && t.isAlive()) {
                                t.setPriority(originalPriority);
                            }
                            throw var17_20;
                        }
                    }
                    synchronized (var18_17) {
                        --this.awaitingClients;
                    }
                    if (t != null && originalPriority > -1 && t.isAlive()) {
                        t.setPriority(originalPriority);
                    }
                    return false;
lbl85:
                    // 1 sources

                    var18_19 = this;
                    synchronized (var18_19) {
                        --this.awaitingClients;
                    }
                    if (t != null && originalPriority > -1 && t.isAlive()) {
                        t.setPriority(originalPriority);
                    }
                    if (subProgress == null) break;
                    subProgress.done();
                }
            }
        }
        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
        if (progress != null) {
            progress.done();
        }
        return status;
    }

    public abstract String processName();

    public void waitUntilReady(IProgressMonitor monitor) {
        this.performConcurrentJob(new WaitJob(), 3, monitor);
    }

    public void requestIfNotWaiting(IJob job) {
        if (!this.isJobWaiting(job)) {
            this.request(job);
        }
    }

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        this.notifyAll();
    }

    public synchronized void reset() throws InterruptedException {
        this.discardJobs(null);
        this.error.set(null);
        this.start();
    }

    private synchronized void start() {
        if (!this.processingThread.isAlive()) {
            this.processingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run() {
        long idlingStart = -1L;
        try {
            while (true) {
                JobManager jobManager;
                IJob job;
                if (this.processingThread == null) {
                    return;
                }
                Object object = this;
                synchronized (object) {
                    if (this.processingThread == null) {
                        continue;
                    }
                    job = this.currentJob();
                    if (job == null) {
                        if (idlingStart < 0L) {
                            idlingStart = System.currentTimeMillis();
                        } else {
                            this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        }
                        this.wait();
                    } else {
                        idlingStart = -1L;
                    }
                }
                if (job == null) {
                    this.notifyIdle(System.currentTimeMillis() - idlingStart);
                    object = this.delaySignal;
                    synchronized (object) {
                        this.delaySignal.wait(500L);
                    }
                }
                try {
                    object = this;
                    synchronized (object) {
                        this.executing = true;
                    }
                    job.execute(null);
                }
                catch (Throwable throwable) {
                    JobManager jobManager2 = this;
                    synchronized (jobManager2) {
                        this.executing = false;
                        this.notifyAll();
                    }
                    this.moveToNextJob();
                    boolean waitAC = false;
                    jobManager = this;
                    synchronized (jobManager) {
                        waitAC = this.awaitingClients == 0;
                    }
                    if (!waitAC) throw throwable;
                    Thread.sleep(50L);
                    throw throwable;
                }
                JobManager waitAC = this;
                synchronized (waitAC) {
                    this.executing = false;
                    this.notifyAll();
                }
                this.moveToNextJob();
                boolean waitAC2 = false;
                jobManager = this;
                synchronized (jobManager) {
                    waitAC2 = this.awaitingClients == 0;
                }
                if (!waitAC2) continue;
                Thread.sleep(50L);
            }
        }
        catch (Throwable e) {
            this.error.compareAndSet(null, e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private static final class WaitJob
    implements IJob {
        private WaitJob() {
        }

        @Override
        public boolean belongsTo(String jobFamily) {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void ensureReadyToRun() {
        }

        @Override
        public boolean execute(IProgressMonitor progress) {
            return false;
        }

        public String toString() {
            return "WAIT-UNTIL-READY-JOB";
        }
    }
}

