/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.emf.validation.ui.internal.ValidationUIPlugin;
import org.eclipse.emf.validation.ui.internal.console.ConsoleUtil;
import org.eclipse.emf.validation.ui.internal.l10n.ValidationUIMessages;
import org.eclipse.emf.validation.ui.internal.preferences.ValidationLiveProblemsDestination;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LiveValidationListener
implements IValidationListener {
    private static final String PLATFORM_NEWLINE = System.getProperty("line.separator");
    private static final String EP_UI_REGISTERED_CLIENT_CONTEXTS = "org.eclipse.emf.validation.ui.UIRegisteredClientContext";
    private static final String A_ID = "id";
    private static volatile Set<String> registeredClientContextIds;
    private static final Object clientContextsLock;
    private final OutputUtility outputUtility = new OutputUtility();

    static {
        clientContextsLock = new Object();
        LiveValidationListener.initializeClientContextIDs();
    }

    public void validationOccurred(ValidationEvent event) {
        if (event.getEvaluationMode() == EvaluationMode.LIVE && event.getSeverity() >= 2 && LiveValidationListener.isSupportedClientContexts(event.getClientContextIds())) {
            this.showProblemMessages(event);
        }
    }

    private static synchronized boolean isSupportedClientContexts(Collection<String> clientContextIds) {
        Set<String> registeredIds = registeredClientContextIds;
        for (String next : clientContextIds) {
            if (!registeredIds.contains(next)) continue;
            return true;
        }
        return false;
    }

    private static void initializeClientContextIDs() {
        registeredClientContextIds = new HashSet<String>();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(EP_UI_REGISTERED_CLIENT_CONTEXTS);
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement next = iConfigurationElementArray[n4];
                registeredClientContextIds.add(next.getAttribute(A_ID));
                ++n4;
            }
            ++n2;
        }
        IExtensionTracker extTracker = ValidationUIPlugin.getExtensionTracker();
        if (extTracker != null) {
            IExtensionChangeHandler extensionHandler = new IExtensionChangeHandler(){

                public void addExtension(IExtensionTracker tracker, IExtension extension) {
                    LiveValidationListener.addClientContextIDs(extension.getConfigurationElements());
                }

                public void removeExtension(IExtension extension, Object[] objects) {
                }
            };
            extTracker.registerHandler(extensionHandler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extPoint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addClientContextIDs(IConfigurationElement[] configs) {
        Object object = clientContextsLock;
        synchronized (object) {
            HashSet<String> registeredIds = new HashSet<String>(registeredClientContextIds);
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement next = iConfigurationElementArray[n2];
                registeredIds.add(next.getAttribute(A_ID));
                ++n2;
            }
            registeredClientContextIds = registeredIds;
        }
    }

    private void showProblemMessages(ValidationEvent event) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        ValidationLiveProblemsDestination destination = ValidationLiveProblemsDestination.getPreferenceSetting();
        boolean warningsInDialog = ValidationUIPlugin.getPlugin().getPluginPreferences().getBoolean("Validation.liveWarningsInDialog");
        String messages = this.getProblemMessages(event);
        Display display = Display.getCurrent();
        if (destination == ValidationLiveProblemsDestination.CONSOLE || !this.getOutputUtility().hasErrors() && !warningsInDialog || display == null) {
            if (messages.length() > 0) {
                this.println(ValidationUIMessages.Validation_problems);
                this.println(messages);
            }
            boolean showConsole = ValidationUIPlugin.getPlugin().getPluginPreferences().getBoolean("Validation.liveShowConsole");
            if (this.getOutputUtility().hasProblems() && showConsole) {
                this.showConsole();
            }
        } else if (destination == ValidationLiveProblemsDestination.DIALOG) {
            this.showLiveValidationDialog(event);
        }
    }

    private void showLiveValidationDialog(ValidationEvent event) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            IStatus[] details = LiveValidationListener.toStatusArray(event);
            String message = event.getSeverity() >= 4 ? ValidationUIMessages.Validation_liveError : null;
            final int dialogSeverity = event.matches(2) ? 2 : 1;
            IStatus primary = LiveValidationListener.getFirstStatus(details, event.getSeverity());
            Object toDisplay = details.length > 1 ? new MultiStatus(ValidationUIPlugin.getPlugin().getBundle().getSymbolicName(), 0, details, primary.getMessage(), null){

                public int getSeverity() {
                    return dialogSeverity;
                }
            } : new Status(dialogSeverity, primary.getPlugin(), primary.getCode(), primary.getMessage(), primary.getException());
            new LiveValidationDialog(Display.getCurrent().getActiveShell(), ValidationUIMessages.Validation_liveDialogTitle, message, (IStatus)toDisplay).open();
        }
    }

    private String getProblemMessages(ValidationEvent event) {
        StringBuffer buffer = new StringBuffer();
        this.getOutputUtility().appendProblems(event, buffer);
        return buffer.toString();
    }

    static IStatus getFirstStatus(IStatus[] statuses, int severity) {
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            if (element.matches(severity)) {
                return element;
            }
            ++n2;
        }
        return statuses[0];
    }

    private static IStatus[] toStatusArray(ValidationEvent event) {
        List results = event.getValidationResults();
        return results.toArray(new IStatus[results.size()]);
    }

    private OutputUtility getOutputUtility() {
        return this.outputUtility;
    }

    private void showConsole() {
        String category = ValidationUIMessages.Validation_outputProviderCategory;
        ConsoleUtil.showConsole(category);
    }

    private void println(String text) {
        String category = ValidationUIMessages.Validation_outputProviderCategory;
        ConsoleUtil.println(category, text);
    }

    private static class LiveValidationDialog
    extends ErrorDialog {
        private final IStatus status;

        public LiveValidationDialog(Shell parentShell, String dialogTitle, String message, IStatus status) {
            super(parentShell, dialogTitle, message, status, 15);
            this.status = status;
        }

        protected Control createDialogArea(Composite composite) {
            Composite result;
            if (this.status.getSeverity() < 2) {
                result = (Composite)this.createMessageArea(composite);
            } else {
                result = (Composite)super.createDialogArea(composite);
                final Button checkbox = new Button(result, 32);
                checkbox.setText(ValidationUIMessages.Validation_dontShowCheck);
                GridData data = new GridData(770);
                data.horizontalSpan = 2;
                checkbox.setLayoutData((Object)data);
                checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ValidationUIPlugin.getPlugin().getPluginPreferences().setValue("Validation.liveWarningsInDialog", !checkbox.getSelection());
                    }
                });
            }
            return result;
        }
    }

    private static class OutputUtility {
        private boolean hasErrors = false;
        private boolean hasProblems = false;

        private OutputUtility() {
        }

        void appendProblems(ValidationEvent event, StringBuffer output) {
            this.hasProblems = false;
            this.hasErrors = false;
            this.appendProblemsRecursive(LiveValidationListener.toStatusArray(event), output);
            if (this.hasErrors()) {
                output.append(ValidationUIMessages.Validation_liveError);
                output.append(PLATFORM_NEWLINE);
            }
        }

        boolean hasErrors() {
            return this.hasErrors;
        }

        boolean hasProblems() {
            return this.hasProblems;
        }

        private void appendProblemsRecursive(IStatus[] statuses, StringBuffer output) {
            IStatus[] iStatusArray = statuses;
            int n = statuses.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus next = iStatusArray[n2];
                if (!next.isOK()) {
                    String messagePattern;
                    switch (next.getSeverity()) {
                        case 4: {
                            this.hasProblems = true;
                            this.hasErrors = true;
                            messagePattern = ValidationUIMessages.Validation_error;
                            break;
                        }
                        case 2: {
                            this.hasProblems = true;
                            messagePattern = ValidationUIMessages.Validation_warn;
                            break;
                        }
                        default: {
                            messagePattern = ValidationUIMessages.Validation_note;
                        }
                    }
                    output.append(MessageFormat.format(messagePattern, next.getMessage()));
                    output.append(PLATFORM_NEWLINE);
                }
                if (next.isMultiStatus()) {
                    this.appendProblemsRecursive(next.getChildren(), output);
                }
                ++n2;
            }
        }
    }
}

