/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching.aut;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.Q7LaunchUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class AUTConnectionErrorDialog
extends MessageDialog {
    private static String DEFAULT_ERROR_MESSAGE = "Oops! Couldn't connect to the application.";
    private static String DIALOG_TITLE = "AUT Connection Error";
    private static String SHOW_FILES_QUESTION = "Would you like to view log file?";
    private static String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";

    private AUTConnectionErrorDialog(Shell parentShell, String message, boolean showLogFile) {
        super(parentShell, DIALOG_TITLE, null, AUTConnectionErrorDialog.getMessage(showLogFile, message), 1, AUTConnectionErrorDialog.getDialogButtonsLabels(showLogFile), 0);
    }

    private static String getMessage(boolean showLogFile, String errorMessage) {
        if (showLogFile) {
            return String.valueOf(errorMessage) + "\r\n\r\n" + SHOW_FILES_QUESTION;
        }
        return errorMessage;
    }

    private static String[] getDialogButtonsLabels(boolean showLogFile) {
        if (showLogFile) {
            return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        }
        return new String[]{IDialogConstants.OK_LABEL};
    }

    public static void showAUTConnectionError(Shell parentShell, IStatus status, ILaunchConfiguration launch) {
        String message = DEFAULT_ERROR_MESSAGE;
        if (status != null && !status.isOK() && !status.equals(Status.CANCEL_STATUS)) {
            message = status.getMessage();
        }
        if (status == null || !status.isOK() && !status.equals(Status.CANCEL_STATUS)) {
            AUTConnectionErrorDialog dialog;
            File logFile = AUTConnectionErrorDialog.getConfigLog(launch);
            if (logFile == null) {
                logFile = AUTConnectionErrorDialog.getWorkspaceLog(launch);
            }
            if ((dialog = new AUTConnectionErrorDialog(parentShell, message, logFile != null)).open() == 0) {
                AUTConnectionErrorDialog.openInEditor(logFile);
            }
        }
    }

    private static File getConfigLog(ILaunchConfiguration launch) {
        String filesLocation = Q7LaunchUtils.getConfigFilesLocation((ILaunchConfiguration)launch);
        File logFile = AUTConnectionErrorDialog.getLogFile(new File(filesLocation));
        if (logFile != null && logFile.exists() && logFile.isFile()) {
            return logFile;
        }
        return null;
    }

    private static File getWorkspaceLog(ILaunchConfiguration launch) {
        File file = Q7LaunchUtils.getWorkspaceMeta((ILaunchConfiguration)launch);
        if (file != null) {
            return AUTConnectionErrorDialog.getLogFile(file);
        }
        return null;
    }

    private static File getLogFile(File baseDirFile) {
        File lastModifiedFile = null;
        if (baseDirFile.exists()) {
            File[] files;
            File[] fileArray = files = baseDirFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".log");
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (lastModifiedFile == null || lastModifiedFile.lastModified() < file.lastModified()) {
                    lastModifiedFile = file;
                }
                ++n2;
            }
        }
        return lastModifiedFile;
    }

    private static void openInEditor(File fileToOpen) {
        if (fileToOpen != null && fileToOpen.exists() && fileToOpen.isFile()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (URI)fileToOpen.toURI(), (String)TEXT_EDITOR_ID, (boolean)true);
            }
            catch (PartInitException e) {
                Q7UIPlugin.log(e);
            }
        }
    }
}

