/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rcptt.core.ecl.parser.ast.Arg;
import org.eclipse.rcptt.core.ecl.parser.ast.BoolArg;
import org.eclipse.rcptt.core.ecl.parser.ast.Command;
import org.eclipse.rcptt.core.ecl.parser.ast.Comment;
import org.eclipse.rcptt.core.ecl.parser.ast.Id;
import org.eclipse.rcptt.core.ecl.parser.ast.LiteralArg;
import org.eclipse.rcptt.core.ecl.parser.ast.Pipeline;
import org.eclipse.rcptt.core.ecl.parser.ast.PipelineArg;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.ast.ScriptArg;
import org.eclipse.rcptt.core.ecl.scanner.EclScanner;
import org.eclipse.rcptt.core.ecl.scanner.EclToken;

public class EclScannerParser {
    private EclScanner scanner;
    private String script;
    private Deque<List<Comment>> commentStack = new LinkedList<List<Comment>>();
    private List<EclToken> buffer = new LinkedList<EclToken>();
    private EclToken lastConsumed = null;

    public static Script parse(String script) {
        EclScannerParser parser = new EclScannerParser(script);
        try {
            return parser.parse();
        }
        catch (ParseException parseException) {
            return new Script(script, 0, script.length());
        }
    }

    private EclScannerParser(String script) {
        this.scanner = new EclScanner(script, true, true);
        this.script = script;
    }

    public Script parse() throws ParseException {
        return this.script(EclToken.Type.Eof);
    }

    private void addComment(Comment comment) {
        this.commentStack.peek().add(comment);
    }

    private List<Comment> popComments() {
        return this.commentStack.pop();
    }

    private String text(int begin, int end) {
        return this.script.substring(begin, end);
    }

    private Script script(EclToken.Type terminal) {
        int begin = this.peek().begin;
        this.commentStack.push(new ArrayList());
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        EclToken current = this.peek();
        block6: while (this.peek().type != terminal) {
            this.consumeAll(EclToken.Type.Spacing);
            current = this.peek();
            if (current.type == EclToken.Type.Eof) break;
            switch (current.type) {
                case Linebreak: {
                    if (this.lastConsumed != null && (this.lastConsumed.type == EclToken.Type.SlComment || this.lastConsumed.type == EclToken.Type.MlComment) && this.peek((int)1).type == EclToken.Type.Identifier) {
                        Comment lastComment = this.commentStack.peek().get(this.commentStack.peek().size() - 1);
                        lastComment.nextCommandAt = this.peek((int)1).begin;
                    }
                    this.consume();
                    break;
                }
                case SlComment: {
                    this.addComment(this.glueComments());
                    break;
                }
                case MlComment: {
                    this.consume();
                    this.addComment(new Comment((String)current.value, current.begin, current.end));
                    break;
                }
                case Identifier: 
                case Variable: {
                    pipelines.add(this.pipeline());
                    break;
                }
                default: {
                    if (this.peek().type == terminal) continue block6;
                    this.consume();
                }
            }
        }
        int end = this.peek().type == EclToken.Type.Eof ? this.script.length() : this.peek().end;
        Script result = new Script(this.text(begin, end), begin, end);
        result.comments.addAll(this.popComments());
        result.pipelines.addAll(pipelines);
        return result;
    }

    private PipelineArg pipelineArg(EclToken name) {
        this.consumeOne(EclToken.Type.SquareOpen);
        Pipeline pipeline = this.pipeline();
        this.consumeAll(EclToken.Type.Spacing, EclToken.Type.Linebreak);
        if (this.peek().type == EclToken.Type.SquareClose) {
            this.consume();
        }
        int begin = name == null ? pipeline.begin : name.begin;
        int end = pipeline.end;
        PipelineArg result = new PipelineArg(this.text(begin, end), pipeline, begin, end);
        if (name != null) {
            result.name = this.idFromToken(name);
        }
        return result;
    }

    private LiteralArg literalArg(EclToken name, EclToken value) {
        int begin = name == null ? value.begin : name.begin;
        int end = value.end;
        LiteralArg result = new LiteralArg(this.text(begin, end), this.idFromToken(value), begin, end);
        if (name != null) {
            result.name = this.idFromToken(name);
        }
        return result;
    }

    private LiteralArg stringArg(EclToken name) {
        ArrayList<EclToken> strs = new ArrayList<EclToken>();
        boolean stringGoesOn = true;
        while (stringGoesOn) {
            this.consumeAll(EclToken.Type.Spacing);
            EclToken current = this.peek();
            switch (current.type) {
                case String: {
                    strs.add(current);
                    this.consume();
                    break;
                }
                case Plus: {
                    this.consume();
                    break;
                }
                case SlComment: 
                case MlComment: {
                    this.consume();
                    this.addComment(new Comment((String)current.value, current.begin, current.end));
                    break;
                }
                default: {
                    stringGoesOn = false;
                }
            }
        }
        int begin = name == null ? ((EclToken)strs.get((int)0)).begin : name.begin;
        int end = ((EclToken)strs.get((int)(strs.size() - 1))).end;
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (EclToken t : strs) {
            sb.append(t.value);
        }
        sb.append("\"");
        String value = sb.toString();
        LiteralArg arg = new LiteralArg(this.text(begin, end), new Id(value, begin, end), begin, end);
        if (name != null) {
            arg.name = this.idFromToken(name);
        }
        return arg;
    }

    private ScriptArg scriptArg(EclToken name) {
        this.consumeOne(EclToken.Type.CurlyOpen);
        Script script = this.script(EclToken.Type.CurlyClose);
        this.consumeOne(EclToken.Type.CurlyClose);
        int begin = name == null ? script.begin : name.begin;
        int end = script.end;
        ScriptArg result = new ScriptArg(this.text(begin, end), script, begin, end);
        if (name != null) {
            result.name = this.idFromToken(name);
        }
        return result;
    }

    private Comment glueComments() {
        boolean isEnd = false;
        int begin = 0;
        int end = 0;
        String text = "";
        while (!isEnd) {
            this.consumeAll(EclToken.Type.Spacing);
            EclToken current = this.peek();
            switch (current.type) {
                case Linebreak: {
                    if (this.peek((int)1).type == EclToken.Type.SlComment) {
                        this.consume();
                        break;
                    }
                    isEnd = true;
                    break;
                }
                case SlComment: {
                    this.consume();
                    text = String.valueOf(text) + (String)current.value;
                    if (begin == 0) {
                        begin = current.begin;
                    }
                    end = current.end;
                    break;
                }
                default: {
                    isEnd = true;
                }
            }
        }
        return new Comment(text, begin, end);
    }

    private Pipeline pipeline() {
        ArrayList<Command> commands = new ArrayList<Command>();
        boolean pipeEnd = false;
        boolean pendingPipe = false;
        while (!pipeEnd) {
            this.consumeAll(EclToken.Type.Spacing);
            EclToken current = this.peek();
            switch (current.type) {
                case Identifier: 
                case Variable: {
                    commands.add(this.command());
                    pendingPipe = false;
                    break;
                }
                case Pipe: {
                    this.consume();
                    this.consumeAll(EclToken.Type.Spacing, EclToken.Type.Linebreak);
                    pendingPipe = true;
                    break;
                }
                case Linebreak: {
                    EclToken next = this.peekForward(EclToken.Type.Spacing, EclToken.Type.Linebreak, EclToken.Type.SlComment, EclToken.Type.MlComment);
                    if (next.type != EclToken.Type.Pipe && !pendingPipe) {
                        pipeEnd = true;
                        break;
                    }
                    this.consumeAll(EclToken.Type.Spacing, EclToken.Type.Linebreak);
                    break;
                }
                case SlComment: 
                case MlComment: {
                    this.consume();
                    this.addComment(new Comment((String)current.value, current.begin, current.end));
                    break;
                }
                default: {
                    pipeEnd = true;
                }
            }
        }
        int begin = commands.isEmpty() ? this.peek().begin : ((Command)commands.get((int)0)).begin;
        int end = commands.isEmpty() ? this.peek().begin : ((Command)commands.get((int)(commands.size() - 1))).end;
        Pipeline result = new Pipeline(this.text(begin, end), begin, end);
        result.commands.addAll(commands);
        return result;
    }

    private BoolArg boolFromToken(EclToken token) {
        return new BoolArg(token.text, this.idFromToken(token), token.begin, token.end);
    }

    private Id idFromToken(EclToken token) {
        return new Id(token.text, token.begin, token.end);
    }

    private Command command() {
        EclToken current = this.peek();
        this.consumeOne(EclToken.Type.Variable, EclToken.Type.Identifier);
        Id id = new Id(current.text, current.begin, current.end);
        ArrayList<Arg> args = new ArrayList<Arg>();
        boolean commandEnd = false;
        EclToken argName = null;
        Arg pendingArg = null;
        while (!commandEnd) {
            this.consumeAll(EclToken.Type.Spacing);
            current = this.peek();
            switch (current.type) {
                case Identifier: 
                case Number: 
                case Variable: {
                    pendingArg = this.literalArg(argName, current);
                    this.consume();
                    break;
                }
                case String: {
                    pendingArg = this.stringArg(argName);
                    break;
                }
                case Option: {
                    if (argName != null) {
                        args.add(this.boolFromToken(argName));
                    }
                    argName = current;
                    this.consume();
                    break;
                }
                case Linebreak: {
                    EclToken token = this.peekForward(EclToken.Type.Linebreak, EclToken.Type.Spacing);
                    if (token.type != EclToken.Type.Option && token.type != EclToken.Type.SquareOpen && token.type != EclToken.Type.CurlyOpen) {
                        commandEnd = true;
                        break;
                    }
                    this.consumeAll(EclToken.Type.Linebreak, EclToken.Type.Spacing);
                    break;
                }
                case SquareOpen: {
                    pendingArg = this.pipelineArg(argName);
                    break;
                }
                case CurlyOpen: {
                    pendingArg = this.scriptArg(argName);
                    break;
                }
                case SlComment: 
                case MlComment: {
                    this.consume();
                    this.addComment(new Comment((String)current.value, current.begin, current.end));
                    break;
                }
                default: {
                    commandEnd = true;
                }
            }
            if (pendingArg == null) continue;
            args.add(pendingArg);
            pendingArg = null;
            argName = null;
        }
        if (argName != null) {
            args.add(this.boolFromToken(argName));
            argName = null;
        }
        int end = this.lastConsumed == null ? 0 : this.lastConsumed.end;
        Command result = new Command(this.script.substring(id.begin, end), id, id.begin, end);
        result.args.addAll(args);
        return result;
    }

    private EclToken peek() {
        return this.peek(0);
    }

    private EclToken peek(int offset) {
        while (this.buffer.size() < offset + 1) {
            EclToken token = this.scanner.next();
            this.buffer.add(token);
        }
        return this.buffer.get(offset);
    }

    private EclToken peekForward(EclToken.Type ... types) {
        int i = 0;
        while (this.is(this.peek(i), types)) {
            ++i;
        }
        return this.peek(i);
    }

    private void consume() {
        this.peek();
        this.lastConsumed = this.buffer.remove(0);
    }

    private boolean is(EclToken token, EclToken.Type ... types) {
        EclToken.Type t = token.type;
        int i = 0;
        while (i < types.length) {
            if (t == types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void consumeAll(EclToken.Type ... types) {
        while (this.is(this.peek(), types)) {
            this.consume();
        }
    }

    private void consumeOne(EclToken.Type ... types) {
        if (this.is(this.peek(), types)) {
            this.consume();
        }
    }
}

