/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;

public abstract class TextEditBasedChange
extends Change {
    static final TextEditBasedChangeGroup[] ALL_EDITS = new TextEditBasedChangeGroup[0];
    private List<TextEditBasedChangeGroup> fChangeGroups;
    private GroupCategorySet fCombiedGroupCategories;
    private String fName;
    private String fTextType;
    private boolean fTrackEdits;

    protected TextEditBasedChange(String name) {
        Assert.isNotNull((Object)name, (String)"Name must not be null");
        this.fChangeGroups = new ArrayList<TextEditBasedChangeGroup>(5);
        this.fName = name;
        this.fTextType = "txt";
    }

    public void addChangeGroup(TextEditBasedChangeGroup group) {
        Assert.isTrue((group != null ? 1 : 0) != 0);
        this.fChangeGroups.add(group);
        if (this.fCombiedGroupCategories != null) {
            this.fCombiedGroupCategories = GroupCategorySet.union(this.fCombiedGroupCategories, group.getGroupCategorySet());
        }
    }

    public void addTextEditGroup(TextEditGroup group) {
        this.addChangeGroup(new TextEditBasedChangeGroup(this, group));
    }

    public boolean hasOneGroupCategory(List<GroupCategory> groupCategories) {
        if (this.fCombiedGroupCategories == null) {
            this.fCombiedGroupCategories = GroupCategorySet.NONE;
            for (TextEditBasedChangeGroup group : this.fChangeGroups) {
                this.fCombiedGroupCategories = GroupCategorySet.union(this.fCombiedGroupCategories, group.getGroupCategorySet());
            }
        }
        return this.fCombiedGroupCategories.containsOneCategory(groupCategories);
    }

    public final TextEditBasedChangeGroup[] getChangeGroups() {
        return this.fChangeGroups.toArray(new TextEditBasedChangeGroup[this.fChangeGroups.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getContent(IDocument document, IRegion region, boolean expandRegionToFullLine, int surroundingLines) throws CoreException {
        try {
            int endLine;
            if (!expandRegionToFullLine) {
                return document.get(region.getOffset(), region.getLength());
            }
            int startLine = Math.max(document.getLineOfOffset(region.getOffset()) - surroundingLines, 0);
            if (region.getLength() == 0) {
                if (surroundingLines == 0) {
                    return "";
                }
                endLine = Math.min(document.getLineOfOffset(region.getOffset()) + surroundingLines - 1, document.getNumberOfLines() - 1);
            } else {
                endLine = Math.min(document.getLineOfOffset(region.getOffset() + region.getLength() - 1) + surroundingLines, document.getNumberOfLines() - 1);
            }
            int offset = document.getLineInformation(startLine).getOffset();
            IRegion endLineRegion = document.getLineInformation(endLine);
            int length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
            return document.get(offset, length);
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
    }

    public abstract String getCurrentContent(IProgressMonitor var1) throws CoreException;

    public abstract String getCurrentContent(IRegion var1, boolean var2, int var3, IProgressMonitor var4) throws CoreException;

    public boolean getKeepPreviewEdits() {
        return this.fTrackEdits;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public abstract String getPreviewContent(TextEditBasedChangeGroup[] var1, IRegion var2, boolean var3, int var4, IProgressMonitor var5) throws CoreException;

    public abstract String getPreviewContent(IProgressMonitor var1) throws CoreException;

    public String getTextType() {
        return this.fTextType;
    }

    TextEdit[] mapEdits(TextEdit[] edits, TextEditCopier copier) {
        if (edits == null) {
            return null;
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(edits.length);
        TextEdit[] textEditArray = edits;
        int n = edits.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit e = textEditArray[n2];
            TextEdit edit = copier.getCopy(e);
            if (edit != null) {
                result.add(edit);
            }
            ++n2;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (TextEditBasedChangeGroup element : this.fChangeGroups) {
            element.setEnabled(enabled);
        }
    }

    public void setKeepPreviewEdits(boolean keep) {
        this.fTrackEdits = keep;
    }

    public void setTextType(String type) {
        if (type == null) {
            type = "txt";
        }
        this.fTextType = type;
    }

    static final class LocalTextEditProcessor
    extends TextEditProcessor {
        public static final int EXCLUDE = 1;
        public static final int INCLUDE = 2;
        private TextEdit[] fExcludes;
        private TextEdit[] fIncludes;

        protected LocalTextEditProcessor(IDocument document, TextEdit root, int flags) {
            super(document, root, flags);
        }

        public void setIncludes(TextEdit[] includes) {
            Assert.isNotNull((Object)includes);
            Assert.isTrue((this.fExcludes == null ? 1 : 0) != 0);
            this.fIncludes = this.flatten(includes);
        }

        public void setExcludes(TextEdit[] excludes) {
            Assert.isNotNull((Object)excludes);
            Assert.isTrue((this.fIncludes == null ? 1 : 0) != 0);
            this.fExcludes = this.flatten(excludes);
        }

        protected boolean considerEdit(TextEdit edit) {
            if (this.fExcludes != null) {
                TextEdit[] textEditArray = this.fExcludes;
                int n = this.fExcludes.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit fExclude = textEditArray[n2];
                    if (edit.equals((Object)fExclude)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            if (this.fIncludes != null) {
                TextEdit[] textEditArray = this.fIncludes;
                int n = this.fIncludes.length;
                int n3 = 0;
                while (n3 < n) {
                    TextEdit fInclude = textEditArray[n3];
                    if (edit.equals((Object)fInclude)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            return true;
        }

        private TextEdit[] flatten(TextEdit[] edits) {
            ArrayList<TextEdit> result = new ArrayList<TextEdit>(5);
            TextEdit[] textEditArray = edits;
            int n = edits.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit edit = textEditArray[n2];
                this.flatten(result, edit);
                ++n2;
            }
            return result.toArray(new TextEdit[result.size()]);
        }

        private void flatten(List<TextEdit> result, TextEdit edit) {
            TextEdit[] children;
            result.add(edit);
            TextEdit[] textEditArray = children = edit.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit child = textEditArray[n2];
                this.flatten(result, child);
                ++n2;
            }
        }
    }

    static final class PreviewAndRegion {
        public IDocument document;
        public IRegion region;

        public PreviewAndRegion(IDocument d, IRegion r) {
            this.document = d;
            this.region = r;
        }
    }
}

