/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.schema.DocSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaIncludesSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaSpecSection;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SchemaOverviewPage
extends PDEFormPage {
    public static final String PAGE_ID = "overview";
    private IColorManager fColorManager = ColorManager.getDefault();
    private ImageHyperlink fImageHyperlinkPreviewRefDoc;
    private DocSection fDocSection;
    private SchemaSpecSection fGeneralInfoSection;
    private SchemaIncludesSection fInclusionSection;
    private ShowDescriptionAction fPreviewAction;

    public SchemaOverviewPage(PDEFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.SchemaEditor_DocPage_title);
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.schema_editor_doc";
    }

    public void setActive(boolean active) {
        if (!active) {
            this.getManagedForm().commit(false);
        }
        super.setActive(active);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        ISchema schema = (ISchema)((SchemaEditor)this.getEditor()).getAggregateModel();
        if (schema.isEditable()) {
            form.getToolBarManager().add((IContributionItem)this.createUIControlConPreviewRefDoc());
            form.getToolBarManager().update(true);
        }
        super.createFormContent(managedForm);
        form.getBody().setLayout((Layout)FormLayoutFactory.createFormGridLayout(false, 1));
        Composite top = managedForm.getToolkit().createComposite(form.getBody());
        top.setLayout((Layout)FormLayoutFactory.createFormPaneGridLayout(true, 2));
        top.setLayoutData((Object)new GridData(768));
        this.fGeneralInfoSection = new SchemaSpecSection(this, top);
        this.fInclusionSection = new SchemaIncludesSection(this, top);
        this.fDocSection = new DocSection((PDEFormPage)this, form.getBody(), this.fColorManager);
        managedForm.addPart((IFormPart)this.fGeneralInfoSection);
        managedForm.addPart((IFormPart)this.fInclusionSection);
        managedForm.addPart((IFormPart)this.fDocSection);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.schema_editor_doc");
    }

    private ControlContribution createUIControlConPreviewRefDoc() {
        return new ControlContribution("Preview"){

            protected Control createControl(Composite parent) {
                SchemaOverviewPage.this.createUIImageHyperlinkPreviewRefDoc(parent);
                SchemaOverviewPage.this.createUIListenerImageHyperlinkPreviewRefDoc();
                return SchemaOverviewPage.this.fImageHyperlinkPreviewRefDoc;
            }
        };
    }

    private void createUIImageHyperlinkPreviewRefDoc(Composite parent) {
        this.fImageHyperlinkPreviewRefDoc = new ImageHyperlink(parent, 0);
        this.fImageHyperlinkPreviewRefDoc.setText(PDEUIMessages.SchemaEditor_previewLink);
        this.fImageHyperlinkPreviewRefDoc.setUnderlined(true);
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
    }

    private void createUIListenerImageHyperlinkPreviewRefDoc() {
        this.fImageHyperlinkPreviewRefDoc.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                SchemaOverviewPage.this.handleLinkActivatedPreviewRefDoc();
            }

            public void linkEntered(HyperlinkEvent e) {
                SchemaOverviewPage.this.handleLinkEnteredPreviewRefDoc(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                SchemaOverviewPage.this.handleLinkExitedPreviewRefDoc();
            }
        });
    }

    private void handleLinkEnteredPreviewRefDoc(String message) {
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getActiveForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private void handleLinkExitedPreviewRefDoc() {
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    private void handleLinkActivatedPreviewRefDoc() {
        ISchema schema = (ISchema)((SchemaEditor)this.getEditor()).getAggregateModel();
        if (this.fPreviewAction == null) {
            this.fPreviewAction = new ShowDescriptionAction(schema);
        } else {
            this.fPreviewAction.setSchema(schema);
        }
        this.fPreviewAction.run();
    }

    @Override
    public void dispose() {
        this.fColorManager.dispose();
        super.dispose();
    }
}

