/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.jface.text;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.OpenDeclaration;
import org.eclipse.rcptt.tesla.core.protocol.RulerClick;
import org.eclipse.rcptt.tesla.core.protocol.RulerDoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.SetCaretPosition;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection2;
import org.eclipse.rcptt.tesla.core.protocol.TextUIElement;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.AbstractSWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTModelMapperExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.recording.aspects.IAbstractSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.IExtendedSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.IWorkbenchTexteditorEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.SWTEventManager;
import org.eclipse.rcptt.tesla.recording.aspects.WorkbenchTexteditorEventManager;
import org.eclipse.rcptt.tesla.recording.aspects.jface.text.IJFaceTextEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.jface.text.JFaceTextEventManager;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessorExtension;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.util.LastEvents;
import org.eclipse.rcptt.tesla.recording.core.swt.util.RecordedEvent;
import org.eclipse.rcptt.tesla.workbench.texteditor.TextEditorMapper;
import org.eclipse.rcptt.util.ArraysUtil;
import org.eclipse.rcptt.util.KeysAndButtons;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;

public class WorkbenchTexteditorRecordingProcessor
implements IRecordingProcessor,
IWorkbenchTexteditorEventListener,
IRecordingProcessorExtension,
IExtendedSWTEventListener,
IJFaceTextEventListener,
ISWTModelMapperExtension {
    private TeslaRecorder recorder;
    private SWTEventRecorder eventRecorder;
    private boolean inStyledTextAction = false;
    private Event lastEvent = null;
    private final LastEvents lastEvents = new LastEvents();
    private final Set<String> pressed = new HashSet<String>();
    private Event currentEvent = null;
    final AtomicInteger useTextViewer = new AtomicInteger(0);
    private Event lastTraverseEvent = null;
    private static final int[] rulerEvents = new int[]{4, 8};
    private AbstractSWTUIPlayerExtension processor = new AbstractSWTUIPlayerExtension(){

        public GenericElementKind getKind(Object w) {
            if (WorkbenchTexteditorRecordingProcessor.this.useTextViewer.get() == 1) {
                if (WorkbenchTexteditorRecordingProcessor.isTextEditorStyledText(w)) {
                    return new GenericElementKind(ElementKind.TextViewer);
                }
                ElementKind rulerKind = WorkbenchTexteditorRecordingProcessor.getTextEditorRulerKind(w);
                if (rulerKind != null) {
                    return new GenericElementKind(rulerKind);
                }
            }
            return null;
        }

        public String getRawText(SWTUIElement element) {
            return WorkbenchTexteditorRecordingProcessor.getTextEditorRulerText(element.unwrap());
        }
    };

    public WorkbenchTexteditorRecordingProcessor() {
        SWTUIPlayer.addExtension((ISWTUIPlayerExtension)this.processor);
    }

    public void clear() {
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
        WorkbenchTexteditorEventManager.addListener((IWorkbenchTexteditorEventListener)this);
        SWTEventManager.addListener((IAbstractSWTEventListener)this);
        JFaceTextEventManager.addListener((IJFaceTextEventListener)this);
    }

    public int getInitLevel() {
        return 1000;
    }

    public TeslaRecorder getRecorder() {
        return this.recorder;
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    private synchronized SWTEventRecorder getSWTEventRecorder() {
        if (this.eventRecorder == null) {
            this.eventRecorder = (SWTEventRecorder)this.recorder.getProcessor(SWTEventRecorder.class);
        }
        return this.eventRecorder;
    }

    public IRecordingHelper<?> getHelper() {
        return null;
    }

    public void resetAssertSelection() {
    }

    public boolean isIgnored(Object widget, int type, Object event) {
        return this.isNotCanvas(widget, type, event);
    }

    public boolean isNotCanvas(Object widget, int type, Object event) {
        return WorkbenchTexteditorRecordingProcessor.isTextEditorStyledText(widget) || WorkbenchTexteditorRecordingProcessor.getTextEditorRulerKind(widget) != null;
    }

    public boolean isNotDraw2d(Object widget) {
        return false;
    }

    private static ElementKind getTextEditorRulerKind(Object widget) {
        if (widget instanceof Canvas) {
            List rulers = JFaceTextEventManager.getRulers();
            for (IVerticalRuler ruler : rulers) {
                if (widget.equals(ruler.getControl())) {
                    if (ruler instanceof CompositeRuler) {
                        return ElementKind.LeftRuler;
                    }
                    if (ruler instanceof OverviewRuler) {
                        return ElementKind.RightRuler;
                    }
                    return ElementKind.VerticalRuler;
                }
                if (!(ruler instanceof CompositeRuler)) continue;
                Iterator iterator = ((CompositeRuler)ruler).getDecoratorIterator();
                while (iterator.hasNext()) {
                    IVerticalRulerColumn column;
                    Object next = iterator.next();
                    if (!(next instanceof IVerticalRulerColumn) || !widget.equals((column = (IVerticalRulerColumn)next).getControl())) continue;
                    return ElementKind.VerticalColumn;
                }
            }
        }
        return null;
    }

    private static String getTextEditorRulerText(Object widget) {
        if (widget instanceof Canvas) {
            List rulers = JFaceTextEventManager.getRulers();
            for (IVerticalRuler ruler : rulers) {
                if (widget.equals(ruler.getControl())) {
                    if (ruler instanceof CompositeRuler) {
                        return null;
                    }
                    if (ruler instanceof OverviewRuler) {
                        return null;
                    }
                    return null;
                }
                if (!(ruler instanceof CompositeRuler)) continue;
                Iterator iterator = ((CompositeRuler)ruler).getDecoratorIterator();
                while (iterator.hasNext()) {
                    IVerticalRulerColumn column;
                    Object next = iterator.next();
                    if (!(next instanceof IVerticalRulerColumn) || !widget.equals((column = (IVerticalRulerColumn)next).getControl())) continue;
                    return column.getClass().getSimpleName();
                }
            }
        }
        return null;
    }

    private int getTextEditorRulerLine(Object widget, int y) {
        if (widget instanceof Canvas) {
            List rulers = JFaceTextEventManager.getRulers();
            for (IVerticalRuler ruler : rulers) {
                if (widget.equals(ruler.getControl())) {
                    if (ruler instanceof CompositeRuler) {
                        int line = ((CompositeRuler)ruler).getLineOfLastMouseButtonActivity();
                        return line == -1 ? -1 : line + 1;
                    }
                    if (ruler instanceof OverviewRuler) {
                        int line = ((OverviewRuler)ruler).toDocumentLineNumber(y);
                        return line == -1 ? -1 : line + 1;
                    }
                    if (ruler instanceof VerticalRuler) {
                        int line = ((VerticalRuler)ruler).getLineOfLastMouseButtonActivity();
                        return line == -1 ? -1 : line + 1;
                    }
                }
                if (!(ruler instanceof CompositeRuler)) continue;
                Iterator iterator = ((CompositeRuler)ruler).getDecoratorIterator();
                while (iterator.hasNext()) {
                    IVerticalRulerColumn column;
                    Object next = iterator.next();
                    if (!(next instanceof IVerticalRulerColumn) || !(next instanceof IVerticalRulerInfo) || !widget.equals((column = (IVerticalRulerColumn)next).getControl())) continue;
                    int line = ((IVerticalRulerInfo)next).getLineOfLastMouseButtonActivity();
                    return line == -1 ? -1 : line + 1;
                }
            }
        }
        return -1;
    }

    private static boolean isTextEditorStyledText(Object widget) {
        TextViewer viewer;
        return widget instanceof StyledText && (viewer = JFaceTextEventManager.getViewer((StyledText)((StyledText)widget))) != null;
    }

    public boolean isExclusiveEventHandle(org.eclipse.swt.widgets.Widget widget, int type, Event event) {
        return false;
    }

    public void recordEvent(org.eclipse.swt.widgets.Widget widget, int type, Event event) {
        if (this.getRecorder() == null) {
            return;
        }
        if (!this.getRecorder().hasListeners()) {
            return;
        }
        if (this.getSWTEventRecorder() == null || this.getSWTEventRecorder().isIgnored(widget)) {
            return;
        }
        if (Platform.getOS().equals("macosx")) {
            if (event != null && this.lastEvent != null && event.time == this.lastEvent.time && event.widget == this.lastEvent.widget && event.type == this.lastEvent.type) {
                return;
            }
            this.lastEvent = event;
        }
        if (this.isIgnored(widget, type, event)) {
            try {
                this.useTextViewer.set(1);
                this.cleanTextElementIfAlreadyUsed(widget);
                this.recordEvent_(widget, type, event);
            }
            finally {
                this.useTextViewer.set(0);
            }
        }
    }

    protected void recordEvent_(org.eclipse.swt.widgets.Widget widget, int type, Event event) {
        FindResult canvas;
        if (type == 2008 || type == 2000 || type == 2002 || type == 2004 || type == 2003 || type == 2006 || type == 2005 || type == 2007 || type == 2001) {
            if (event.widget == null) {
                event.widget = widget;
            }
            event.type = type;
            this.recordDragEvent(event);
            return;
        }
        RecordedEvent toRecording = new RecordedEvent(this.getPlayer(), event, type, widget);
        ContextManagement.Context ctx = ContextManagement.currentContext();
        ElementKind rulerKind = WorkbenchTexteditorRecordingProcessor.getTextEditorRulerKind(widget);
        if (rulerKind != null && type != 6 && type != 7 && (canvas = this.getSWTEventRecorder().getLocator().findElement(widget, false, false, false)) != null) {
            this.processRulerCanvas(widget, type, event, canvas);
        }
        if (this.getSWTEventRecorder().isNotNative(widget)) {
            return;
        }
        if (type == 13 || type == 14) {
            this.processSelection(widget, event, type, ctx);
        } else if (type == 26) {
            this.lastEvents.add(toRecording);
        } else if (type == 27) {
            this.lastEvents.add(toRecording);
        } else if (type == 1) {
            if (ctx.contains("com.xored.swt.internal.composer.GeckoEditor$KeyAdapter", "handleEvent")) {
                return;
            }
            this.addToPressed(event);
            this.processKeyDown(widget, event);
            this.lastEvents.add(toRecording);
        } else if (type == 2) {
            boolean fixTraverse;
            if (ctx.contains("com.xored.swt.internal.composer.GeckoEditor$KeyAdapter", "handleEvent")) {
                return;
            }
            String v = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode).toString().toLowerCase();
            String[] values = v.split("\\+");
            boolean contains = false;
            boolean containsAll = true;
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                if (this.pressed.contains(val)) {
                    contains = true;
                } else {
                    containsAll = false;
                }
                ++n2;
            }
            boolean isEnterOnMac = Platform.getOS().equals("macosx") && event.character == '\r' && event.stateMask == 0;
            boolean bl = fixTraverse = this.lastTraverseEvent != null && this.lastTraverseEvent.stateMask == event.stateMask && this.lastTraverseEvent.keyCode == event.keyCode;
            if (!contains && !isEnterOnMac || fixTraverse && !containsAll) {
                this.lastTraverseEvent = null;
                this.processKeyDown(widget, event);
            }
            String[] stringArray2 = values;
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                String val = stringArray2[n4];
                this.pressed.remove(val);
                ++n4;
            }
            this.lastEvents.add(toRecording);
        } else if (type == 31) {
            if (!(widget instanceof Browser)) {
                if (WorkbenchTexteditorRecordingProcessor.isTextEditorStyledText(widget) && !event.doit) {
                    switch (event.detail) {
                        case 32: 
                        case 64: {
                            this.lastTraverseEvent = event;
                        }
                    }
                } else {
                    this.addToPressed(event);
                    this.processTraverse(widget, event, toRecording);
                    this.lastEvents.add(toRecording);
                }
            }
        } else if (type == 3) {
            this.processMouseDown(widget, event);
            this.lastEvents.add(toRecording);
        } else {
            this.lastEvents.add(toRecording);
        }
    }

    private void processRulerCanvas(org.eclipse.swt.widgets.Widget widget, int type, Event event, FindResult canvas) {
        if (!ArraysUtil.contains((int[])rulerEvents, (int)type) || canvas == null || event == null) {
            return;
        }
        ControlUIElement canvasCtrl = new ControlUIElement(canvas.element, (UIPlayer)this.getRecorder());
        int line = this.getTextEditorRulerLine(widget, event.y);
        if (line == -1) {
            return;
        }
        Command last = this.getRecorder().getContainer().getLast();
        Element lastElement = last instanceof ElementCommand ? ((ElementCommand)last).getElement() : null;
        switch (type) {
            case 4: {
                if (last instanceof RulerDoubleClick && EcoreUtil.equals((EObject)lastElement, (EObject)canvas.element)) {
                    return;
                }
                canvasCtrl.RulerClick(line, event.button, event.stateMask & ~KeysAndButtons.getButtonMaskSafe((int)event.button));
                break;
            }
            case 8: {
                if (last instanceof RulerClick && EcoreUtil.equals((EObject)lastElement, (EObject)canvas.element)) {
                    this.getRecorder().removeLast();
                }
                canvasCtrl.RulerDoubleClick(line, event.button, event.stateMask);
            }
        }
    }

    private SWTUIPlayer getPlayer() {
        return this.getSWTEventRecorder().getPlayer();
    }

    private void processSelection(org.eclipse.swt.widgets.Widget widget, Event event, int type, ContextManagement.Context ctx) {
        if (SWTEventRecorder.isIgnoreSelection((org.eclipse.swt.widgets.Widget)widget, (Event)event, (int)type, (ContextManagement.Context)ctx)) {
            return;
        }
        try {
            FindResult result;
            if (!this.inStyledTextAction && (result = this.getSWTEventRecorder().getLocator().findElement(widget, true, false, false)) != null) {
                TextUIElement textCtrl = new TextUIElement(result.element, (UIPlayer)this.getRecorder());
                if (widget instanceof StyledText) {
                    StyledText styledText = (StyledText)widget;
                    Point selection = styledText.getSelectionRange();
                    if (selection.y != 0) {
                        SetCaretPosition offset;
                        Command last = this.getRecorder().getContainer().getLast();
                        if (last instanceof SetCaretPosition && EcoreUtil.equals((EObject)(offset = (SetCaretPosition)last).getElement(), (EObject)result.element)) {
                            this.getRecorder().removeLast();
                        }
                        int[] start = this.getCursorOffset(styledText, selection.x);
                        int[] end = this.getCursorOffset(styledText, selection.x + selection.y);
                        int caretOffset = styledText.getCaretOffset();
                        if (caretOffset == selection.x) {
                            textCtrl.setSelection2(end[0], end[1], start[0], start[1]);
                        } else {
                            textCtrl.setSelection2(start[0], start[1], end[0], end[1]);
                        }
                    }
                }
            }
        }
        finally {
            this.lastEvents.clear();
        }
    }

    private void processTraverse(org.eclipse.swt.widgets.Widget widget, Event event, RecordedEvent toRecording) {
        this.getSWTEventRecorder().processTraverse(widget, event, toRecording);
    }

    private void processKeyDown(org.eclipse.swt.widgets.Widget widget, Event event) {
        FindResult result = this.getSWTEventRecorder().getLocator().findElement(widget, true, false, false);
        if (result != null) {
            ControlUIElement ctrl = new ControlUIElement(result.element, (UIPlayer)this.getRecorder());
            if (event.keyCode != 131072 && event.keyCode != 262144 && event.keyCode != 65536 && event.keyCode != 0x400000) {
                if ((event.keyCode & 0x1000000) == 0 && event.stateMask == 0 && !Character.isISOControl(event.character)) {
                    if (widget instanceof StyledText || widget instanceof Browser || widget.getListeners(1).length > 0 || widget.getListeners(2).length > 0) {
                        ctrl.type(new String(new char[]{event.character}), widget instanceof Browser);
                        this.getSWTEventRecorder().addToPressed(event);
                    }
                } else if (widget instanceof StyledText || widget instanceof Browser) {
                    if (event.stateMask == 131072 && !Character.isISOControl(event.character)) {
                        ctrl.type(new String(new char[]{event.character}), widget instanceof Browser);
                        this.getSWTEventRecorder().addToPressed(event);
                    } else {
                        ctrl.press(event.keyCode, event.stateMask, widget instanceof Browser, event.character, SWTEventRecorder.getMeta((int)event.stateMask));
                        this.getSWTEventRecorder().addToPressed(event);
                    }
                } else {
                    ctrl.press(event.keyCode, event.stateMask, widget instanceof Browser, event.character, SWTEventRecorder.getMeta((int)event.stateMask));
                    this.getSWTEventRecorder().addToPressed(event);
                }
            }
            this.lastEvents.clear();
        }
    }

    private void addToPressed(Event event) {
        String[] values;
        KeyStroke strk = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode);
        String split = strk.toString().toLowerCase();
        String[] stringArray = values = split.split("\\+");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (!this.pressed.contains(val)) {
                this.pressed.add(val);
            }
            ++n2;
        }
    }

    public void recordDragEvent(Event event) {
    }

    public void recordSWTDialog(Dialog dialog, Object result) {
    }

    public void recordStyledTextOffset(StyledText text) {
        try {
            this.useTextViewer.set(1);
            if (!WorkbenchTexteditorRecordingProcessor.isTextEditorStyledText(text)) {
                return;
            }
            if (this.inStyledTextAction) {
                return;
            }
            if (this.getRecorder() == null) {
                return;
            }
            if (!this.getRecorder().hasListeners()) {
                return;
            }
            this.cleanTextElementIfAlreadyUsed((org.eclipse.swt.widgets.Widget)text);
            if (!this.isIgnored(text, 13, null)) {
                return;
            }
            if (this.getSWTEventRecorder().isIgnored((org.eclipse.swt.widgets.Widget)text)) {
                return;
            }
            ContextManagement.Context context = ContextManagement.currentContext();
            if (!(context.contains("org.eclipse.swt.custom.StyledText", "doContent") || context.contains("org.eclipse.swt.custom.StyledText", "setContent") || context.contains("org.eclipse.swt.custom.StyledText", "reset") || context.contains("org.eclipse.swt.custom.StyledText", "handleKey") || context.contains("org.eclipse.swt.custom.StyledText", "setSelectionRange") || context.contains("org.eclipse.swt.custom.StyledText", "setSelection") || context.contains("org.eclipse.swt.custom.StyledText", "setStyleRanges") || context.contains("org.eclipse.ui.internal.keys.WorkbenchKeyboard", "press"))) {
                FindResult element;
                Command last = this.getRecorder().getContainer().getLast();
                if (last instanceof Type) {
                    Type type = (Type)last;
                    if (type.getCode() != null && type.getCode() == 8 && type.getState() != null) {
                        type.getState().intValue();
                    }
                    if (type.getCode() != null && type.getCode() == 9 && type.getState() != null) {
                        type.getState().intValue();
                    }
                }
                if (text.getText().length() > 0 && (element = this.getSWTEventRecorder().getLocator().findElement((org.eclipse.swt.widgets.Widget)text, false, false, false)) != null) {
                    TextUIElement textCtrl = new TextUIElement(element.element, (UIPlayer)this.getRecorder());
                    int[] result = this.getCursorOffset(text, text.getCaretOffset());
                    if (!(last instanceof SetTextSelection2 && EcoreUtil.equals((EObject)((SetTextSelection2)last).getElement(), (EObject)element.element) || last instanceof OpenDeclaration && EcoreUtil.equals((EObject)((OpenDeclaration)last).getElement(), (EObject)element.element))) {
                        textCtrl.setTextCursor(result[0], result[1]);
                    }
                }
            }
        }
        finally {
            this.useTextViewer.set(0);
        }
    }

    private int[] getCursorOffset(StyledText text, int offset) {
        int[] result = null;
        try {
            TextViewer viewer = JFaceTextEventManager.getViewer((StyledText)text);
            IDocument document = viewer.getDocument();
            int realOffset = viewer.widgetOffset2ModelOffset(offset);
            int lineAtOffset = document.getLineOfOffset(realOffset);
            int offsetAtLine = document.getLineOffset(lineAtOffset);
            int tabWidth = text.getTabs();
            int column = 0;
            int i = offsetAtLine;
            while (i < realOffset) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth)) : ++column;
                ++i;
            }
            result = new int[]{lineAtOffset + 1, column + 1};
        }
        catch (BadLocationException e) {
            TeslaCore.log((Throwable)e);
        }
        return result;
    }

    public void recordStyledTextActionBefore(StyledText text, int action) {
        this.inStyledTextAction = true;
    }

    public void recordStyledTextActionAfter(StyledText text, int action) {
        this.inStyledTextAction = false;
    }

    public void recordTabFolderEvent(Control tabControl, int eventId) {
    }

    public void showContentAssist(Object control, boolean autoActivation) {
    }

    public void activateInfomationWindow(org.eclipse.swt.widgets.Widget widget, Rectangle subjectArea) {
        try {
            this.useTextViewer.set(1);
            if (!this.isIgnored(widget, 13, null)) {
                return;
            }
            ContextManagement.Context ctx = ContextManagement.currentContext();
            if (ctx.contains("org.eclipse.ui.internal.keys.WorkbenchKeyboard", "press")) {
                return;
            }
            this.cleanTextElementIfAlreadyUsed(widget);
            FindResult findResult = this.getSWTEventRecorder().getLocator().findElement(widget, false, false, true);
            if (findResult != null) {
                int stateMask;
                int n = stateMask = this.currentEvent != null ? this.currentEvent.stateMask : 0;
                if (widget instanceof StyledText) {
                    StyledText text = (StyledText)widget;
                    Point center = new Point(subjectArea.x + subjectArea.width / 2, subjectArea.y + subjectArea.height / 2);
                    int offset = ((StyledText)widget).getOffsetAtLocation(center);
                    int[] result = this.getCursorOffset(text, offset);
                    TextUIElement textElement = new TextUIElement(findResult.element, (UIPlayer)this.getRecorder());
                    textElement.hoverAtText(result[0], result[1], stateMask);
                } else {
                    int line;
                    int y;
                    int n2 = y = this.currentEvent != null ? this.currentEvent.y : 0;
                    if (this.currentEvent != null && this.currentEvent.type == 32 && WorkbenchTexteditorRecordingProcessor.getTextEditorRulerKind(this.currentEvent.widget) != null) {
                        widget = this.currentEvent.widget;
                        findResult = this.getSWTEventRecorder().getLocator().findElement(widget, false, false, true);
                        if (findResult == null) {
                            return;
                        }
                    }
                    if ((line = this.getTextEditorRulerLine(widget, y)) != -1) {
                        ControlUIElement rulerCtrl = new ControlUIElement(findResult.element, (UIPlayer)this.getRecorder());
                        rulerCtrl.RulerHover(line, stateMask);
                    }
                }
            }
        }
        finally {
            this.useTextViewer.set(0);
        }
    }

    private void cleanTextElementIfAlreadyUsed(org.eclipse.swt.widgets.Widget widget) {
        SWTUIElement uiElement = this.getSWTEventRecorder().getPlayer().wrap((Object)widget);
        BasicRecordingHelper.ElementEntry entry = SWTRecordingHelper.getHelper().get((Object)uiElement);
        if (entry != null && entry.getElement() != null && entry.getElement().getKind().equals(ElementKind.Text.name())) {
            SWTRecordingHelper.getHelper().remove((Object)uiElement);
        }
    }

    private void processMouseDown(org.eclipse.swt.widgets.Widget widget, Event event) {
        if (!this.isNotCanvas(widget, 13, null)) {
            return;
        }
        if ((event.stateMask & SWT.MOD1) != 0) {
            FindResult findResult = this.getSWTEventRecorder().getLocator().findElement(widget, false, false, true);
            if (widget instanceof StyledText && findResult != null) {
                StyledText text = (StyledText)widget;
                int offset = text.getOffsetAtLocation(new Point(event.x, event.y));
                int[] position = this.getCursorOffset(text, offset);
                TextUIElement textElement = new TextUIElement(findResult.element, (UIPlayer)this.getRecorder());
                textElement.setTextCursor(position[0], position[1]);
                textElement.openDeclaration();
            }
        }
    }

    public void setCurrentEvent(Event event) {
        this.currentEvent = event;
    }

    public Widget mapExtraValues(SWTUIElement element, Widget result) {
        return TextEditorMapper.mapExtraValues((SWTUIElement)element, (Widget)result);
    }

    public boolean isPartOfParent(Object widget, Object parent) {
        return false;
    }

    public void removeClosedShell(SWTUIElement wrappedShell) {
    }
}

