/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.ContentTypeSpecializationComparator;
import org.eclipse.ui.internal.genericeditor.GenericContentTypeRelatedExtension;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class ContentAssistProcessorRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.contentAssistProcessors";
    private Map<IConfigurationElement, GenericContentTypeRelatedExtension<IContentAssistProcessor>> extensions = new LinkedHashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IContentAssistProcessor>>();
    private boolean outOfSync = true;

    public ContentAssistProcessorRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                ContentAssistProcessorRegistry.this.outOfSync = true;
            }
        }, EXTENSION_POINT_ID);
    }

    public List<IContentAssistProcessor> getContentAssistProcessors(ISourceViewer sourceViewer, ITextEditor editor, Set<IContentType> contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        return this.extensions.values().stream().filter(ext -> contentTypes.contains(ext.targetContentType)).filter(ext -> ext.matches(sourceViewer, editor)).sorted(new ContentTypeSpecializationComparator()).map(GenericContentTypeRelatedExtension::createDelegate).collect(Collectors.toList());
    }

    private void sync() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.extensions.containsKey(extension)) {
                try {
                    this.extensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.extensions.remove(toRemove);
        }
        this.outOfSync = false;
    }

    static class ContentAssistProcessorDelegate
    implements IContentAssistProcessor {
        private final IContentAssistProcessor delegate;
        private IContentType targetContentType;

        public ContentAssistProcessorDelegate(IContentAssistProcessor delegate, IContentType targetContentType) {
            this.delegate = delegate;
            this.targetContentType = targetContentType;
        }

        public boolean isActive(ITextViewer viewer) {
            String fileName = null;
            if (viewer != null && viewer.getDocument() != null) {
                IPath location = FileBuffers.getTextFileBufferManager().getTextFileBuffer(viewer.getDocument()).getLocation();
                fileName = location.segment(location.segmentCount() - 1);
            }
            if (fileName == null) {
                fileName = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput().getName();
            }
            if (fileName != null) {
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                IContentType[] iContentTypeArray = contentTypeManager.findContentTypesFor(fileName);
                int n = iContentTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType currentContentType = iContentTypeArray[n2];
                    if (currentContentType.isKindOf(this.targetContentType)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            if (this.isActive(viewer)) {
                return this.delegate.computeCompletionProposals(viewer, offset);
            }
            return new ICompletionProposal[0];
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            if (this.isActive(viewer)) {
                return this.delegate.computeContextInformation(viewer, offset);
            }
            return new IContextInformation[0];
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            if (this.isActive(null)) {
                return this.delegate.getCompletionProposalAutoActivationCharacters();
            }
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            if (this.isActive(null)) {
                return this.delegate.getContextInformationAutoActivationCharacters();
            }
            return null;
        }

        public String getErrorMessage() {
            if (this.isActive(null)) {
                return this.delegate.getErrorMessage();
            }
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            if (this.isActive(null)) {
                return this.delegate.getContextInformationValidator();
            }
            return null;
        }
    }
}

