/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.jface.TeslaCellEditorManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.ui.SWTTeslaActivator;
import org.eclipse.rcptt.util.ShellUtilsProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class SWTEvents {
    private Display display;
    private static int lastStamp = -1;
    private Control lastFocusControl = null;

    public SWTEvents(Display display) {
        this.display = display;
    }

    public Event createEvent(SWTUIElement wrap) {
        return this.createEvent(PlayerWrapUtils.unwrapWidget(wrap));
    }

    public Event createEvent(Widget w) {
        Event e = new Event();
        e.widget = w;
        e.display = this.display;
        e.time = (int)System.currentTimeMillis();
        return e;
    }

    public Event createMouseEvent(Display display, Widget widget, int x, int y, int button, int stateMask, int count) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = display;
        event.x = x;
        event.y = y;
        event.button = button;
        event.stateMask = stateMask;
        event.count = count;
        return event;
    }

    public Event sendEvent(SWTUIElement w, int event) {
        if (PlayerWrapUtils.unwrapWidget(w).isDisposed()) {
            return null;
        }
        try {
            Event e = this.createEvent(w);
            this.sendEventRaw(event, e);
            return e;
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
            return null;
        }
    }

    public void sendEventRaw(int event, Event e) {
        if (e.time == 0) {
            e.time = (int)System.currentTimeMillis();
        }
        if (e.time == lastStamp) {
            ++e.time;
        }
        lastStamp = e.time;
        e.widget.notifyListeners(event, e);
    }

    public Event sendEvent(SWTUIElement w, int event, int x, int y) {
        if (PlayerWrapUtils.unwrapWidget(w).isDisposed()) {
            return null;
        }
        try {
            Event e = this.createEvent(w);
            e.x = x;
            e.y = y;
            e.type = event;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(SWTUIElement w, int event, Point point, int button) {
        return this.sendEvent(w, event, point.x, point.y, button);
    }

    public Event sendEvent(SWTUIElement w, int event, int x, int y, int button) {
        if (PlayerWrapUtils.unwrapWidget(w).isDisposed()) {
            return null;
        }
        try {
            Event e = this.createEvent(w);
            e.x = x;
            e.y = y;
            e.button = button;
            e.type = event;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(Widget w, int event, Point point, int button) {
        return this.sendEvent(w, event, point.x, point.y, button);
    }

    public Event sendEvent(Widget w, int event, int x, int y, int button) {
        try {
            Event e = this.createEvent(w);
            e.x = x;
            e.y = y;
            e.button = button;
            e.type = event;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(Widget w, int event, int x, int y, int button, int mask) {
        try {
            Event e = this.createEvent(w);
            e.x = x;
            e.y = y;
            e.type = event;
            e.button = button;
            e.stateMask = mask;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(SWTUIElement w, Event event) {
        Widget unwrapWidget = PlayerWrapUtils.unwrapWidget(w);
        if (unwrapWidget.isDisposed()) {
            return null;
        }
        try {
            event.widget = unwrapWidget;
            this.sendEventRaw(event.type, event);
            return event;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(Widget w, Event event) {
        if (w.isDisposed()) {
            return null;
        }
        try {
            event.widget = w;
            this.sendEventRaw(event.type, event);
            return event;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public void sendAll(Widget w, Event[] events) {
        Event[] eventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            this.sendEvent(w, event);
            ++n2;
        }
    }

    public Event sendEvent(Widget w, int event) {
        try {
            Event e = this.createEvent(w);
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(SWTUIElement w, Widget item, int event) {
        try {
            Event e = this.createEvent(w);
            e.item = item;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(SWTUIElement w, Widget item, int event, int button, int x, int y) {
        try {
            Event e = this.createEvent(w);
            e.item = item;
            e.button = button;
            e.x = x;
            e.y = y;
            e.type = event;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(Widget w, Widget item, int event) {
        try {
            Event e = this.createEvent(w);
            e.item = item;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public Event sendEvent(Widget w, Widget item, Event event) {
        if (w.isDisposed() || item != null && item.isDisposed()) {
            return null;
        }
        try {
            event.widget = w;
            event.item = item;
            this.sendEventRaw(event.type, event);
            return event;
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
            return null;
        }
    }

    public Event sendEvent(Widget w, Widget item, int event, int detail) {
        try {
            Event e = this.createEvent(w);
            e.item = item;
            e.detail = detail;
            this.sendEventRaw(event, e);
            return e;
        }
        catch (SecurityException e) {
            TeslaCore.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public void sendAll(Widget w, Widget item, Event[] events) {
        Event[] eventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            this.sendEvent(w, item, event);
            ++n2;
        }
    }

    public static Event clone(Event other) {
        Event result = new Event();
        Field[] fieldArray = Event.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 1) != 0) {
                try {
                    field.set(result, field.get(other));
                }
                catch (Exception e) {
                    SWTTeslaActivator.log(e);
                }
            }
            ++n2;
        }
        return result;
    }

    public synchronized void sendFocus(Widget widget) {
        boolean sendUnfocus;
        if (widget.isDisposed()) {
            return;
        }
        if (!(widget instanceof Control)) {
            return;
        }
        Control ctrl = (Control)widget;
        boolean bl = sendUnfocus = TeslaCellEditorManager.getInstance().getEditors().length > 0;
        if (sendUnfocus) {
            if (ctrl != this.lastFocusControl) {
                if (ctrl == this.lastFocusControl) {
                    return;
                }
                if (this.lastFocusControl != null && !this.lastFocusControl.isDisposed() && this.lastFocusControl.isFocusControl()) {
                    this.sendEvent((Widget)this.lastFocusControl, 16);
                    if (!this.lastFocusControl.isDisposed()) {
                        this.sendEvent((Widget)this.lastFocusControl, 27);
                    }
                    if (!this.lastFocusControl.isDisposed()) {
                        this.sendEvent((Widget)this.lastFocusControl, 7);
                    }
                }
                this.lastFocusControl = ctrl;
                if (!ctrl.isFocusControl()) {
                    ctrl.setFocus();
                    this.sendEvent((Widget)this.lastFocusControl, 6);
                    this.sendEvent((Widget)this.lastFocusControl, 5);
                    this.sendEvent((Widget)this.lastFocusControl, 26);
                    this.sendEvent((Widget)this.lastFocusControl, 15);
                }
            }
        } else {
            if (!ctrl.isFocusControl()) {
                try {
                    ShellUtilsProvider.getShellUtils().forceActive((Object)ctrl.getShell());
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                ctrl.setFocus();
                ctrl.forceFocus();
                this.sendEvent((Widget)ctrl, 6);
                this.sendEvent((Widget)ctrl, 5);
                this.sendEvent((Widget)ctrl, 26);
                this.sendEvent((Widget)ctrl, 15);
            }
            this.lastFocusControl = ctrl;
        }
    }

    public synchronized void sendUnfocus(Widget widget) {
        boolean sendUnfocus;
        if (widget.isDisposed()) {
            return;
        }
        if (!(widget instanceof Control)) {
            return;
        }
        Control ctrl = (Control)widget;
        boolean bl = sendUnfocus = TeslaCellEditorManager.getInstance().getEditors().length > 0;
        if (!sendUnfocus) {
            if (ctrl.isFocusControl() || widget == this.lastFocusControl) {
                if (!ctrl.isDisposed()) {
                    this.sendEvent((Widget)ctrl, 16);
                }
                if (!ctrl.isDisposed()) {
                    this.sendEvent((Widget)ctrl, 27);
                }
                if (!ctrl.isDisposed()) {
                    this.sendEvent((Widget)ctrl, 5);
                }
                if (!ctrl.isDisposed()) {
                    this.sendEvent((Widget)ctrl, 7);
                }
            }
            this.lastFocusControl = null;
            TeslaEventManager.getManager().setForceFocusControl(null);
        }
    }
}

