/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.events;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rcptt.sherlock.core.SherlockTimerRunnable;
import org.eclipse.rcptt.tesla.swt.events.ITimerExecHelper;
import org.eclipse.rcptt.tesla.swt.events.TimerUtils;
import org.eclipse.swt.widgets.Display;

public class TeslaTimerExecManager {
    private static TeslaTimerExecManager manager = new TeslaTimerExecManager();
    private Set<ITimerExecHelper> listeners = new HashSet<ITimerExecHelper>();
    private List<WeakReference<TimerInfo>> timers = new ArrayList<WeakReference<TimerInfo>>();

    private TeslaTimerExecManager() {
    }

    public synchronized void recordTimerExec(Runnable run, int time) {
        WeakReference<TimerInfo> info2;
        for (WeakReference<TimerInfo> info2 : this.timers) {
            TimerInfo timerInfo = (TimerInfo)info2.get();
            if (timerInfo == null || !timerInfo.hasRunnable(run)) continue;
            this.updateTimer(run, time, timerInfo);
            return;
        }
        info2 = new TimerInfo();
        ((TimerInfo)((Object)info2)).runnable = run;
        ((TimerInfo)((Object)info2)).time = time;
        ((TimerInfo)((Object)info2)).firstSheduleTime = System.currentTimeMillis();
        ((TimerInfo)((Object)info2)).resheduleCounter = 0L;
        ((TimerInfo)((Object)info2)).execQualifier = this.getTimerCallQualifier((TimerInfo)((Object)info2), Thread.currentThread().getStackTrace());
        this.timers.add(new WeakReference<Object>(info2));
    }

    private String getTimerCallQualifier(TimerInfo info, StackTraceElement[] stackTrace) {
        if (info.getRunnable().getClass().getName().indexOf("$") == -1) {
            return null;
        }
        int i = 0;
        while (i < stackTrace.length) {
            if (stackTrace[i].getClassName().equals(Display.class.getName()) && stackTrace[i].getMethodName().equals("timerExec")) {
                return String.valueOf(stackTrace[i + 1].getMethodName()) + ":" + stackTrace[i + 1].getLineNumber();
            }
            ++i;
        }
        return null;
    }

    private void updateTimer(Runnable run, int time, TimerInfo info) {
        ++info.resheduleCounter;
        info.time = time;
    }

    public synchronized List<TimerInfo> getTimers() {
        ArrayList<TimerInfo> result = new ArrayList<TimerInfo>();
        for (WeakReference<TimerInfo> timerInfo : this.timers) {
            TimerInfo info = (TimerInfo)timerInfo.get();
            if (info == null) continue;
            result.add(info);
        }
        return result;
    }

    public synchronized void clearTimers() {
        this.timers.clear();
    }

    public boolean isNeedNullify(Runnable run, int time) {
        for (ITimerExecHelper listener : this.listeners) {
            if (!listener.needNullify(run, time)) continue;
            return true;
        }
        return false;
    }

    public static TeslaTimerExecManager getManager() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(ITimerExecHelper listener) {
        Set<ITimerExecHelper> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(ITimerExecHelper listener) {
        Set<ITimerExecHelper> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Set<ITimerExecHelper> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITimerExecHelper> getListeners() {
        ArrayList<ITimerExecHelper> copy = null;
        Set<ITimerExecHelper> set = this.listeners;
        synchronized (set) {
            copy = new ArrayList<ITimerExecHelper>(this.listeners);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Set<ITimerExecHelper> set = this.listeners;
        synchronized (set) {
            return !this.listeners.isEmpty();
        }
    }

    public synchronized void afterRunTimers(Display display) {
        try {
            Runnable[] currentTimers = TimerUtils.getTimers(display);
            Iterator<WeakReference<TimerInfo>> iterator = this.timers.iterator();
            while (iterator.hasNext()) {
                TimerInfo info = (TimerInfo)iterator.next().get();
                boolean found = false;
                if (info != null) {
                    Runnable[] runnableArray = currentTimers;
                    int n = currentTimers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Runnable e = runnableArray[n2];
                        if (info.hasRunnable(e)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (found) continue;
                iterator.remove();
            }
        }
        catch (Exception exception) {
            this.timers.clear();
        }
    }

    public static boolean isTimerIgnored(String clName) {
        if (clName.contains("org.eclipse.swt")) {
            return true;
        }
        if (clName.contains("org.eclipse.gef")) {
            return true;
        }
        if (clName.contains("org.eclipse.gmf")) {
            return true;
        }
        if (clName.contains("org.eclipse.ui.internal.ide.application.IDEIdleHelper")) {
            return true;
        }
        if (clName.contains("org.eclipse.tm.internal.terminal.textcanvas.PollingTextCanvasModel")) {
            return true;
        }
        return clName.startsWith("org.eclipse.nebula.widgets.oscilloscope.OscilloscopeDispatcher");
    }

    public static class TimerInfo {
        public Runnable runnable;
        public String execQualifier;
        public long firstSheduleTime = 0L;
        public long time;
        public long resheduleCounter = 0L;

        public boolean hasRunnable(Runnable run) {
            Runnable thisRun = this.getRunnable(this.runnable);
            Runnable runRun = this.getRunnable(run);
            return thisRun.equals(runRun);
        }

        private Runnable getRunnable(Runnable ref) {
            if (ref instanceof SherlockTimerRunnable) {
                return ((SherlockTimerRunnable)ref).getRunnable();
            }
            return ref;
        }

        public Runnable getRunnable() {
            return this.getRunnable(this.runnable);
        }
    }
}

