/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;

public class AUTInformation {
    private static final String OSGI_PLUGIN = "org.eclipse.osgi";
    private static final String SWT_PLUGIN = "org.eclipse.swt";
    public static final String VERSION = "Version";
    public static final String EMF_WORKSPACE = "EMF Workspace";
    public static final String EMF_TRANSACTION = "EMF Transaction";
    public static final String EMF_VALIDATION = "EMF Validation";
    public static final String OSGI = "OSGI";
    public static final String PDE = "PDE";
    public static final String EMF = "EMF";
    public static final String GMF = "GMF";
    public static final String GEF = "GEF";
    public static final String JDT = "JDT";
    public static final String RAP = "RAP";
    public static final String PLATFORM = "Platform";
    private static final String TESLA_PLUGIN = "org.eclipse.rcptt.tesla";
    private static final String Q7_PLUGIN = "org.eclipse.rcptt";
    private static final String PDE_PLUGIN = "org.eclipse.pde";
    private static final String EMF_VALIDATION_PLUGIN = "org.eclipse.emf.validation";
    private static final String EMF_TRANSACTION_PLUGIN = "org.eclipse.emf.transaction";
    private static final String EMF_FEATURE = "org.eclipse.emf";
    private static final String GMF_FEATURE = "org.eclipse.gmf";
    private static final String GMF_PLUGIN = "org.eclipse.gmf.runtime.diagram.ui";
    private static final String GEF_PLUGIN = "org.eclipse.gef";
    private static final String JDT_PLUGIN = "org.eclipse.jdt";
    private static final String RAP_PLUGIN = "org.eclipse.rap.rwt";

    public static Map<String, Version> getInformationMap(ITargetDefinition platform) throws CoreException {
        TargetFeature[] features;
        String version;
        VersionMap values = new VersionMap();
        MultiStatus warnings = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Detected potential problems in target platform " + platform, null);
        if (platform.getTargetLocations().length <= 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", "No containers in target platform " + platform));
        }
        TargetBundle[] allBundles = platform.getAllBundles();
        HashMap<String, BundleInfo> resolvedBundles = new HashMap<String, BundleInfo>();
        TargetBundle[] targetBundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle bundle = targetBundleArray[n2];
            BundleInfo bundleInfo = bundle.getBundleInfo();
            String bundleName = bundleInfo.getSymbolicName();
            BundleInfo oldValue = (BundleInfo)resolvedBundles.get(bundleName);
            if (oldValue != null && !Objects.equal((Object)oldValue.getVersion(), (Object)bundleInfo.getVersion())) {
                warnings.add(AUTInformation.createWarning("Multiple versions of bundle " + oldValue.getLocation() + " and " + bundleInfo.getLocation()));
            }
            resolvedBundles.put(bundleName, bundleInfo);
            ++n2;
        }
        BundleInfo bundleInfo = (BundleInfo)resolvedBundles.get(SWT_PLUGIN);
        if (bundleInfo != null) {
            AUTInformation.putSwtVersion(values, Version.create((String)bundleInfo.getVersion()));
        } else {
            bundleInfo = (BundleInfo)resolvedBundles.get(RAP_PLUGIN);
            AUTInformation.putRwtVersion(values, Version.create((String)bundleInfo.getVersion()));
            values.putPluginVersion(RAP, bundleInfo);
        }
        values.putPluginVersion(GEF, (BundleInfo)resolvedBundles.get(GEF_PLUGIN));
        values.putPluginVersion(GMF, (BundleInfo)resolvedBundles.get(GMF_PLUGIN));
        values.putPluginVersion(OSGI, (BundleInfo)resolvedBundles.get(OSGI_PLUGIN));
        BundleInfo platformBundle = (BundleInfo)resolvedBundles.get("org.eclipse.platform");
        if (platformBundle != null && VersionUtil.validateVersion((String)(version = platformBundle.getVersion())).getSeverity() == 0) {
            AUTInformation.putVersionPlatform(values, Version.create((String)version));
        }
        TargetFeature[] targetFeatureArray = features = platform.getAllFeatures();
        int n3 = features.length;
        int n4 = 0;
        while (n4 < n3) {
            TargetFeature feature = targetFeatureArray[n4];
            TargetFeature iFeature = feature;
            if (iFeature.getId().equals("org.eclipse.platform")) {
                values.put(PLATFORM, iFeature.getVersion());
            }
            if (iFeature.getId().equals(EMF_FEATURE)) {
                values.put(EMF, iFeature.getVersion());
            }
            if (iFeature.getId().equals(JDT_PLUGIN)) {
                values.put(JDT, iFeature.getVersion());
            }
            if (iFeature.getId().equals(GEF_PLUGIN)) {
                values.put(GEF, iFeature.getVersion());
            }
            if (iFeature.getId().equals(GMF_FEATURE)) {
                values.put(GMF, iFeature.getVersion());
            }
            if (iFeature.getId().equals(EMF_TRANSACTION_PLUGIN)) {
                values.put(EMF_TRANSACTION, iFeature.getVersion());
            }
            if (iFeature.getId().equals(EMF_VALIDATION_PLUGIN)) {
                values.put(EMF_VALIDATION, iFeature.getVersion());
            }
            if (iFeature.getId().equals(PDE_PLUGIN)) {
                values.put(PDE, iFeature.getVersion());
            }
            if (iFeature.getId().equals(Q7_PLUGIN)) {
                values.put("Q7", iFeature.getVersion());
            }
            if (iFeature.getId().equals(TESLA_PLUGIN)) {
                values.put("Tesla", iFeature.getVersion());
            }
            ++n4;
        }
        if (!warnings.isOK()) {
            Q7LaunchingPlugin.log((IStatus)warnings);
        }
        return values;
    }

    private static IStatus createWarning(String string) {
        return new Status(2, "org.eclipse.rcptt.launching.ext", string);
    }

    private static void putSwtVersion(VersionMap values, Version swtVersion) {
        if (!(swtVersion instanceof OSGiVersion)) {
            return;
        }
        int major = ((OSGiVersion)swtVersion).getMajor();
        if (major != 3) {
            return;
        }
        int minor = ((OSGiVersion)swtVersion).getMinor();
        if (minor == 0) {
            values.put(VERSION, "3.0");
        } else if (minor == 1) {
            values.put(VERSION, "3.1");
        } else if (minor == 2) {
            values.put(VERSION, "3.2");
        } else if (minor == 3) {
            values.put(VERSION, "3.3");
        } else if (minor == 4) {
            values.put(VERSION, "3.4");
        } else if (minor == 5) {
            values.put(VERSION, "3.5");
        } else if (minor == 6) {
            values.put(VERSION, "3.6");
        } else if (minor == 7) {
            values.put(VERSION, "3.7");
        } else if (minor == 8) {
            values.put(VERSION, "3.8");
        } else if (minor == 100) {
            values.put(VERSION, "4.2");
        } else if (minor == 102) {
            values.put(VERSION, "4.3");
        } else if (minor == 103) {
            values.put(VERSION, "4.4");
        } else if (minor == 104) {
            values.put(VERSION, "4.5");
        } else if (minor == 105) {
            values.put(VERSION, "4.6");
        } else if (minor == 106) {
            values.put(VERSION, "4.7");
        } else if (minor == 107) {
            values.put(VERSION, "4.8");
        } else if (minor == 108) {
            values.put(VERSION, "4.9");
        }
    }

    private static void putRwtVersion(VersionMap values, Version swtVersion) {
        if (!(swtVersion instanceof OSGiVersion)) {
            return;
        }
        int major = ((OSGiVersion)swtVersion).getMajor();
        if (major != 3) {
            return;
        }
        int minor = ((OSGiVersion)swtVersion).getMinor();
        if (minor <= 6) {
            values.put(VERSION, "4.3");
        }
    }

    private static void putVersionPlatform(VersionMap values, Version version) {
        if (!(version instanceof OSGiVersion)) {
            return;
        }
        int major = ((OSGiVersion)version).getMajor();
        int minor = ((OSGiVersion)version).getMinor();
        if (major == 4 && minor == 4) {
            values.put(VERSION, "4.4");
        }
    }

    static class VersionMap
    extends TreeMap<String, Version> {
        VersionMap() {
        }

        @Override
        public Version put(String key, String value) {
            return super.put(key, Version.create((String)value));
        }

        public void putPluginVersion(String key, BundleInfo plugin) {
            if (plugin == null) {
                return;
            }
            this.put(key, Version.create((String)plugin.getVersion()));
        }

        public void putFeatureVersion(String key, IFeature feature) {
            if (feature == null) {
                return;
            }
            this.put(key, Version.create((String)feature.getVersion()));
        }
    }
}

