/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.regex.Pattern;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.team.internal.ui.synchronize.RangeDifferenceComparator;

public class RegexDiffComparator
extends RangeDifferenceComparator {
    private Pattern pattern;

    public RegexDiffComparator(Pattern pattern, boolean ignoreWhitespace) {
        super(ignoreWhitespace);
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean compareRangeDifferences(RangeDifference[] ranges, IDocument lDoc, IDocument rDoc) {
        try {
            int i = 0;
            while (true) {
                if (i >= ranges.length) {
                    return true;
                }
                RangeDifference diff = ranges[i];
                if (diff.kind() != 0) {
                    DocLineComparator sleft = new DocLineComparator(lDoc, null, this.shouldIgnoreWhitespace());
                    DocLineComparator sright = new DocLineComparator(rDoc, null, this.shouldIgnoreWhitespace());
                    IRegion lRegion = lDoc.getLineInformation(diff.leftStart());
                    int leftEnd = sleft.getTokenStart(diff.leftStart() + diff.leftLength());
                    String left = lDoc.get(lRegion.getOffset(), leftEnd - lRegion.getOffset());
                    IRegion rRegion = rDoc.getLineInformation(diff.rightStart());
                    int rightEnd = sright.getTokenStart(diff.rightStart() + diff.rightLength());
                    String right = rDoc.get(rRegion.getOffset(), rightEnd - rRegion.getOffset());
                    boolean m1 = this.pattern.matcher(left).matches();
                    boolean m2 = this.pattern.matcher(right).matches();
                    if (!m1 && !m2) {
                        return false;
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return true;
    }
}

