/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDERegistryStrategy;
import org.eclipse.pde.internal.core.TargetPDERegistryStrategy;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class PDEExtensionRegistry {
    private Object fMasterKey = new Object();
    private Object fUserKey = new Object();
    private IExtensionRegistry fRegistry = null;
    private PDERegistryStrategy fStrategy = null;
    private IPluginModelBase[] fModels = null;
    private ArrayList<IRegistryChangeListener> fListeners = new ArrayList();
    private static final String EXTENSION_DIR = ".extensions";

    public PDEExtensionRegistry() {
        if (this.fStrategy == null) {
            File extensionsDir = new File(PDECore.getDefault().getStateLocation().toFile(), EXTENSION_DIR);
            this.fStrategy = new PDERegistryStrategy(new File[]{extensionsDir}, new boolean[1], this.fMasterKey, this);
        }
    }

    public PDEExtensionRegistry(IPluginModelBase[] models) {
        this.fModels = models;
        if (this.fStrategy == null) {
            File extensionsDir = new File(PDECore.getDefault().getStateLocation().toFile(), EXTENSION_DIR);
            this.fStrategy = new TargetPDERegistryStrategy(new File[]{extensionsDir}, new boolean[1], this.fMasterKey, this);
        }
    }

    protected IPluginModelBase[] getModels() {
        if (this.fModels == null) {
            IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
            IPluginModelBase[] externalModels = PluginRegistry.getExternalModels();
            IPluginModelBase[] allModels = new IPluginModelBase[workspaceModels.length + externalModels.length];
            System.arraycopy(workspaceModels, 0, allModels, 0, workspaceModels.length);
            System.arraycopy(externalModels, 0, allModels, workspaceModels.length, externalModels.length);
            return allModels;
        }
        return this.fModels;
    }

    public void stop() {
        if (this.fRegistry != null) {
            this.fRegistry.stop(this.fMasterKey);
        }
        this.dispose();
    }

    protected synchronized IExtensionRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.createRegistry();
            ListIterator<IRegistryChangeListener> li = this.fListeners.listIterator();
            while (li.hasNext()) {
                this.fRegistry.addRegistryChangeListener(li.next());
            }
        }
        return this.fRegistry;
    }

    private IExtensionRegistry createRegistry() {
        return RegistryFactory.createRegistry((RegistryStrategy)this.fStrategy, (Object)this.fMasterKey, (Object)this.fUserKey);
    }

    public void targetReloaded() {
        if (this.fRegistry != null) {
            this.fRegistry.stop(this.fMasterKey);
        }
        CoreUtility.deleteContent(new File(PDECore.getDefault().getStateLocation().toFile(), EXTENSION_DIR));
        this.fRegistry = null;
    }

    public void dispose() {
        this.fStrategy.dispose();
        this.fRegistry = null;
    }

    public IPluginModelBase[] findExtensionPlugins(String pointId, boolean activeOnly) {
        IExtensionPoint point = this.getExtensionPoint(pointId);
        if (point == null) {
            return activeOnly ? PluginRegistry.getActiveModels() : PluginRegistry.getAllModels();
        }
        IExtension[] exts = point.getExtensions();
        HashSet<IPluginModelBase> plugins = new HashSet<IPluginModelBase>();
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IPluginModelBase base = this.getPlugin(ext.getContributor(), false);
            if (!(base == null || plugins.contains(base) || activeOnly && !base.isEnabled())) {
                plugins.add(base);
            }
            ++n2;
        }
        return plugins.toArray(new IPluginModelBase[plugins.size()]);
    }

    public IPluginModelBase findExtensionPointPlugin(String pointId) {
        IExtensionPoint point = this.getExtensionPoint(pointId);
        if (point == null) {
            return null;
        }
        IContributor contributor = point.getContributor();
        return this.getPlugin(contributor, true);
    }

    private IExtensionPoint getExtensionPoint(String pointId) {
        return this.getRegistry().getExtensionPoint(pointId);
    }

    public boolean hasExtensionPoint(String pointId) {
        return this.getExtensionPoint(pointId) != null;
    }

    public IPluginExtensionPoint findExtensionPoint(String pointId) {
        IPluginModelBase model;
        IExtensionPoint extPoint = this.getExtensionPoint(pointId);
        if (extPoint != null && (model = this.getPlugin(extPoint.getContributor(), true)) != null) {
            IPluginExtensionPoint[] points;
            IPluginExtensionPoint[] iPluginExtensionPointArray = points = model.getPluginBase().getExtensionPoints();
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtensionPoint point = iPluginExtensionPointArray[n2];
                if (point.getFullId().equals(pointId)) {
                    return point;
                }
                ++n2;
            }
        }
        return null;
    }

    public IPluginExtension[] findExtensionsForPlugin(IPluginModelBase base) {
        IContributor contributor = this.fStrategy.createContributor(base);
        if (contributor == null) {
            return new IPluginExtension[0];
        }
        IExtension[] extensions = this.getRegistry().getExtensions(this.fStrategy.createContributor(base));
        ArrayList<PluginExtension> list = new ArrayList<PluginExtension>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            PluginExtension extension = new PluginExtension(ext);
            extension.setModel(this.getExtensionsModel(base));
            extension.setParent(base.getExtensions());
            list.add(extension);
            ++n2;
        }
        return list.toArray(new IPluginExtension[list.size()]);
    }

    public IPluginExtensionPoint[] findExtensionPointsForPlugin(IPluginModelBase base) {
        IContributor contributor = this.fStrategy.createContributor(base);
        if (contributor == null) {
            return new IPluginExtensionPoint[0];
        }
        IExtensionPoint[] extensions = this.getRegistry().getExtensionPoints(this.fStrategy.createContributor(base));
        ArrayList<PluginExtensionPoint> list = new ArrayList<PluginExtensionPoint>();
        IExtensionPoint[] iExtensionPointArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint extension = iExtensionPointArray[n2];
            PluginExtensionPoint point = new PluginExtensionPoint(extension);
            point.setModel(this.getExtensionsModel(base));
            point.setParent(base.getExtensions());
            list.add(point);
            ++n2;
        }
        return list.toArray(new IPluginExtensionPoint[list.size()]);
    }

    private ISharedPluginModel getExtensionsModel(IPluginModelBase base) {
        if (base instanceof IBundlePluginModelBase) {
            return ((IBundlePluginModelBase)base).getExtensionsModel();
        }
        return base;
    }

    public IExtension[] findExtensions(String extensionPointId, boolean activeOnly) {
        ArrayList<IExtension> list = new ArrayList<IExtension>();
        IExtensionPoint point = this.getExtensionPoint(extensionPointId);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            if (!activeOnly) {
                return extensions;
            }
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IPluginModelBase base = this.getPlugin(extension.getContributor(), true);
                if (base != null && base.isEnabled()) {
                    list.add(extension);
                }
                ++n2;
            }
        } else {
            IPluginModelBase[] bases;
            IPluginModelBase[] iPluginModelBaseArray = bases = activeOnly ? PluginRegistry.getActiveModels() : PluginRegistry.getAllModels();
            int n = bases.length;
            int n3 = 0;
            while (n3 < n) {
                IPluginModelBase base = iPluginModelBaseArray[n3];
                IContributor contributor = this.fStrategy.createContributor(base);
                if (contributor != null) {
                    IExtension[] extensions;
                    IExtension[] iExtensionArray = extensions = this.getRegistry().getExtensions(contributor);
                    int n4 = extensions.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IExtension extension = iExtensionArray[n5];
                        if (extension.getExtensionPointUniqueIdentifier().equals(extensionPointId)) {
                            list.add(extension);
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        return list.toArray(new IExtension[list.size()]);
    }

    private IPluginModelBase getPlugin(IContributor icontributor, boolean searchAll) {
        if (!(icontributor instanceof RegistryContributor)) {
            return null;
        }
        RegistryContributor contributor = (RegistryContributor)icontributor;
        long bundleId = Long.parseLong(contributor.getActualId());
        BundleDescription desc = PDECore.getDefault().getModelManager().getState().getState().getBundle(Long.parseLong(contributor.getActualId()));
        if (desc != null) {
            return PluginRegistry.findModel(desc);
        }
        ModelEntry entry = PluginRegistry.findEntry(contributor.getActualName());
        if (entry != null) {
            IPluginModelBase[] externalModels;
            if (!searchAll && entry.getWorkspaceModels().length > 0) {
                return null;
            }
            IPluginModelBase[] iPluginModelBaseArray = externalModels = entry.getExternalModels();
            int n = externalModels.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                BundleDescription extDesc = model.getBundleDescription();
                if (extDesc != null && extDesc.getBundleId() == bundleId) {
                    return model;
                }
                ++n2;
            }
        }
        return null;
    }

    public void addListener(IRegistryChangeListener listener) {
        this.fRegistry.addRegistryChangeListener(listener);
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(IRegistryChangeListener listener) {
        this.fRegistry.removeRegistryChangeListener(listener);
        this.fListeners.remove(listener);
    }
}

