/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.ui.launching.ITestEngineLaunchConfig;

public class TestEngineLaunchConfigManager {
    private static TestEngineLaunchConfigManager instance;
    private static final String TESTENGINE_UI_EXTPT = "org.eclipse.rcptt.ui.testEngineLaunchConfigs";
    private static final String TESTENGINE_UI_ENGINEID_ATTR = "testEngineId";
    private static final String TESTENGINE_UI_CLASS_ATTR = "class";
    private List<TestEngineLaunchConfig> launchConfigs;

    public static TestEngineLaunchConfigManager getInstance() {
        if (instance == null) {
            instance = new TestEngineLaunchConfigManager();
        }
        return instance;
    }

    public TestEngineLaunchConfigManager() {
        IConfigurationElement[] elements;
        ArrayList<TestEngineLaunchConfig> launchConfigs = new ArrayList<TestEngineLaunchConfig>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TESTENGINE_UI_EXTPT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(TESTENGINE_UI_ENGINEID_ATTR);
            try {
                ITestEngineLaunchConfig paramGroup = (ITestEngineLaunchConfig)element.createExecutableExtension(TESTENGINE_UI_CLASS_ATTR);
                launchConfigs.add(new TestEngineLaunchConfig(id, paramGroup));
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log((Throwable)e);
            }
            ++n2;
        }
        this.launchConfigs = launchConfigs;
    }

    public List<TestEngineLaunchConfig> getLaunchConfigs() {
        return this.launchConfigs;
    }

    public class TestEngineLaunchConfig {
        private String id;
        private ITestEngineLaunchConfig config;

        public TestEngineLaunchConfig(String id, ITestEngineLaunchConfig config) {
            this.id = id;
            this.config = config;
        }

        public String getId() {
            return this.id;
        }

        public ITestEngineLaunchConfig getConfig() {
            return this.config;
        }
    }
}

