/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.preferences.ConfigurationEditorComponent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class RepositoryPropertyPage
extends PropertyPage {
    private ConfigurationEditorComponent editor;

    protected Control createContents(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(displayArea);
        GridDataFactory.fillDefaults().applyTo((Control)displayArea);
        final Repository repo = (Repository)AdapterUtils.adapt((Object)this.getElement(), Repository.class);
        if (repo == null) {
            return displayArea;
        }
        StoredConfig config = repo.getConfig();
        if (config instanceof FileBasedConfig) {
            File configFile = ((FileBasedConfig)config).getFile();
            config = new FileBasedConfig(configFile, repo.getFS());
            config.addChangeListener(new ConfigChangedListener(){

                public void onConfigChanged(ConfigChangedEvent event) {
                    repo.fireEvent((RepositoryEvent)new ConfigChangedEvent());
                }
            });
        }
        this.editor = new ConfigurationEditorComponent(displayArea, config, true, 0){

            @Override
            protected void setErrorMessage(String message) {
                RepositoryPropertyPage.this.setErrorMessage(message);
            }
        };
        this.editor.createContents();
        return displayArea;
    }

    protected void performDefaults() {
        if (this.editor != null) {
            try {
                this.editor.restore();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.editor != null) {
            try {
                this.editor.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return super.performOk();
    }
}

