/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.target;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.target.Messages;

public class TargetFeature {
    private IFeatureModel featureModel;

    public TargetFeature(File featureLocation) throws CoreException {
        this.initialize(featureLocation);
    }

    public String getId() {
        if (this.featureModel == null) {
            return null;
        }
        return this.featureModel.getFeature().getId();
    }

    public String getVersion() {
        if (this.featureModel == null) {
            return null;
        }
        return this.featureModel.getFeature().getVersion();
    }

    public String getLocation() {
        if (this.featureModel == null) {
            return null;
        }
        return this.featureModel.getInstallLocation();
    }

    public NameVersionDescriptor[] getPlugins() {
        IFeaturePlugin[] plugins = this.featureModel.getFeature().getPlugins();
        NameVersionDescriptor[] result = new NameVersionDescriptor[plugins.length];
        int i = 0;
        while (i < plugins.length) {
            result[i] = new NameVersionDescriptor(plugins[i].getId(), plugins[i].getVersion());
            ++i;
        }
        return result;
    }

    public NameVersionDescriptor[] getDependentFeatures() {
        IFeatureChild[] featureIncludes;
        IFeatureImport[] featureImports;
        ArrayList<NameVersionDescriptor> result = new ArrayList<NameVersionDescriptor>();
        IFeature feature = this.featureModel.getFeature();
        IFeatureImport[] iFeatureImportArray = featureImports = feature.getImports();
        int n = featureImports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport featureImport = iFeatureImportArray[n2];
            if (featureImport.getType() == 1) {
                result.add(new NameVersionDescriptor(featureImport.getId(), null, "feature"));
            }
            ++n2;
        }
        IFeatureChild[] iFeatureChildArray = featureIncludes = feature.getIncludedFeatures();
        int n3 = featureIncludes.length;
        n = 0;
        while (n < n3) {
            IFeatureChild featureInclude = iFeatureChildArray[n];
            result.add(new NameVersionDescriptor(featureInclude.getId(), null, "feature"));
            ++n;
        }
        return result.toArray(new NameVersionDescriptor[result.size()]);
    }

    private void initialize(File file) throws CoreException {
        File featureXML;
        if (file == null || !file.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.TargetFeature_FileDoesNotExist, (Object)file)));
        }
        if ("feature.xml".equalsIgnoreCase(file.getName())) {
            featureXML = file;
        } else {
            featureXML = new File(file, "feature.xml");
            if (!featureXML.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.TargetFeature_FileDoesNotExist, (Object)featureXML)));
            }
        }
        this.featureModel = ExternalFeatureModelManager.createModel(featureXML);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getId()).append(' ').append(this.getVersion()).append(" (Feature)");
        return result.toString();
    }
}

