/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.validators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;

public class TestSuiteItemsValidator
implements IQ7Validator {
    private static String getName(TestSuiteItem item) {
        return item.getNamedElemetName() != null ? item.getNamedElemetName() : item.getNamedElementId();
    }

    @Override
    public void validate(IQ7NamedElement element, IQ7ProblemReporter reporter, IProgressMonitor monitor) {
        if (!(element instanceof ITestSuite)) {
            return;
        }
        ITestSuite suite = (ITestSuite)element;
        try {
            ISearchScope scope = TestSuiteItemsValidator.getSearchScope(suite);
            TestSuiteItem[] testSuiteItemArray = suite.getItems();
            int n = testSuiteItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestSuiteItem test = testSuiteItemArray[n2];
                IQ7NamedElement q7Element = Q7SearchCore.getTestSuiteItemElement((TestSuiteItem)test, (ISearchScope)scope);
                if (q7Element == null) {
                    reporter.reportProblem((IFile)suite.getResource(), IQ7ProblemReporter.ProblemType.Error, "Test " + TestSuiteItemsValidator.getName(test) + " not found for test suite: " + element.getName(), 0, 0, 0, 0);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Error, "Bad test suite: " + e.getMessage(), 0, 0, 0, 0);
        }
    }

    private static ISearchScope getSearchScope(ITestSuite suiteModel) {
        IQ7Project testSuiteProject = suiteModel.getQ7Project();
        ReferencedProjectScope scope = testSuiteProject != null ? new ReferencedProjectScope(testSuiteProject) : new AllProjectScope();
        return scope;
    }

    @Override
    public void reconcile(IQ7NamedElement content, String eclCode, IQ7ProblemReporter reporter, IProgressMonitor nullProgressMonitor) {
    }
}

