/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.AbstractToggleLinkingAction;
import org.eclipse.jdt.internal.ui.actions.CategoryFilterActionGroup;
import org.eclipse.jdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragSupport;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropSupport;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.TogglePresentationAction;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.SourcePositionComparator;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.jdt.ui.actions.OpenViewActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class JavaOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable,
IPostSelectionProvider {
    static Object[] NO_CHILDREN = new Object[0];
    private boolean fTopLevelTypeOnly;
    private IJavaElement fInput;
    private String fContextMenuID;
    private Menu fMenu;
    private JavaOutlineViewer fOutlineViewer;
    private JavaEditor fEditor;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ListenerList<ISelectionChangedListener> fSelectionChangedListeners = new ListenerList(1);
    private ListenerList<ISelectionChangedListener> fPostSelectionChangedListeners = new ListenerList(1);
    private Hashtable<String, IAction> fActions = new Hashtable();
    private TogglePresentationAction fTogglePresentation;
    private ToggleLinkingAction fToggleLinkingAction;
    private CollapseAllAction fCollapseAllAction;
    private FormatElementAction fFormatElement;
    private CompositeActionGroup fActionGroups;
    private IPropertyChangeListener fPropertyChangeListener;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private CategoryFilterActionGroup fCategoryFilterActionGroup;
    private JdtViewerDropSupport fDropSupport;
    private OpenAndLinkWithEditorHelper fOpenAndLinkWithEditorHelper;

    public JavaOutlinePage(String contextMenuID, JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fContextMenuID = contextMenuID;
        this.fEditor = editor;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                JavaOutlinePage.this.doPropertyChange(event);
            }
        };
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        if (this.fOutlineViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.fOutlineViewer.refresh(false);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.add((Object)listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removeSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setSelection(selection);
        }
    }

    public ISelection getSelection() {
        if (this.fOutlineViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fOutlineViewer.getSelection();
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addPostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.add((Object)listener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removePostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.remove((Object)listener);
        }
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.fCollapseAllAction = new CollapseAllAction(this.fOutlineViewer);
        this.fCollapseAllAction.setActionDefinitionId("org.eclipse.ui.navigate.collapseAll");
        toolBarManager.add((IAction)this.fCollapseAllAction);
        toolBarManager.add((IAction)new LexicalSortingAction());
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fOutlineViewer, "org.eclipse.jdt.ui.JavaOutlinePage");
        this.fMemberFilterActionGroup.contributeToToolBar(toolBarManager);
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        IMenuManager viewMenuManager = actionBars.getMenuManager();
        viewMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
        this.fToggleLinkingAction = new ToggleLinkingAction();
        this.fToggleLinkingAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
        viewMenuManager.add((IAction)new ClassOnlyAction());
        viewMenuManager.add((IAction)this.fToggleLinkingAction);
        this.fCategoryFilterActionGroup = new CategoryFilterActionGroup((StructuredViewer)this.fOutlineViewer, "org.eclipse.jdt.ui.JavaOutlinePage", new IJavaElement[]{this.fInput});
        this.fCategoryFilterActionGroup.contributeToViewMenu(viewMenuManager);
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(0x210000204029L | JavaElementLabels.ALL_CATEGORY, 1);
        this.fOutlineViewer = new JavaOutlineViewer(tree);
        this.initDragAndDrop();
        this.fOutlineViewer.setContentProvider((IContentProvider)new ChildrenProvider());
        this.fOutlineViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(lprovider));
        for (ISelectionChangedListener listener : this.fSelectionChangedListeners) {
            this.fSelectionChangedListeners.remove((Object)listener);
            this.fOutlineViewer.addSelectionChangedListener(listener);
        }
        for (ISelectionChangedListener listener : this.fPostSelectionChangedListeners) {
            this.fPostSelectionChangedListeners.remove((Object)listener);
            this.fOutlineViewer.addPostSelectionChangedListener(listener);
        }
        MenuManager manager = new MenuManager(this.fContextMenuID, this.fContextMenuID);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                JavaOutlinePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fMenu = manager.createContextMenu((Control)tree);
        tree.setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu(String.valueOf(JavaPlugin.getPluginId()) + ".outline", manager, (ISelectionProvider)this.fOutlineViewer);
        this.updateSelectionProvider(site);
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenViewActionGroup(this), new CCPActionGroup(this), new GenerateActionGroup(this), new RefactorActionGroup(this), new JavaSearchActionGroup(this)});
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.fEditor.getAction(ITextEditorActionConstants.UNDO));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.fEditor.getAction(ITextEditorActionConstants.REDO));
        IAction action = this.fEditor.getAction(ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.fEditor.getAction(ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        this.fActionGroups.fillActionBars(actionBars);
        this.fFormatElement = new FormatElementAction(site);
        this.fFormatElement.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.quick.format");
        site.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fFormatElement);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.FormatElement", (IAction)this.fFormatElement);
        IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
        if (statusLineManager != null) {
            StatusBarUpdater updater = new StatusBarUpdater(statusLineManager);
            this.fOutlineViewer.addPostSelectionChangedListener(updater);
        }
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup("org.eclipse.jdt.ui.JavaOutlinePage", (StructuredViewer)this.fOutlineViewer);
        this.fOpenAndLinkWithEditorHelper = new OpenAndLinkWithEditorHelper((StructuredViewer)this.fOutlineViewer){

            protected void activate(ISelection selection) {
                JavaOutlinePage.this.fEditor.doSelectionChanged(selection);
                JavaOutlinePage.this.getSite().getPage().activate((IWorkbenchPart)JavaOutlinePage.this.fEditor);
            }

            protected void linkToEditor(ISelection selection) {
                JavaOutlinePage.this.fEditor.doSelectionChanged(selection);
            }

            protected void open(ISelection selection, boolean activate) {
                JavaOutlinePage.this.fEditor.doSelectionChanged(selection);
                if (activate) {
                    JavaOutlinePage.this.getSite().getPage().activate((IWorkbenchPart)JavaOutlinePage.this.fEditor);
                }
            }
        };
        this.registerToolbarActions(actionBars);
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)this.fToggleLinkingAction));
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)this.fCollapseAllAction));
        this.fOutlineViewer.setInput(this.fInput);
    }

    private void updateSelectionProvider(IPageSite site) {
        ICompilationUnit cu;
        Object provider = this.fOutlineViewer;
        if (this.fInput != null && (cu = (ICompilationUnit)this.fInput.getAncestor(5)) != null && !JavaModelUtil.isPrimary((ICompilationUnit)cu)) {
            provider = new EmptySelectionProvider();
        }
        site.setSelectionProvider((ISelectionProvider)provider);
    }

    public void dispose() {
        if (this.fEditor == null) {
            return;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.dispose();
            this.fCategoryFilterActionGroup = null;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        this.fEditor.outlinePageClosed();
        this.fEditor = null;
        this.fSelectionChangedListeners.clear();
        this.fSelectionChangedListeners = null;
        this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fFormatElement);
        this.fPostSelectionChangedListeners.clear();
        this.fPostSelectionChangedListeners = null;
        if (this.fPropertyChangeListener != null) {
            JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        this.fTogglePresentation.setEditor(null);
        this.fOutlineViewer = null;
        super.dispose();
    }

    public Control getControl() {
        if (this.fOutlineViewer != null) {
            return this.fOutlineViewer.getControl();
        }
        return null;
    }

    public void setInput(IJavaElement inputElement) {
        this.fInput = inputElement;
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setInput(this.fInput);
            this.updateSelectionProvider(this.getSite());
        }
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.setInput(new IJavaElement[]{this.fInput});
        }
    }

    public void select(ISourceReference reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.fOutlineViewer != null && (s = this.fOutlineViewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)reference);
            this.fOutlineViewer.setSelection(s, true);
        }
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return this.fActions.get(actionID);
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IShowInSource.class) {
            return (T)this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return (T)new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer"};
                }
            };
        }
        if (key == IShowInTarget.class) {
            return (T)this.getShowInTarget();
        }
        return null;
    }

    protected void addAction(IMenuManager menu, String group, String actionID) {
        IAction action = this.getAction(actionID);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (action.isEnabled()) {
                IMenuManager subMenu = menu.findMenuUsingPath(group);
                if (subMenu != null) {
                    subMenu.add(action);
                } else {
                    menu.appendToGroup(group, action);
                }
            }
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
    }

    public void setFocus() {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.getControl().setFocus();
        }
    }

    private boolean isInnerType(IJavaElement element) {
        block3: {
            if (element != null && element.getElementType() == 7) {
                IType type = (IType)element;
                try {
                    return type.isMember();
                }
                catch (JavaModelException javaModelException) {
                    IJavaElement parent = type.getParent();
                    if (parent == null) break block3;
                    int parentElementType = parent.getElementType();
                    return parentElementType != 5 && parentElementType != 6;
                }
            }
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, JavaOutlinePage.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                ISelection sel = context.getSelection();
                if (sel instanceof ITextSelection) {
                    ITextSelection tsel = (ITextSelection)sel;
                    int offset = tsel.getOffset();
                    IJavaElement element = JavaOutlinePage.this.fEditor.getElementAt(offset);
                    if (element != null) {
                        JavaOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)element));
                        return true;
                    }
                } else if (sel instanceof IStructuredSelection) {
                    JavaOutlinePage.this.setSelection(sel);
                    return true;
                }
                return false;
            }
        };
    }

    private void initDragAndDrop() {
        this.fDropSupport = new JdtViewerDropSupport((StructuredViewer)this.fOutlineViewer);
        this.fDropSupport.start();
        new JdtViewerDragSupport((StructuredViewer)this.fOutlineViewer).start();
    }

    protected final boolean isTopLevelTypeOnly() {
        return this.fTopLevelTypeOnly;
    }

    protected final JavaOutlineViewer getOutlineViewer() {
        return this.fOutlineViewer;
    }

    protected class ChildrenProvider
    implements ITreeContentProvider {
        private Object[] NO_CLASS = new Object[]{new NoClassElement()};
        private ElementChangedListener fListener;

        protected ChildrenProvider() {
        }

        protected boolean matches(IJavaElement element) {
            if (element.getElementType() == 9) {
                String name = element.getElementName();
                return name != null && name.indexOf(60) >= 0;
            }
            return false;
        }

        protected IJavaElement[] filter(IJavaElement[] children) {
            boolean initializers = false;
            int i = 0;
            while (i < children.length) {
                if (this.matches(children[i])) {
                    initializers = true;
                    break;
                }
                ++i;
            }
            if (!initializers) {
                return children;
            }
            Vector<IJavaElement> v = new Vector<IJavaElement>();
            int i2 = 0;
            while (i2 < children.length) {
                if (!this.matches(children[i2])) {
                    v.addElement(children[i2]);
                }
                ++i2;
            }
            Object[] result = new IJavaElement[v.size()];
            v.copyInto(result);
            return result;
        }

        public Object[] getChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        return this.filter(c.getChildren());
                    }
                    catch (JavaModelException x) {
                        if (!JavaPlugin.isDebug() && x.isDoesNotExist()) break block3;
                        JavaPlugin.log(x);
                    }
                }
            }
            return NO_CHILDREN;
        }

        public Object[] getElements(Object parent) {
            if (JavaOutlinePage.this.fTopLevelTypeOnly && parent instanceof ITypeRoot) {
                try {
                    IType type = ((ITypeRoot)parent).findPrimaryType();
                    return type != null ? type.getChildren() : this.NO_CLASS;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof IJavaElement) {
                IJavaElement e = (IJavaElement)child;
                return e.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        IJavaElement[] children = this.filter(c.getChildren());
                        return children != null && children.length > 0;
                    }
                    catch (JavaModelException x) {
                        if (!JavaPlugin.isDebug() && x.isDoesNotExist()) break block3;
                        JavaPlugin.log(x);
                    }
                }
            }
            return false;
        }

        public void dispose() {
            if (this.fListener != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            boolean isCU = newInput instanceof ICompilationUnit;
            if (isCU && this.fListener == null) {
                this.fListener = new ElementChangedListener();
                JavaCore.addElementChangedListener((IElementChangedListener)this.fListener);
            } else if (!isCU && this.fListener != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }
    }

    class ClassOnlyAction
    extends Action {
        public ClassOnlyAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.go_into_top_level_type_action");
            this.setText(JavaEditorMessages.JavaOutlinePage_GoIntoTopLevelType_label);
            this.setToolTipText(JavaEditorMessages.JavaOutlinePage_GoIntoTopLevelType_tooltip);
            this.setDescription(JavaEditorMessages.JavaOutlinePage_GoIntoTopLevelType_description);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "gointo_toplevel_type.png");
            IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            boolean showclass = preferenceStore.getBoolean("GoIntoTopLevelTypeAction.isChecked");
            this.setTopLevelTypeOnly(showclass);
        }

        public void run() {
            this.setTopLevelTypeOnly(!JavaOutlinePage.this.fTopLevelTypeOnly);
        }

        private void setTopLevelTypeOnly(boolean show) {
            JavaOutlinePage.this.fTopLevelTypeOnly = show;
            this.setChecked(show);
            JavaOutlinePage.this.fOutlineViewer.refresh(false);
            IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue("GoIntoTopLevelTypeAction.isChecked", show);
        }
    }

    protected class ElementChangedListener
    implements IElementChangedListener {
        protected ElementChangedListener() {
        }

        public void elementChanged(final ElementChangedEvent e) {
            if (JavaOutlinePage.this.getControl() == null) {
                return;
            }
            Display d = JavaOutlinePage.this.getControl().getDisplay();
            if (d != null) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ICompilationUnit cu;
                        ICompilationUnit base = cu = (ICompilationUnit)JavaOutlinePage.this.fInput;
                        if (JavaOutlinePage.this.fTopLevelTypeOnly && (base = cu.findPrimaryType()) == null) {
                            if (JavaOutlinePage.this.fOutlineViewer != null) {
                                JavaOutlinePage.this.fOutlineViewer.refresh(true);
                            }
                            return;
                        }
                        IJavaElementDelta delta = ElementChangedListener.this.findElement((IJavaElement)base, e.getDelta());
                        if (delta != null && JavaOutlinePage.this.fOutlineViewer != null) {
                            JavaOutlinePage.this.fOutlineViewer.reconcile(delta);
                        }
                    }
                });
            }
        }

        private boolean isPossibleStructuralChange(IJavaElementDelta cuDelta) {
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }

        protected IJavaElementDelta findElement(IJavaElement unit, IJavaElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IJavaElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 6) {
                return null;
            }
            IJavaElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IJavaElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static final class EmptySelectionProvider
    implements ISelectionProvider {
        private EmptySelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private class FormatElementAction
    extends SelectionDispatchAction {
        FormatElementAction(IPageSite site) {
            super((IWorkbenchSite)site);
        }

        /*
         * Loose catch block
         */
        @Override
        public void run(IStructuredSelection selection) {
            ICompilationUnit compilationUnit = (ICompilationUnit)((IJavaElement)selection.getFirstElement()).getAncestor(5);
            if (ElementValidator.check((IJavaElement)compilationUnit, this.getShell(), JavaEditorMessages.JavaEditor_FormatElementDialog_label, JavaOutlinePage.this.fEditor != null)) {
                JavaSourceViewer javaSourceViewer = (JavaSourceViewer)JavaOutlinePage.this.fEditor.getViewer();
                javaSourceViewer.rememberSelection();
                javaSourceViewer.setRedraw(false);
                try {
                    try {
                        IDocument document = javaSourceViewer.getDocument();
                        IRegion[] regions = this.getOrderedRegionsForNonOverlappingElements(selection, document);
                        HashMap formatterSettings = new HashMap(compilationUnit.getJavaProject().getOptions(true));
                        String content = compilationUnit.getBuffer().getContents();
                        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                        TextEdit edit = CodeFormatterUtil.reformat((int)4104, (String)content, (IRegion[])regions, (int)0, (String)lineDelimiter, formatterSettings);
                        edit.apply(javaSourceViewer.getDocument());
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                        javaSourceViewer.setRedraw(true);
                        javaSourceViewer.restoreSelection();
                    }
                    catch (MalformedTreeException e) {
                        JavaPlugin.log(e);
                        javaSourceViewer.setRedraw(true);
                        javaSourceViewer.restoreSelection();
                    }
                    catch (BadLocationException e) {
                        JavaPlugin.log(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        javaSourceViewer.setRedraw(true);
                        javaSourceViewer.restoreSelection();
                    }
                }
                finally {
                    javaSourceViewer.setRedraw(true);
                    javaSourceViewer.restoreSelection();
                }
            }
        }

        private IRegion[] getOrderedRegionsForNonOverlappingElements(IStructuredSelection selection, IDocument document) {
            List allElements = selection.toList();
            Iterator iterator = selection.iterator();
            ArrayList<Region> regions = new ArrayList<Region>(selection.size());
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (this.isElementOverlapping((IJavaElement)element, allElements)) continue;
                regions.add(this.getElementRegion(element, document));
            }
            Comparator<IRegion> comparator = new Comparator<IRegion>(){

                @Override
                public int compare(IRegion region0, IRegion region1) {
                    int region2Offset;
                    int region1Offset = region0.getOffset();
                    if (region1Offset > (region2Offset = region1.getOffset())) {
                        return 1;
                    }
                    if (region1Offset == region2Offset) {
                        return 0;
                    }
                    return -1;
                }
            };
            Collections.sort(regions, comparator);
            Object[] sortedObjects = regions.toArray();
            Region[] sortedRegions = new Region[sortedObjects.length];
            System.arraycopy(sortedObjects, 0, sortedRegions, 0, sortedObjects.length);
            return sortedRegions;
        }

        private Region getElementRegion(Object element, IDocument document) {
            try {
                ISourceRange sourceRange = ((ISourceReference)element).getSourceRange();
                int sourceOffset = sourceRange.getOffset();
                int beginningOfWSOffset = sourceOffset - 1;
                int lineAtSourceOffset = document.getLineOfOffset(sourceOffset);
                while (beginningOfWSOffset >= 0 && Character.isWhitespace(document.getChar(beginningOfWSOffset)) && lineAtSourceOffset == document.getLineOfOffset(beginningOfWSOffset)) {
                    --beginningOfWSOffset;
                }
                int sourceLength = sourceRange.getLength() + (sourceOffset - ++beginningOfWSOffset);
                if (lineAtSourceOffset != document.getLineOfOffset(beginningOfWSOffset)) {
                    return new Region(document.getLineOffset(lineAtSourceOffset), sourceLength);
                }
                return new Region(beginningOfWSOffset, sourceLength);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            return null;
        }

        private boolean isElementOverlapping(IJavaElement element, List<?> allElements) {
            element = element.getParent();
            while (element != null) {
                if (element instanceof ISourceReference) {
                    if (allElements.contains(element)) {
                        return true;
                    }
                } else {
                    return false;
                }
                element = element.getParent();
            }
            return false;
        }

        @Override
        public void selectionChanged(IStructuredSelection selection) {
            this.setEnabled(JavaOutlinePage.this.fEditor.isEditorInputModifiable());
        }
    }

    protected class JavaOutlineViewer
    extends TreeViewer {
        public JavaOutlineViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
            this.setUseHashlookup(true);
        }

        public void reconcile(IJavaElementDelta delta) {
            this.refresh(true);
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IJavaElement je;
            Item i;
            if (node instanceof Item && (i = (Item)node).getData() instanceof IJavaElement && ((je = (IJavaElement)i.getData()).getElementType() == 12 || JavaOutlinePage.this.isInnerType(je))) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        public boolean isExpandable(Object element) {
            if (this.hasFilters()) {
                return this.getFilteredChildren(element).length > 0;
            }
            return super.isExpandable(element);
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            IResource resource;
            ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
            Object input = this.getInput();
            if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && (e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && input instanceof ICompilationUnit) {
                return;
            }
            Object[] changed = event.getElements();
            if (changed != null && (resource = this.getUnderlyingResource()) != null) {
                int i = 0;
                while (i < changed.length) {
                    if (changed[i] != null && changed[i].equals(resource)) {
                        event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource());
                        break;
                    }
                    ++i;
                }
            }
            super.handleLabelProviderChanged(event);
        }

        private IResource getUnderlyingResource() {
            Object input = this.getInput();
            if (input instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)input;
                cu = cu.getPrimary();
                return cu.getResource();
            }
            if (input instanceof IClassFile) {
                return ((IClassFile)input).getResource();
            }
            return null;
        }
    }

    class LexicalSortingAction
    extends Action {
        private JavaElementComparator fComparator = new JavaElementComparator();
        private SourcePositionComparator fSourcePositonComparator = new SourcePositionComparator();

        public LexicalSortingAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.lexical_sorting_outline_action");
            this.setText(JavaEditorMessages.JavaOutlinePage_Sort_label);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.png");
            this.setToolTipText(JavaEditorMessages.JavaOutlinePage_Sort_tooltip);
            this.setDescription(JavaEditorMessages.JavaOutlinePage_Sort_description);
            boolean checked = JavaPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)JavaOutlinePage.this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (on) {
                        JavaOutlinePage.this.fOutlineViewer.setComparator(LexicalSortingAction.this.fComparator);
                        JavaOutlinePage.this.fDropSupport.setFeedbackEnabled(false);
                    } else {
                        JavaOutlinePage.this.fOutlineViewer.setComparator(LexicalSortingAction.this.fSourcePositonComparator);
                        JavaOutlinePage.this.fDropSupport.setFeedbackEnabled(true);
                    }
                }
            });
            if (store) {
                JavaPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }

    static class NoClassElement
    extends WorkbenchAdapter
    implements IAdaptable {
        NoClassElement() {
        }

        public String toString() {
            return JavaEditorMessages.JavaOutlinePage_error_NoTopLevelType;
        }

        public <T> T getAdapter(Class<T> clas) {
            if (clas == IWorkbenchAdapter.class) {
                return (T)((Object)this);
            }
            return null;
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        public ToggleLinkingAction() {
            boolean isLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.SyncOutlineOnCursorMove");
            this.setChecked(isLinkingEnabled);
            JavaOutlinePage.this.fOpenAndLinkWithEditorHelper.setLinkWithEditor(isLinkingEnabled);
        }

        @Override
        public void run() {
            boolean isChecked = this.isChecked();
            PreferenceConstants.getPreferenceStore().setValue("JavaEditor.SyncOutlineOnCursorMove", isChecked);
            if (isChecked && JavaOutlinePage.this.fEditor != null) {
                JavaOutlinePage.this.fEditor.synchronizeOutlinePage(JavaOutlinePage.this.fEditor.computeHighlightRangeSourceReference(), false);
            }
            JavaOutlinePage.this.fOpenAndLinkWithEditorHelper.setLinkWithEditor(isChecked);
        }
    }
}

