/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.text.spelling.AddWordProposal;
import org.eclipse.jdt.internal.ui.text.spelling.ChangeCaseProposal;
import org.eclipse.jdt.internal.ui.text.spelling.DisableSpellCheckingProposal;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.spelling.WordIgnoreProposal;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;

public class WordQuickFixProcessor
implements IQuickFixProcessor {
    @Override
    public IJavaCompletionProposal[] getCorrections(IInvocationContext invocationContext, IProblemLocation[] locations) throws CoreException {
        int threshold = PreferenceConstants.getPreferenceStore().getInt("spelling_proposal_threshold");
        int size = 0;
        List<RankedWordProposal> proposals = null;
        String[] arguments = null;
        IProblemLocation location = null;
        RankedWordProposal proposal = null;
        IJavaCompletionProposal[] result = null;
        boolean fixed = false;
        boolean match = false;
        boolean sentence = false;
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            int index = 0;
            while (index < locations.length) {
                location = locations[index];
                ISourceViewer sourceViewer = null;
                if (invocationContext instanceof IQuickAssistInvocationContext) {
                    sourceViewer = ((IQuickAssistInvocationContext)invocationContext).getSourceViewer();
                }
                TextInvocationContext context = new TextInvocationContext(sourceViewer, location.getOffset(), location.getLength());
                if (location.getProblemId() == Integer.MIN_VALUE && (arguments = location.getProblemArguments()) != null && arguments.length > 4) {
                    sentence = Boolean.valueOf(arguments[3]);
                    match = Boolean.valueOf(arguments[4]);
                    boolean bl = fixed = arguments[0].charAt(0) == '<' || arguments[0].charAt(0) == '@';
                    if (sentence && match && !fixed) {
                        result = new IJavaCompletionProposal[]{new ChangeCaseProposal(arguments, location.getOffset(), location.getLength(), (IQuickAssistInvocationContext)context, engine.getLocale())};
                        break;
                    }
                    proposals = new ArrayList<RankedWordProposal>(checker.getProposals(arguments[0], sentence));
                    size = proposals.size();
                    if (threshold > 0 && size > threshold) {
                        Collections.sort(proposals);
                        proposals = proposals.subList(size - threshold - 1, size - 1);
                        size = proposals.size();
                    }
                    boolean extendable = !fixed ? checker.acceptsWords() || AddWordProposal.canAskToConfigure() : false;
                    result = new IJavaCompletionProposal[size + (extendable ? 3 : 2)];
                    index = 0;
                    while (index < size) {
                        proposal = proposals.get(index);
                        result[index] = new WordCorrectionProposal(proposal.getText(), arguments, location.getOffset(), location.getLength(), (IQuickAssistInvocationContext)context, proposal.getRank());
                        ++index;
                    }
                    if (extendable) {
                        result[index++] = new AddWordProposal(arguments[0], (IQuickAssistInvocationContext)context);
                    }
                    result[index++] = new WordIgnoreProposal(arguments[0], (IQuickAssistInvocationContext)context);
                    result[index++] = new DisableSpellCheckingProposal((IQuickAssistInvocationContext)context);
                    break;
                }
                ++index;
            }
        }
        return result;
    }

    @Override
    public final boolean hasCorrections(ICompilationUnit unit, int id) {
        return id == Integer.MIN_VALUE;
    }
}

