/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.DebugWorkingCopyManager;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifierJob;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointToggleUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension2 {
    private static final String EMPTY_STRING = "";

    public ToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return type;
    }

    protected IType getType(IJavaElement element) {
        switch (element.getElementType()) {
            case 8: {
                return ((IField)element).getDeclaringType();
            }
            case 9: {
                return ((IMethod)element).getDeclaringType();
            }
            case 7: {
                return (IType)element;
            }
        }
        return null;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, false, null);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, final boolean bestMatch, final ValidBreakpointLocationLocator locator) {
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                return ToggleBreakpointAdapter.this.doLineBreakpointToggle(selection, part, locator, bestMatch, monitor);
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Method Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                block24: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        BreakpointToggleUtils.report(null, part);
                        ISelection selection = finalSelection;
                        if (!(selection instanceof IStructuredSelection)) {
                            selection = ToggleBreakpointAdapter.this.translateToMembers(part, selection);
                        }
                        boolean isInterface = ToggleBreakpointAdapter.this.isInterface(selection, part);
                        if (selection instanceof IStructuredSelection) {
                            IMethod[] members = ToggleBreakpointAdapter.this.getMethods((IStructuredSelection)selection, isInterface);
                            if (members.length == 0) {
                                if (isInterface) {
                                    BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_6, part);
                                } else {
                                    BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_9, part);
                                }
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            IJavaBreakpoint breakpoint = null;
                            ISourceRange range = null;
                            HashMap<String, Object> attributes = null;
                            IType type = null;
                            String signature = null;
                            String mname = null;
                            int i = 0;
                            int length = members.length;
                            while (i < length) {
                                breakpoint = ToggleBreakpointAdapter.this.getMethodBreakpoint((IMember)members[i]);
                                if (breakpoint == null) {
                                    int start = -1;
                                    int end = -1;
                                    range = members[i].getNameRange();
                                    if (range != null) {
                                        start = range.getOffset();
                                        end = start + range.getLength();
                                    }
                                    attributes = new HashMap<String, Object>(10);
                                    BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)members[i]);
                                    type = members[i].getDeclaringType();
                                    signature = members[i].getSignature();
                                    mname = members[i].getElementName();
                                    if (members[i].isConstructor()) {
                                        mname = "<init>";
                                        if (type.isEnum()) {
                                            signature = "(Ljava.lang.String;I" + signature.substring(1);
                                        }
                                    }
                                    if (!type.isBinary() && (signature = ToggleBreakpointAdapter.resolveMethodSignature(members[i])) == null) {
                                        BreakpointToggleUtils.report(ActionMessages.ManageMethodBreakpointActionDelegate_methodNonAvailable, part);
                                        IStatus iStatus = Status.OK_STATUS;
                                        return iStatus;
                                    }
                                    IJavaMethodBreakpoint methodBreakpoint = JDIDebugModel.createMethodBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)members[i]), (String)ToggleBreakpointAdapter.this.getQualifiedName(type), (String)mname, (String)signature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
                                    if (BreakpointToggleUtils.isToggleTracepoints() && finalSelection instanceof ITextSelection && part instanceof CompilationUnitEditor) {
                                        String pattern = ToggleBreakpointAdapter.this.getCodeTemplate((ITextSelection)finalSelection, (CompilationUnitEditor)part);
                                        if (pattern != null) {
                                            pattern.trim();
                                            pattern = pattern.replaceAll("\\\t", ToggleBreakpointAdapter.EMPTY_STRING);
                                            methodBreakpoint.setCondition(pattern);
                                            methodBreakpoint.setConditionEnabled(true);
                                            methodBreakpoint.setConditionSuspendOnTrue(true);
                                        }
                                        BreakpointToggleUtils.setUnsetTracepoints(false);
                                    }
                                } else if (BreakpointToggleUtils.isToggleTracepoints()) {
                                    ToggleBreakpointAdapter.deleteTracepoint(breakpoint, part, monitor);
                                    BreakpointToggleUtils.setUnsetTracepoints(false);
                                } else {
                                    ToggleBreakpointAdapter.deleteBreakpoint(breakpoint, part, monitor);
                                }
                                ++i;
                            }
                            break block24;
                        }
                        BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_4, part);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        return iStatus;
                    }
                    finally {
                        BreakpointToggleUtils.setUnsetTracepoints(false);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    IStatus doLineBreakpointToggle(ISelection selection, IWorkbenchPart part, ValidBreakpointLocationLocator locator, boolean bestMatch, IProgressMonitor monitor) {
        block25: {
            ITextEditor editor = this.getTextEditor(part);
            if (editor != null && selection instanceof ITextSelection) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ITextSelection tsel = (ITextSelection)selection;
                if (tsel.getStartLine() < 0) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    BreakpointToggleUtils.report(null, part);
                    ISelection sel = selection;
                    if (!(selection instanceof IStructuredSelection)) {
                        sel = this.translateToMembers(part, selection);
                    }
                    if (sel instanceof IStructuredSelection) {
                        int lnumber;
                        IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
                        IType type = null;
                        type = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
                        if (locator == null && BreakpointToggleUtils.isToggleTracepoints()) {
                            CompilationUnit cUnit = this.parseCompilationUnit(type.getTypeRoot());
                            locator = new ValidBreakpointLocationLocator(cUnit, tsel.getStartLine() + 1, true, bestMatch);
                            cUnit.accept((ASTVisitor)locator);
                        }
                        String tname = null;
                        IJavaProject project = type.getJavaProject();
                        tname = locator == null || project != null && !project.isOnClasspath((IJavaElement)type) ? this.createQualifiedTypeName(type) : locator.getFullyQualifiedTypeName();
                        if (tname == null) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        IResource resource = BreakpointUtils.getBreakpointResource((IMember)type);
                        IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)tname, (int)(lnumber = locator == null ? tsel.getStartLine() + 1 : locator.getLineLocation()));
                        if (existingBreakpoint != null) {
                            if (BreakpointToggleUtils.isToggleTracepoints()) {
                                ToggleBreakpointAdapter.deleteTracepoint((IJavaBreakpoint)existingBreakpoint, (IWorkbenchPart)editor, monitor);
                                BreakpointToggleUtils.setUnsetTracepoints(false);
                            } else {
                                ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)existingBreakpoint, (IWorkbenchPart)editor, monitor);
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
                        IDocumentProvider documentProvider = editor.getDocumentProvider();
                        if (documentProvider == null) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                        int charstart = -1;
                        int charend = -1;
                        try {
                            IRegion line = document.getLineInformation(lnumber - 1);
                            charstart = line.getOffset();
                            charend = charstart + line.getLength();
                        }
                        catch (BadLocationException ble) {
                            JDIDebugUIPlugin.log(ble);
                        }
                        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)type);
                        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)tname, (int)lnumber, (int)charstart, (int)charend, (int)0, (boolean)true, attributes);
                        if (BreakpointToggleUtils.isToggleTracepoints() && selection instanceof ITextSelection && part instanceof CompilationUnitEditor) {
                            String pattern = this.getCodeTemplate((ITextSelection)selection, (CompilationUnitEditor)part);
                            if (pattern != null) {
                                pattern.trim();
                                pattern = pattern.replaceAll("\\\t", EMPTY_STRING);
                                breakpoint.setCondition(pattern);
                                breakpoint.setConditionEnabled(true);
                                breakpoint.setConditionSuspendOnTrue(true);
                            }
                            BreakpointToggleUtils.setUnsetTracepoints(false);
                        }
                        if (locator == null) {
                            new BreakpointLocationVerifierJob(document, this.parseCompilationUnit(type.getTypeRoot()), breakpoint, lnumber, tname, type, (IEditorPart)editor, bestMatch).schedule();
                        }
                        if (BreakpointToggleUtils.isToggleTracepoints()) {
                            BreakpointToggleUtils.setUnsetTracepoints(false);
                        }
                        break block25;
                    }
                    BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_3, part);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CoreException ce) {
                    IStatus iStatus = ce.getStatus();
                    return iStatus;
                }
                finally {
                    BreakpointToggleUtils.setUnsetTracepoints(false);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public void toggleClassBreakpoints(final IWorkbenchPart part, final ISelection selection) {
        Job job = new Job("Toggle Class Load Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    int end;
                    int start;
                    HashMap<String, Object> map;
                    IType type;
                    IMember member;
                    BreakpointToggleUtils.report(null, part);
                    ISelection sel = selection;
                    if (!(selection instanceof IStructuredSelection)) {
                        sel = ToggleBreakpointAdapter.this.translateToMembers(part, selection);
                    }
                    if (ToggleBreakpointAdapter.this.isInterface(sel, part)) {
                        BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_1, part);
                        return Status.OK_STATUS;
                    }
                    if (sel instanceof IStructuredSelection) {
                        member = (IMember)((IStructuredSelection)sel).getFirstElement();
                        type = (IType)member;
                        IJavaBreakpoint existing = ToggleBreakpointAdapter.this.getClassLoadBreakpoint(type);
                        if (existing != null) {
                            ToggleBreakpointAdapter.deleteBreakpoint(existing, part, monitor);
                            return Status.OK_STATUS;
                        }
                        map = new HashMap<String, Object>(10);
                        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)type);
                        ISourceRange range = type.getNameRange();
                        start = -1;
                        end = -1;
                        if (range != null) {
                            start = range.getOffset();
                            end = start + range.getLength();
                        }
                    } else {
                        BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_0, part);
                        return Status.OK_STATUS;
                    }
                    JDIDebugModel.createClassPrepareBreakpoint((IResource)BreakpointUtils.getBreakpointResource(member), (String)ToggleBreakpointAdapter.this.getQualifiedName(type), (int)0, (int)start, (int)end, (boolean)true, map);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    protected IJavaBreakpoint getClassLoadBreakpoint(IType type) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaBreakpoint breakpoint = (IJavaBreakpoint)breakpoints[i];
            if (breakpoint instanceof IJavaClassPrepareBreakpoint && this.getQualifiedName(type).equals(breakpoint.getTypeName())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    String getQualifiedName(IType type) throws JavaModelException {
        IJavaProject project = type.getJavaProject();
        if (project != null && project.isOnClasspath((IJavaElement)type) && this.needsBindings(type)) {
            String name;
            Object binding;
            ASTNode node;
            CompilationUnit cuNode = this.parseCompilationUnit(type.getTypeRoot());
            ISourceRange nameRange = type.getNameRange();
            if (SourceRange.isAvailable((ISourceRange)nameRange) && (node = NodeFinder.perform((ASTNode)cuNode, (ISourceRange)nameRange)) instanceof SimpleName && (binding = node.getLocationInParent() == SimpleType.NAME_PROPERTY && node.getParent().getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY ? ((ClassInstanceCreation)node.getParent().getParent()).resolveTypeBinding() : ((SimpleName)node).resolveBinding()) instanceof ITypeBinding && (name = ((ITypeBinding)binding).getBinaryName()) != null) {
                return name;
            }
        }
        return this.createQualifiedTypeName(type);
    }

    boolean needsBindings(IType type) throws JavaModelException {
        if (type.isMember()) {
            if (type.isLocal() && !type.isAnonymous()) {
                return true;
            }
            IJavaElement parent = type.getParent();
            IType ptype = null;
            while (parent != null) {
                if (parent.getElementType() == 7 && (ptype = (IType)parent).isLocal() && !ptype.isAnonymous()) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    String createQualifiedTypeName(IType type) {
        String tname = this.pruneAnonymous(type);
        try {
            String packName = null;
            if (type.isBinary()) {
                packName = type.getPackageFragment().getElementName();
            } else {
                IPackageDeclaration[] pd = type.getCompilationUnit().getPackageDeclarations();
                if (pd.length > 0) {
                    packName = pd[0].getElementName();
                }
            }
            if (packName != null && !packName.equals(EMPTY_STRING)) {
                tname = String.valueOf(packName) + "." + tname;
            }
        }
        catch (JavaModelException javaModelException) {}
        return tname;
    }

    private String pruneAnonymous(IType type) {
        StringBuffer buffer = new StringBuffer();
        IType parent = type;
        while (parent != null) {
            if (parent.getElementType() == 7) {
                IType atype = parent;
                try {
                    if (!atype.isAnonymous()) {
                        if (buffer.length() > 0) {
                            buffer.insert(0, '$');
                        }
                        buffer.insert(0, atype.getElementName());
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            parent = parent.getParent();
        }
        return buffer.toString();
    }

    private IJavaElement getJavaElement(IEditorInput input) {
        IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return DebugWorkingCopyManager.getWorkingCopy(input, false);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.getMethods(ss, this.isInterface(selection, part)).length > 0;
        }
        return selection instanceof ITextSelection && this.isMethod((ITextSelection)selection, part);
    }

    protected boolean isRemote(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IMember) {
            IMember member = (IMember)element;
            return !member.getJavaProject().getProject().exists();
        }
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            Object adapter = Platform.getAdapterManager().getAdapter((Object)input, "org.eclipse.team.core.history.IFileRevision");
            return adapter != null;
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    protected IMethod[] getMethods(IStructuredSelection selection, boolean isInterace) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(selection.size());
        for (Object thing : selection) {
            try {
                if (!(thing instanceof IMethod)) continue;
                IMethod method = (IMethod)thing;
                if (isInterace) {
                    if (!Flags.isDefaultMethod((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags())) continue;
                    methods.add(method);
                    continue;
                }
                if (Flags.isAbstract((int)method.getFlags())) continue;
                methods.add(method);
            }
            catch (JavaModelException javaModelException) {}
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected IMethod[] getInterfaceMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(selection.size());
        for (Object thing : selection) {
            try {
                IMethod method;
                if (!(thing instanceof IMethod) || !Flags.isDefaultMethod((int)(method = (IMethod)thing).getFlags())) continue;
                methods.add(method);
            }
            catch (JavaModelException javaModelException) {}
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    private boolean isMethod(ITextSelection selection, IWorkbenchPart part) {
        IJavaElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof ICompilationUnit) {
                    element = ((ICompilationUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                if (element != null && element.getElementType() == 9) {
                    IMethod method = (IMethod)element;
                    return !method.getDeclaringType().isAnonymous();
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    protected List<Object> getFields(IStructuredSelection selection) throws CoreException {
        if (selection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> fields = new ArrayList<Object>(selection.size());
        for (Object thing : selection) {
            if (thing instanceof IField) {
                fields.add(thing);
                continue;
            }
            if (!(thing instanceof IJavaFieldVariable)) continue;
            IField field = this.getField((IJavaFieldVariable)thing);
            if (field == null) {
                fields.add(thing);
                continue;
            }
            fields.add(field);
        }
        return fields;
    }

    private boolean isInterface(ISelection selection, IWorkbenchPart part) {
        try {
            ISelection sel = selection;
            if (!(sel instanceof IStructuredSelection)) {
                sel = this.translateToMembers(part, selection);
            }
            if (sel instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)sel).getFirstElement();
                if (obj instanceof IMember) {
                    IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
                    if (member.getElementType() == 7) {
                        return ((IType)member).isInterface();
                    }
                    return member.getDeclaringType().isInterface();
                }
                if (obj instanceof IJavaFieldVariable) {
                    IJavaFieldVariable var = (IJavaFieldVariable)obj;
                    IType type = JavaDebugUtils.resolveType((IJavaType)var.getDeclaringType());
                    return type != null && type.isInterface();
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean isField(ITextSelection selection, IWorkbenchPart part) {
        IJavaElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof ICompilationUnit) {
                    element = ((ICompilationUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                return element != null && element.getElementType() == 8;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private boolean isFields(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            try {
                for (Object thing : selection) {
                    if (thing instanceof IField) {
                        int flags = ((IField)thing).getFlags();
                        return !Flags.isFinal((int)flags) & !(Flags.isFinal((int)flags) & Flags.isStatic((int)flags));
                    }
                    if (!(thing instanceof IJavaFieldVariable)) continue;
                    IJavaFieldVariable fv = (IJavaFieldVariable)thing;
                    return !fv.isFinal() & !(fv.isFinal() & fv.isStatic());
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            catch (DebugException debugException) {
                return false;
            }
        }
        return false;
    }

    public void toggleWatchpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Watchpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                block18: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        BreakpointToggleUtils.report(null, part);
                        ISelection selection = finalSelection;
                        if (!(selection instanceof IStructuredSelection)) {
                            selection = ToggleBreakpointAdapter.this.translateToMembers(part, finalSelection);
                        }
                        if (ToggleBreakpointAdapter.this.isInterface(selection, part)) {
                            BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_5, part);
                            return Status.OK_STATUS;
                        }
                        boolean allowed = false;
                        if (selection instanceof IStructuredSelection) {
                            List<Object> fields = ToggleBreakpointAdapter.this.getFields((IStructuredSelection)selection);
                            if (fields.isEmpty()) {
                                BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_10, part);
                                return Status.OK_STATUS;
                            }
                            Iterator<Object> theFields = fields.iterator();
                            IField javaField = null;
                            IWorkspaceRoot resource = null;
                            String typeName = null;
                            String fieldName = null;
                            Object element = null;
                            HashMap<String, Object> attributes = null;
                            IJavaWatchpoint breakpoint = null;
                            while (theFields.hasNext()) {
                                element = theFields.next();
                                if (element instanceof IField) {
                                    javaField = (IField)element;
                                    IType type = javaField.getDeclaringType();
                                    typeName = ToggleBreakpointAdapter.this.getQualifiedName(type);
                                    fieldName = javaField.getElementName();
                                    int f = javaField.getFlags();
                                    boolean fin = Flags.isFinal((int)f);
                                    if (fin) {
                                        fin = javaField.getConstant() != null;
                                    }
                                    allowed = !fin & !(Flags.isStatic((int)f) & fin);
                                } else if (element instanceof IJavaFieldVariable) {
                                    IJavaFieldVariable var = (IJavaFieldVariable)element;
                                    typeName = var.getDeclaringType().getName();
                                    fieldName = var.getName();
                                    boolean fin = var.isFinal();
                                    if (fin) {
                                        fin = javaField.getConstant() != null;
                                    }
                                    allowed = !fin & !(var.isStatic() & fin);
                                }
                                breakpoint = ToggleBreakpointAdapter.this.getWatchpoint(typeName, fieldName);
                                if (breakpoint == null) {
                                    if (!allowed) {
                                        return ToggleBreakpointAdapter.this.doLineBreakpointToggle(finalSelection, part, null, true, monitor);
                                    }
                                    int start = -1;
                                    int end = -1;
                                    attributes = new HashMap<String, Object>(10);
                                    if (javaField == null) {
                                        resource = ResourcesPlugin.getWorkspace().getRoot();
                                    } else {
                                        IType type = javaField.getDeclaringType();
                                        ISourceRange range = javaField.getNameRange();
                                        if (range != null) {
                                            start = range.getOffset();
                                            end = start + range.getLength();
                                        }
                                        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)javaField);
                                        resource = BreakpointUtils.getBreakpointResource((IMember)type);
                                    }
                                    JDIDebugModel.createWatchpoint((IResource)resource, (String)typeName, (String)fieldName, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
                                    continue;
                                }
                                ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)breakpoint, part, monitor);
                            }
                            break block18;
                        }
                        BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_2, part);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    private IJavaWatchpoint getWatchpoint(String typeName, String fieldName) throws CoreException {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaWatchpoint watchpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaWatchpoint && typeName.equals((watchpoint = (IJavaWatchpoint)breakpoint).getTypeName()) && fieldName.equals(watchpoint.getFieldName())) {
                return watchpoint;
            }
            ++i;
        }
        return null;
    }

    public static String resolveMethodSignature(IMethod method) throws JavaModelException {
        String signature = method.getSignature();
        String[] parameterTypes = Signature.getParameterTypes((String)signature);
        int length = parameterTypes.length;
        String[] resolvedParameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            resolvedParameterTypes[i] = ToggleBreakpointAdapter.resolveTypeSignature(method, parameterTypes[i]);
            if (resolvedParameterTypes[i] == null) {
                return null;
            }
            ++i;
        }
        String resolvedReturnType = ToggleBreakpointAdapter.resolveTypeSignature(method, Signature.getReturnType((String)signature));
        if (resolvedReturnType == null) {
            return null;
        }
        return Signature.createMethodSignature((String[])resolvedParameterTypes, (String)resolvedReturnType);
    }

    private static String resolveTypeSignature(IMethod method, String typeSignature) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeSignature);
        String elementTypeSignature = Signature.getElementType((String)typeSignature);
        if (elementTypeSignature.length() == 1) {
            return typeSignature;
        }
        String elementTypeName = Signature.toString((String)elementTypeSignature);
        IType type = method.getDeclaringType();
        String[][] resolvedElementTypeNames = type.resolveType(elementTypeName);
        if (resolvedElementTypeNames == null || resolvedElementTypeNames.length != 1) {
            ITypeParameter typeParameter = method.getTypeParameter(elementTypeName);
            if (!typeParameter.exists()) {
                typeParameter = type.getTypeParameter(elementTypeName);
            }
            if (typeParameter.exists()) {
                String[] bounds = typeParameter.getBounds();
                if (bounds.length == 0) {
                    return "Ljava/lang/Object;";
                }
                String bound = Signature.createTypeSignature((String)bounds[0], (boolean)false);
                return Signature.createArraySignature((String)ToggleBreakpointAdapter.resolveTypeSignature(method, bound), (int)count);
            }
            return null;
        }
        String[] types = resolvedElementTypeNames[0];
        types[1] = types[1].replace('.', '$');
        String resolvedElementTypeName = Signature.toQualifiedName((String[])types);
        String resolvedElementTypeSignature = EMPTY_STRING;
        if (types[0].equals(EMPTY_STRING)) {
            resolvedElementTypeName = resolvedElementTypeName.substring(1);
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true);
        } else {
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true).replace('.', '/');
        }
        return Signature.createArraySignature((String)resolvedElementTypeSignature, (int)count);
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = (IResource)editorInput.getAdapter(IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    protected IMethod getMethodHandle(IEditorPart editorPart, String typeName, String methodName, String signature) throws CoreException {
        IJavaElement element = (IJavaElement)editorPart.getEditorInput().getAdapter(IJavaElement.class);
        IType type = null;
        if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i].getFullyQualifiedName().equals(typeName)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        }
        if (type != null) {
            String[] sigs = Signature.getParameterTypes((String)signature);
            return type.getMethod(methodName, sigs);
        }
        return null;
    }

    protected IJavaBreakpoint getMethodBreakpoint(IMember element) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaMethodBreakpoint) {
                    IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                    IMember container = null;
                    try {
                        container = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                        return null;
                    }
                    if (container == null) {
                        try {
                            if (method.getDeclaringType().getFullyQualifiedName().equals(methodBreakpoint.getTypeName()) && method.getElementName().equals(methodBreakpoint.getMethodName()) && methodBreakpoint.getMethodSignature().equals(ToggleBreakpointAdapter.resolveMethodSignature(method))) {
                                return methodBreakpoint;
                            }
                        }
                        catch (CoreException e) {
                            JDIDebugUIPlugin.log(e);
                        }
                    } else if (container instanceof IMethod && method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) && method.isSimilar((IMethod)container)) {
                        return methodBreakpoint;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected CompilationUnit parseCompilationUnit(ITextEditor editor) {
        return this.parseCompilationUnit(this.getTypeRoot(editor.getEditorInput()));
    }

    CompilationUnit parseCompilationUnit(ITypeRoot root) {
        if (root != null) {
            return SharedASTProvider.getAST((ITypeRoot)root, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        }
        return null;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.isFields(ss);
        }
        return selection instanceof ITextSelection && this.isField((ITextSelection)selection, part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null && selection instanceof ITextSelection) {
            IJavaElement e;
            ITextSelection textSelection = (ITextSelection)selection;
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            int offset = textSelection.getOffset();
            if (document != null) {
                try {
                    IRegion region = document.getLineInformationOfOffset(offset);
                    int end = region.getOffset() + region.getLength();
                    while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                        ++offset;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            IMember m = null;
            ITypeRoot root = this.getTypeRoot(editorInput);
            if (root instanceof ICompilationUnit) {
                ICompilationUnit unit;
                ICompilationUnit iCompilationUnit = unit = (ICompilationUnit)root;
                synchronized (iCompilationUnit) {
                    unit.reconcile(0, false, null, null);
                }
            }
            if (root != null && (e = root.getElementAt(offset)) instanceof IMember) {
                m = (IMember)e;
            }
            if (m != null) {
                return new StructuredSelection(m);
            }
        }
        return selection;
    }

    private ITypeRoot getTypeRoot(IEditorInput input) {
        ITypeRoot root = (ITypeRoot)input.getAdapter(IClassFile.class);
        if (root == null) {
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            root = manager.getWorkingCopy(input);
        }
        if (root == null) {
            root = DebugWorkingCopyManager.getWorkingCopy(input, false);
        }
        return root;
    }

    private IField getField(IJavaFieldVariable variable) throws CoreException {
        IField field;
        String varName = null;
        try {
            varName = variable.getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        IJavaType declaringType = variable.getDeclaringType();
        IType type = JavaDebugUtils.resolveType((IJavaType)declaringType);
        if (type != null && (field = type.getField(varName)).exists()) {
            return field;
        }
        return null;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ISelection sel = this.translateToMembers(part, selection);
        if (sel instanceof IStructuredSelection) {
            IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
            int mtype = member.getElementType();
            if (mtype == 8 || mtype == 9 || mtype == 10) {
                if (selection instanceof ITextSelection) {
                    ITextSelection ts = (ITextSelection)selection;
                    IJavaLineBreakpoint breakpoint = null;
                    ITextEditor editor = this.getTextEditor(part);
                    IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
                    IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    if (annotationModel != null) {
                        Iterator iterator = annotationModel.getAnnotationIterator();
                        while (iterator.hasNext()) {
                            Object object = iterator.next();
                            if (!(object instanceof SimpleMarkerAnnotation)) continue;
                            SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                            IMarker marker = markerAnnotation.getMarker();
                            try {
                                IBreakpoint oldBreakpoint;
                                Position position;
                                int line;
                                if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != ts.getStartLine() || !((oldBreakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) instanceof IJavaLineBreakpoint)) continue;
                                breakpoint = (IJavaLineBreakpoint)oldBreakpoint;
                                break;
                            }
                            catch (BadLocationException e) {
                                JDIDebugUIPlugin.log(e);
                            }
                        }
                    }
                    if (breakpoint != null) {
                        if (BreakpointToggleUtils.isToggleTracepoints()) {
                            ToggleBreakpointAdapter.deleteTracepoint(breakpoint, part, null);
                            BreakpointToggleUtils.setUnsetTracepoints(false);
                        } else {
                            ToggleBreakpointAdapter.deleteBreakpoint(breakpoint, part, null);
                        }
                        return;
                    }
                    CompilationUnit unit = this.parseCompilationUnit(this.getTextEditor(part));
                    ValidBreakpointLocationLocator loc = new ValidBreakpointLocationLocator(unit, ts.getStartLine() + 1, true, true);
                    unit.accept((ASTVisitor)loc);
                    if (loc.getLocationType() == 2) {
                        this.toggleMethodBreakpoints(part, (ISelection)ts);
                    } else if (loc.getLocationType() == 3) {
                        if (BreakpointToggleUtils.isToggleTracepoints()) {
                            BreakpointToggleUtils.report(ActionMessages.TracepointToggleAction_Unavailable, part);
                            BreakpointToggleUtils.setUnsetTracepoints(false);
                            return;
                        }
                        this.toggleWatchpoints(part, (ISelection)ts);
                    } else if (loc.getLocationType() == 1) {
                        this.toggleLineBreakpoints(part, (ISelection)ts, false, loc);
                    }
                }
            } else if (member.getElementType() == 7) {
                if (BreakpointToggleUtils.isToggleTracepoints()) {
                    BreakpointToggleUtils.report(ActionMessages.TracepointToggleAction_Unavailable, part);
                    BreakpointToggleUtils.setUnsetTracepoints(false);
                    return;
                }
                this.toggleClassBreakpoints(part, sel);
            } else {
                this.toggleLineBreakpoints(part, selection, true, null);
            }
        }
    }

    private static void deleteBreakpoint(IJavaBreakpoint breakpoint, IWorkbenchPart part, IProgressMonitor monitor) throws CoreException {
        final Shell shell = part != null ? part.getSite().getShell() : null;
        final boolean[] result = new boolean[]{true};
        final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugUIPlugin.getUniqueIdentifier());
        boolean prompt = prefs.getBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, true);
        if (prompt && breakpoint instanceof IJavaLineBreakpoint && ((IJavaLineBreakpoint)breakpoint).getCondition() != null) {
            Display display;
            Display display2 = display = shell != null && !shell.isDisposed() ? shell.getDisplay() : PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteTitle, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteMessage, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteShowAgain, (boolean)false, null, null);
                        if (dialog.getToggleState()) {
                            prefs.putBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, false);
                        }
                        result[0] = dialog.getReturnCode() == 0;
                    }
                });
            }
        }
        if (result[0]) {
            DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)shell, (IProgressMonitor)monitor);
        }
    }

    private static void deleteTracepoint(IJavaBreakpoint breakpoint, IWorkbenchPart part, IProgressMonitor monitor) throws CoreException {
        final Shell shell = part != null ? part.getSite().getShell() : null;
        final boolean[] result = new boolean[]{true};
        final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugUIPlugin.getUniqueIdentifier());
        boolean prompt = prefs.getBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, true);
        if (prompt && breakpoint instanceof IJavaLineBreakpoint) {
            String condition = ((IJavaLineBreakpoint)breakpoint).getCondition();
            boolean conditionChanged = true;
            if (condition != null) {
                int index = condition.indexOf(";");
                if (index != -1) {
                    int lastIndex = condition.lastIndexOf(";");
                    if (index == lastIndex) {
                        conditionChanged = false;
                    }
                } else if (condition.indexOf("print") != -1) {
                    conditionChanged = false;
                }
            }
            if (conditionChanged && condition != null) {
                Display display;
                Display display2 = display = shell != null && !shell.isDisposed() ? shell.getDisplay() : PlatformUI.getWorkbench().getDisplay();
                if (!display.isDisposed()) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteTitle, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteMessage, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteShowAgain, (boolean)false, null, null);
                            if (dialog.getToggleState()) {
                                prefs.putBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, false);
                            }
                            result[0] = dialog.getReturnCode() == 0;
                        }
                    });
                }
            }
        }
        if (result[0]) {
            DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)shell, (IProgressMonitor)monitor);
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void toggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) throws CoreException {
        if (event != null) {
            IBreakpoint bp;
            IVerticalRulerInfo info;
            ITextEditor editor;
            if ((event.stateMask & SWT.MOD2) > 0) {
                IBreakpoint bp2;
                IVerticalRulerInfo info2;
                ITextEditor editor2 = this.getTextEditor(part);
                if (editor2 != null && (info2 = (IVerticalRulerInfo)editor2.getAdapter(IVerticalRulerInfo.class)) != null && (bp2 = BreakpointUtils.getBreakpointFromEditor(editor2, info2)) != null) {
                    bp2.setEnabled(!bp2.isEnabled());
                    return;
                }
            } else if ((event.stateMask & SWT.MOD1) > 0 && (editor = this.getTextEditor(part)) != null && (info = (IVerticalRulerInfo)editor.getAdapter(IVerticalRulerInfo.class)) != null && (bp = BreakpointUtils.getBreakpointFromEditor(editor, info)) != null) {
                PreferencesUtil.createPropertyDialogOn((Shell)editor.getSite().getShell(), (IAdaptable)bp, null, null, null).open();
                return;
            }
        }
        this.toggleBreakpoints(part, selection);
    }

    public boolean canToggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) {
        return this.canToggleBreakpoints(part, selection);
    }

    private String getCodeTemplate(final ITextSelection textSelection, final CompilationUnitEditor part) {
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java-statements");
        TemplateEngine fStatementEngine = new TemplateEngine(contextType);
        fStatementEngine.reset();
        ISourceViewer viewer = part.getViewer();
        String[] fTemplateBuffer = new String[]{null};
        if (viewer != null) {
            Display.getDefault().syncExec(new Runnable((ITextViewer)viewer, fStatementEngine, fTemplateBuffer){
                private final /* synthetic */ ITextViewer val$viewer;
                private final /* synthetic */ TemplateEngine val$fStatementEngine;
                private final /* synthetic */ String[] val$fTemplateBuffer;
                {
                    this.val$viewer = iTextViewer;
                    this.val$fStatementEngine = templateEngine;
                    this.val$fTemplateBuffer = stringArray;
                }

                @Override
                public void run() {
                    ITextEditor editor = ToggleBreakpointAdapter.this.getTextEditor((IWorkbenchPart)part);
                    if (editor != null) {
                        IJavaElement element = ToggleBreakpointAdapter.this.getJavaElement(editor.getEditorInput());
                        ICompilationUnit cunit = null;
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IFile file = root.getFile(element.getPath());
                        cunit = JavaCore.createCompilationUnitFrom((IFile)file);
                        IDocumentProvider documentProvider = editor.getDocumentProvider();
                        if (documentProvider == null) {
                            return;
                        }
                        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                        try {
                            TemplateProposal[] templateProposals;
                            IRegion line = document.getLineInformation(textSelection.getStartLine() + 1);
                            Point selectedRange = this.val$viewer.getSelectedRange();
                            this.val$viewer.setSelectedRange(selectedRange.x, 0);
                            this.val$fStatementEngine.complete(this.val$viewer, line.getOffset(), cunit);
                            this.val$viewer.setSelectedRange(selectedRange.x, selectedRange.y);
                            TemplateProposal[] templateProposalArray = templateProposals = this.val$fStatementEngine.getResults();
                            int n = templateProposals.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TemplateProposal templateProposal = templateProposalArray[n2];
                                Template template = templateProposal.getTemplate();
                                if (template.getName().equals("systrace")) {
                                    CompilationUnitContextType contextType = (CompilationUnitContextType)JavaPlugin.getDefault().getTemplateContextRegistry().getContextType(template.getContextTypeId());
                                    CompilationUnitContext context = contextType.createContext(document, line.getOffset(), 0, cunit);
                                    context.setVariable("selection", ToggleBreakpointAdapter.EMPTY_STRING);
                                    context.setForceEvaluation(true);
                                    this.val$fTemplateBuffer[0] = context.evaluate(template).getString();
                                    return;
                                }
                                ++n2;
                            }
                        }
                        catch (BadLocationException | TemplateException throwable) {}
                    }
                }
            });
        }
        return fTemplateBuffer[0];
    }
}

