/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.internal.core.WorkspaceMonitor;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.IQ7Launch;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;

public class Q7LaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements IQ7Launch {
    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Validating RCPTT tests and contexts...", 2);
        try {
            IQ7NamedElement[] tests;
            IQ7NamedElement[] iQ7NamedElementArray = tests = this.getTests(configuration, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement t = iQ7NamedElementArray[n2];
                if (t instanceof ITestCase) {
                    try {
                        ((ITestCase)t).getID();
                    }
                    catch (Exception e) {
                        throw new CoreException(Q7LaunchingPlugin.createStatus(String.format("The '%s' test is totally broken.", t.getName()), e));
                    }
                }
                if (t instanceof IContext) {
                    try {
                        ((IContext)t).getID();
                    }
                    catch (Exception e) {
                        throw new CoreException(Q7LaunchingPlugin.createStatus(String.format("The '%s' context is totally broken.", t.getName()), e));
                    }
                }
                if (t instanceof IVerification) {
                    try {
                        ((IVerification)t).getID();
                    }
                    catch (Exception e) {
                        throw new CoreException(Q7LaunchingPlugin.createStatus(String.format("The '%s' verification is totally broken.", t.getName()), e));
                    }
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        if (Q7LaunchConfigurationDelegate.getAut(configuration) == null) {
            AutLaunch aut = TestSuiteUtils.SelectAUT();
            if (aut == null) {
                return false;
            }
            ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
            copy.setAttribute("org.eclipse.rcptt.launching.AUT_NAME_ATTR", aut.getAut().getName());
            copy.doSave();
        }
        return true;
    }

    private static Aut getAut(ILaunchConfiguration configuration) {
        try {
            String autName = configuration.getAttribute("org.eclipse.rcptt.launching.AUT_NAME_ATTR", "");
            autName = configuration.getAttribute("org.eclipse.rcptt.launching.BOUND_AUT_NAME_ATTR", autName);
            return AutManager.INSTANCE.getByName(autName);
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log(e);
            return null;
        }
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new Q7TestLaunch(configuration, mode);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launching RCPTT tests...", 3);
        this.waitForSave((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        AutLaunch autLaunch = this.getAutLaunch(config, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        IQ7NamedElement[] elements = this.getTests(config, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        Q7Launcher.LaunchData data = Q7Launcher.getInstance().getRemoveLaunchData(config);
        if (data != null && (elements == null || elements.length == 0)) {
            elements = data.elements;
        }
        if (elements.length == 0) {
            throw new CoreException(Q7LaunchingPlugin.createStatus("No scenarios found in the '" + config.getName() + "' launch configuration "));
        }
        Map variants = config.getAttribute("q7.context.variants", new HashMap());
        HashMap<IQ7NamedElement, List<List<String>>> namedVariants = new HashMap<IQ7NamedElement, List<List<String>>>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ImmutableList rawValues;
            IQ7NamedElement namedElement = iQ7NamedElementArray[n2];
            String var = (String)variants.get(namedElement.getID());
            if (var != null && (rawValues = ImmutableList.copyOf((Iterable)Splitter.on((String)"%$%${q7.variants}").split((CharSequence)var))) != null) {
                ArrayList<ImmutableList> values = new ArrayList<ImmutableList>();
                for (String rawValue : rawValues) {
                    values.add(ImmutableList.copyOf((Iterable)Splitter.on((String)"%$%${q7.variantname}").omitEmptyStrings().split((CharSequence)rawValue)));
                }
                namedVariants.put(namedElement, values);
            }
            ++n2;
        }
        Q7Launcher.setMappedResources(config, elements);
        IWorkspaceFinder finder = data == null ? null : data.finder;
        this.launch(elements, (Q7TestLaunch)launch, autLaunch, finder, namedVariants);
        monitor.done();
    }

    private void waitForSave(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join(WorkspaceMonitor.SAVE_JOB_FAMILY, monitor);
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log(e);
        }
    }

    private AutLaunch getAutLaunch(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        Aut aut = Q7LaunchConfigurationDelegate.getAut(config);
        if (aut == null) {
            throw new CoreException(Q7LaunchingPlugin.createStatus("AUT is not specified in the '" + config.getName() + "' launch configuration "));
        }
        AutLaunch launch = aut.getActiveLaunch();
        if (launch == null) {
            launch = aut.launch(monitor);
        }
        ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
        copy.setAttribute("org.eclipse.rcptt.launching.AUT_NAME_ATTR", "");
        copy.doSave();
        return launch;
    }

    private IQ7NamedElement[] getTests(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Collecting tests...", 1);
        IQ7NamedElement[] elements = TestSuiteUtils.getElements(config);
        monitor.worked(1);
        monitor.done();
        return elements;
    }

    private void launch(IQ7NamedElement[] elements, Q7TestLaunch launch, AutLaunch aut, IWorkspaceFinder finder, Map<IQ7NamedElement, List<List<String>>> namedVariants) throws CoreException {
        Q7LaunchManager.getInstance().execute(elements, aut, launch, finder, namedVariants);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }
}

