/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class EclContentAssistAction
extends TextEditorAction {
    private ITextOperationTarget fOperationTarget;
    private EclEditor eclEditor;

    public EclContentAssistAction(ResourceBundle bundle, String prefix, EclEditor editor) {
        super(bundle, prefix, (ITextEditor)editor);
        this.eclEditor = editor;
    }

    public void run() {
        ITextEditor editor;
        boolean editorsActive;
        boolean bl = editorsActive = !this.eclEditor.viewer.getControl().isFocusControl() && (this.eclEditor.header.isInFocus() || this.eclEditor.editorContent.isInFocus());
        if (editorsActive) {
            return;
        }
        if (this.fOperationTarget != null && (editor = this.getTextEditor()) != null && this.validateEditorInputState()) {
            Display display = null;
            IWorkbenchPartSite site = editor.getSite();
            Shell shell = site.getShell();
            if (shell != null && !shell.isDisposed()) {
                display = shell.getDisplay();
            }
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    EclContentAssistAction.this.fOperationTarget.doOperation(13);
                }
            });
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        if (this.fOperationTarget == null) {
            this.setEnabled(false);
            return;
        }
        if (this.fOperationTarget instanceof ITextOperationTargetExtension) {
            ITextOperationTargetExtension targetExtension = (ITextOperationTargetExtension)this.fOperationTarget;
            targetExtension.enableOperation(13, this.canModifyEditor());
        }
        this.setEnabled(this.fOperationTarget.canDoOperation(13));
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }
}

