/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.internal.intro.impl.FontSelection;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.html.FormattedHTMLElement;
import org.eclipse.ui.internal.intro.impl.html.HTMLElement;
import org.eclipse.ui.internal.intro.impl.html.HTMLUtil;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroInjectedIFrame;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroSeparator;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.model.IntroTheme;
import org.eclipse.ui.internal.intro.impl.model.loader.ContentProviderManager;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;

public class IntroHTMLGenerator {
    private AbstractIntroPage introPage;
    private IIntroContentProviderSite providerSite;
    private boolean backgroundSizeWorks;

    public HTMLElement generateHTMLforPage(AbstractIntroPage page, IIntroContentProviderSite providerSite) {
        if (page == null) {
            return null;
        }
        this.introPage = page;
        this.providerSite = providerSite;
        this.initializeBackgroundSizeWorks();
        return this.generateHTMLElement();
    }

    private void initializeBackgroundSizeWorks() {
        this.backgroundSizeWorks = true;
        try {
            if (this.getBrowser() != null && "ie".equals(this.getBrowser().getBrowserType())) {
                Class<?> ieClass = Class.forName("org.eclipse.swt.browser.IE");
                Field field = ieClass.getDeclaredField("IEVersion");
                field.setAccessible(true);
                int value = field.getInt(ieClass);
                this.backgroundSizeWorks = value <= 0 || value >= 9;
            }
        }
        catch (Exception exception) {}
    }

    private Browser getBrowser() {
        if (this.providerSite instanceof BrowserIntroPartImplementation) {
            return ((BrowserIntroPartImplementation)this.providerSite).getBrowser();
        }
        return null;
    }

    private HTMLElement generateHTMLElement() {
        int indentLevel = 0;
        FormattedHTMLElement html = new FormattedHTMLElement("HTML", indentLevel, true);
        HTMLElement head = this.generateHeadElement(indentLevel + 1);
        HTMLElement body = this.generateBodyElement(indentLevel + 1, head);
        html.addContent(head);
        html.addContent(body);
        return html;
    }

    private HTMLElement generateHeadElement(int indentLevel) {
        String pageStyle;
        FormattedHTMLElement head = new FormattedHTMLElement("HEAD", indentLevel, true);
        head.addContent(this.generateTitleElement(this.introPage.getTitle(), indentLevel + 1));
        head.addContent(this.generateUTF8CharsetElement());
        String basePath = BundleUtil.getResolvedResourceLocation(this.introPage.getBase(), this.introPage.getBundle());
        HTMLElement base = this.generateBaseElement(indentLevel + 1, basePath);
        if (base != null) {
            head.addContent(base);
        }
        head.addContent(this.generateStyleElement(indentLevel + 1));
        String[] presentationStyles = IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getImplementationStyles();
        if (presentationStyles != null && this.introPage.injectSharedStyle()) {
            int i = 0;
            while (i < presentationStyles.length) {
                head.addContent(this.generateLinkElement(presentationStyles[i], indentLevel + 1));
                ++i;
            }
        }
        if ((pageStyle = this.introPage.getStyle()) != null) {
            head.addContent(this.generateLinkElement(pageStyle, indentLevel + 1));
        }
        head.addContent(this.generateJavascriptElement(indentLevel + 1));
        String[] pageStyles = this.introPage.getStyles();
        int i = 0;
        while (i < pageStyles.length) {
            pageStyle = pageStyles[i];
            if (pageStyle != null) {
                head.addContent(this.generateLinkElement(pageStyle, indentLevel + 1));
            }
            ++i;
        }
        StringBuffer content = null;
        IntroHead introHead = IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getHead();
        if (introHead != null && (content = this.readFromFile(introHead.getSrc(), introHead.getInlineEncoding())) != null) {
            head.addContent(content);
        }
        IntroHead[] htmlHeads = this.introPage.getHTMLHeads();
        int i2 = 0;
        while (i2 < htmlHeads.length) {
            introHead = htmlHeads[i2];
            if (introHead != null && (content = this.readFromFile(introHead.getSrc(), introHead.getInlineEncoding())) != null) {
                head.addContent(content);
            }
            ++i2;
        }
        return head;
    }

    private HTMLElement generateUTF8CharsetElement() {
        FormattedHTMLElement meta = new FormattedHTMLElement("meta", 0, false);
        meta.addAttribute("http-equiv", "Content-Type");
        meta.addAttribute("content", "text/html; charset=UTF-8");
        return meta;
    }

    private HTMLElement generateJavascriptElement(int indentLevel) {
        String rel = "javascript/common.js";
        String abs = BundleUtil.getResolvedResourceLocation(rel, IntroPlugin.getDefault().getBundle());
        FormattedHTMLElement jselement = new FormattedHTMLElement("script", indentLevel, false);
        jselement.addAttribute("type", "text/javascript");
        jselement.addAttribute("src", abs);
        return jselement;
    }

    private HTMLElement generateBodyElement(int indentLevel, HTMLElement head) {
        FormattedHTMLElement body = new FormattedHTMLElement("BODY", indentLevel, true);
        String pageId = this.introPage.getId() != null ? this.introPage.getId() : "page";
        HTMLElement pageContentDiv = this.generateDivElement(pageId, indentLevel + 1);
        if (this.introPage.getStyleId() != null) {
            pageContentDiv.addAttribute("class", this.introPage.getStyleId());
        }
        if (this.introPage.getBackgroundImage() != null) {
            pageContentDiv.addAttribute("style", "background-image : url(" + this.introPage.getBackgroundImage() + ")");
        }
        AbstractIntroElement[] children = this.introPage.getChildren();
        int i = 0;
        while (i < children.length) {
            AbstractIntroElement child = children[i];
            HTMLElement childElement = this.generateIntroElement(child, indentLevel + 2);
            if (childElement != null) {
                this.addMixinStyle(childElement, child.getMixinStyle());
                pageContentDiv.addContent(childElement);
            }
            ++i;
        }
        body.addContent(pageContentDiv);
        return body;
    }

    private HTMLElement generateIntroElement(AbstractIntroElement element, int indentLevel) {
        if (element == null) {
            return null;
        }
        if (this.filteredFromPresentation(element)) {
            return null;
        }
        switch (element.getType()) {
            case 16: {
                return this.generateIntroDiv((IntroGroup)element, indentLevel);
            }
            case 64: {
                return this.generateIntroLink((IntroLink)element, indentLevel);
            }
            case 32: {
                return this.generateIntroHTML((IntroHTML)element, indentLevel);
            }
            case 16384: {
                return this.generateIntroContent((IntroContentProvider)element, indentLevel);
            }
            case 128: {
                return this.generateIntroImage((IntroImage)element, indentLevel);
            }
            case 524288: {
                return this.generateIntroSeparator((IntroSeparator)element, indentLevel);
            }
            case 512: {
                return this.generateIntroText((IntroText)element, indentLevel);
            }
            case 4096: {
                return this.generateIntroTitle((IntroPageTitle)element, indentLevel);
            }
            case 131072: {
                return this.generateIntroInjectedIFrame((IntroInjectedIFrame)element, indentLevel);
            }
        }
        return null;
    }

    private HTMLElement generateIntroDiv(IntroGroup element, int indentLevel) {
        HTMLElement divElement;
        HTMLElement childContainer = divElement = this.generateDivElement(element.getId(), indentLevel);
        if (element.getStyleId() != null) {
            divElement.addAttribute("class", element.getStyleId());
        }
        if (element.getLabel() != null) {
            HTMLElement divLabel;
            if (element.isExpandable()) {
                divLabel = new FormattedHTMLElement("SPAN", indentLevel + 2, false);
                divLabel.addContent(element.getLabel());
                divLabel.addAttribute("class", "section-title");
                String clientId = String.valueOf(element.getId()) + "-content";
                String toggleClosedId = String.valueOf(element.getId()) + "-toggle-closed";
                String toggleOpenId = String.valueOf(element.getId()) + "-toggle-open";
                String href = "#";
                FormattedHTMLElement link = new FormattedHTMLElement("A", indentLevel + 1, true);
                link.addAttribute("href", href);
                link.addAttribute("class", "section-title-link");
                StringBuffer call = new StringBuffer();
                call.append("return (toggleSection('");
                call.append(clientId);
                call.append("','");
                call.append(toggleClosedId);
                call.append("','");
                call.append(toggleOpenId);
                call.append("'))");
                link.addAttribute("onClick", call.toString());
                link.addContent(divLabel);
                divElement.addContent(link);
                FormattedHTMLElement toggleImageClosed = new FormattedHTMLElement("IMG", indentLevel + 2, false, false);
                toggleImageClosed.addAttribute("id", toggleClosedId);
                toggleImageClosed.addAttribute("src", BundleUtil.getResolvedResourceLocation("icons/blank.gif", "org.eclipse.ui.intro"));
                toggleImageClosed.addAttribute("class", "section-toggle-image-closed");
                if (element.isExpanded()) {
                    toggleImageClosed.addAttribute("style", "display: none");
                }
                link.addContent(toggleImageClosed);
                FormattedHTMLElement toggleImageOpen = new FormattedHTMLElement("IMG", indentLevel + 2, false, false);
                toggleImageOpen.addAttribute("id", toggleOpenId);
                toggleImageOpen.addAttribute("src", BundleUtil.getResolvedResourceLocation("icons/blank.gif", "org.eclipse.ui.intro"));
                toggleImageOpen.addAttribute("class", "section-toggle-image-open");
                if (element.isExpanded()) {
                    toggleImageOpen.addAttribute("style", "display: inline");
                }
                link.addContent(toggleImageOpen);
                childContainer = this.generateDivElement(clientId, indentLevel + 1);
                childContainer.addAttribute("class", "section-body");
                if (element.isExpanded()) {
                    childContainer.addAttribute("style", "display: block");
                }
                divElement.addContent(childContainer);
            } else {
                divLabel = this.generateTextElement("H4", null, "div-label", element.getLabel(), indentLevel + 1);
                divElement.addContent(divLabel);
            }
        }
        if (element.getBackgroundImage() != null) {
            String imageUrl = element.getBackgroundImage();
            imageUrl = BundleUtil.getResolvedResourceLocation(element.getBase(), imageUrl, element.getBundle());
            String style = Platform.getWS().equals("win32") && !this.backgroundSizeWorks && imageUrl.toLowerCase().endsWith(".png") ? "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + imageUrl + "', sizingMethod='crop');" : "background-image : url(" + imageUrl + ")";
            divElement.addAttribute("style", style);
        }
        AbstractIntroElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            AbstractIntroElement child = children[i];
            HTMLElement childElement = this.generateIntroElement(child, indentLevel + 1);
            if (childElement != null) {
                this.addMixinStyle(childElement, child.getMixinStyle());
                childContainer.addContent(childElement);
            }
            ++i;
        }
        return divElement;
    }

    private void addMixinStyle(HTMLElement element, String mixinStyle) {
        if (mixinStyle == null) {
            return;
        }
        String key = "class";
        String original = element.getElementAttributes().get(key);
        original = original == null ? mixinStyle : String.valueOf(original) + " " + mixinStyle;
        element.addAttribute(key, original);
    }

    private HTMLElement generateIntroLink(IntroLink element, int indentLevel) {
        HTMLElement text;
        IntroText linkText;
        HTMLElement img;
        String blankImageURL;
        String styleId = element.getStyleId();
        boolean useTable = ProductPreferences.isRTL() && "content-link".equals(styleId);
        HTMLElement anchor1 = this.generateAnchorElement(element, indentLevel);
        HTMLElement anchor2 = null;
        HTMLElement labelAnchor = anchor1;
        int indentBase = indentLevel;
        if (useTable) {
            indentBase = indentLevel + 1;
            labelAnchor = anchor2 = this.generateAnchorElement(element, indentLevel + 1);
        }
        if ((blankImageURL = BundleUtil.getResolvedResourceLocation("icons/blank.gif", "org.eclipse.ui.intro")) != null) {
            anchor1.addContent(this.generateImageElement(blankImageURL, null, null, "background-image", indentBase + 1));
        }
        if (element.getImg() != null && (img = this.generateIntroElement(element.getImg(), indentBase + 1)) != null) {
            anchor1.addContent(img);
        }
        if (!useTable) {
            FormattedHTMLElement imageDiv = new FormattedHTMLElement("DIV", indentBase + 1, false);
            imageDiv.addAttribute("class", "link-extra-div");
            anchor1.addContent(imageDiv);
        }
        if (element.getLabel() != null) {
            HTMLElement label = this.generateSpanElement("link-label", indentBase + 2);
            label.addContent(element.getLabel());
            labelAnchor.addContent(label);
        }
        if ((linkText = element.getIntroText()) != null && linkText.getText() != null && (text = this.generateIntroElement(linkText, indentBase + 3)) != null) {
            labelAnchor.addContent(text);
        }
        if (!useTable) {
            return anchor1;
        }
        FormattedHTMLElement table = new FormattedHTMLElement("TABLE", indentLevel, false);
        FormattedHTMLElement tr = new FormattedHTMLElement("TR", indentLevel + 1, false);
        table.addContent(tr);
        FormattedHTMLElement td1 = new FormattedHTMLElement("TD", indentLevel + 1, false);
        FormattedHTMLElement td2 = new FormattedHTMLElement("TD", indentLevel + 1, false);
        tr.addContent(td1);
        tr.addContent(td2);
        td1.addContent(anchor1);
        td2.addContent(anchor2);
        return table;
    }

    private HTMLElement generateIntroHTML(IntroHTML element, int indentLevel) {
        if (element.isInlined()) {
            return this.generateInlineIntroHTML(element, indentLevel);
        }
        return this.generateEmbeddedIntroHTML(element, indentLevel);
    }

    private HTMLElement generateIntroImage(IntroImage element, int indentLevel) {
        HTMLElement imageElement = this.generateImageElement(element.getSrc(), element.getAlt(), element.getTitle(), element.getStyleId(), indentLevel);
        if (element.getId() != null) {
            imageElement.addAttribute("id", element.getId());
        }
        return imageElement;
    }

    private HTMLElement generateIntroSeparator(IntroSeparator element, int indentLevel) {
        FormattedHTMLElement hrElement = new FormattedHTMLElement("HR", indentLevel, false);
        if (element.getId() != null) {
            hrElement.addAttribute("id", element.getId());
        }
        if (element.getStyleId() != null) {
            hrElement.addAttribute("style", element.getStyleId());
        }
        return hrElement;
    }

    private HTMLElement generateIntroText(IntroText element, int indentLevel) {
        String spanClass = element.getStyleId() != null ? element.getStyleId() : "text";
        HTMLElement textElement = this.generateTextElement("P", element.getId(), spanClass, element.getText(), indentLevel);
        return textElement;
    }

    private HTMLElement generateIntroInjectedIFrame(IntroInjectedIFrame element, int indentLevel) {
        HTMLElement iframe = this.generateIFrameElement(element.getIFrameURL(), "0", "auto", indentLevel);
        return iframe;
    }

    private HTMLElement generateIntroTitle(IntroPageTitle element, int indentLevel) {
        HTMLElement titleElement = this.generateHeaderDiv(element.getId(), element.getStyleId(), "H1", element.getTitle(), indentLevel);
        return titleElement;
    }

    private HTMLElement generateInlineIntroHTML(IntroHTML element, int indentLevel) {
        StringBuffer content = this.readFromFile(element.getSrc(), element.getInlineEncoding());
        if (content != null && content.length() > 0) {
            String divClass = element.getStyleId() != null ? element.getStyleId() : "inline-html";
            HTMLElement divElement = this.generateDivElement(element.getId(), divClass, indentLevel);
            divElement.addContent(content);
            return divElement;
        }
        return null;
    }

    private HTMLElement generateIntroContent(IntroContentProvider element, int indentLevel) {
        HTMLElement divElement = this.generateDivElement(element.getId(), "provided-content", indentLevel);
        IIntroContentProvider providerClass = ContentProviderManager.getInst().getContentProvider(element);
        if (providerClass == null) {
            providerClass = ContentProviderManager.getInst().createContentProvider(element, this.providerSite);
        }
        if (providerClass != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            providerClass.createContent(element.getId(), pw);
            stringWriter.flush();
            divElement.addContent(stringWriter.toString());
            pw.close();
        } else {
            IntroText htmlText = element.getIntroText();
            if (htmlText != null && htmlText.getText() != null) {
                String textClass = htmlText.getStyleId() != null ? htmlText.getStyleId() : "text";
                HTMLElement text = this.generateTextElement("P", htmlText.getId(), textClass, element.getText(), indentLevel);
                if (text != null) {
                    divElement.addContent(text);
                }
            }
        }
        return divElement;
    }

    private HTMLElement generateEmbeddedIntroHTML(IntroHTML element, int indentLevel) {
        HTMLElement img;
        IntroText htmlText;
        FormattedHTMLElement objectElement = new FormattedHTMLElement("OBJECT", indentLevel, true);
        objectElement.addAttribute("type", "text/html");
        if (element.getId() != null) {
            objectElement.addAttribute("id", element.getId());
        }
        if (element.getSrc() != null) {
            objectElement.addAttribute("data", element.getSrc());
        }
        if (element.getStyleId() != null) {
            objectElement.addAttribute("class", element.getStyleId());
        }
        if ((htmlText = element.getIntroText()) != null && htmlText.getText() != null) {
            String textClass = htmlText.getStyleId() != null ? htmlText.getStyleId() : "text";
            HTMLElement text = this.generateTextElement("P", htmlText.getId(), textClass, element.getText(), indentLevel);
            if (text != null) {
                objectElement.addContent(text);
            }
        }
        if (element.getIntroImage() != null && (img = this.generateIntroImage(element.getIntroImage(), indentLevel)) != null) {
            objectElement.addContent(img);
        }
        return objectElement;
    }

    private HTMLElement generateBaseElement(int indentLevel, String baseURL) {
        FormattedHTMLElement base = new FormattedHTMLElement("BASE", indentLevel, true, false);
        if (baseURL != null) {
            base.addAttribute("href", baseURL);
        }
        return base;
    }

    private HTMLElement generateStyleElement(int indentLevel) {
        FormattedHTMLElement style = new FormattedHTMLElement("STYLE", indentLevel, false);
        style.addAttribute("type", "text/css");
        style.addContent("HTML, BODY, IMG { border: 0px; }");
        IntroTheme theme = this.introPage.getModelRoot().getTheme();
        if (theme != null && theme.isScalable() && "relative".equals(FontSelection.getFontStyle())) {
            String sizeStyle = FontSelection.generatePageFontStyle();
            style.addContent(sizeStyle);
        }
        return style;
    }

    private HTMLElement generateTitleElement(String title, int indentLevel) {
        FormattedHTMLElement titleElement = new FormattedHTMLElement("TITLE", indentLevel, false);
        if (title != null) {
            titleElement.addContent(title);
        }
        return titleElement;
    }

    private HTMLElement generateLinkElement(String href, int indentLevel) {
        FormattedHTMLElement link = new FormattedHTMLElement("LINK", indentLevel, true, false);
        link.addAttribute("rel", "stylesheet");
        link.addAttribute("type", "text/css");
        if (href != null) {
            link.addAttribute("href", href);
        }
        return link;
    }

    private HTMLElement generateAnchorElement(IntroLink link, int indentLevel) {
        FormattedHTMLElement anchor = new FormattedHTMLElement("A", indentLevel, true);
        if (link.getId() != null) {
            anchor.addAttribute("id", link.getId());
        }
        if (link.getUrl() != null) {
            anchor.addAttribute("href", link.getUrl());
        }
        if (link.getStyleId() != null) {
            anchor.addAttribute("class", link.getStyleId());
        } else {
            anchor.addAttribute("class", "link");
        }
        return anchor;
    }

    private HTMLElement generateHeaderDiv(String divId, String divClass, String headerType, String spanContent, int indentLevel) {
        HTMLElement text = this.generateTextElement(headerType, null, null, spanContent, indentLevel + 1);
        HTMLElement div = this.generateDivElement(divId, divClass, indentLevel);
        div.addContent(text);
        return div;
    }

    private HTMLElement generateTextElement(String type, String spanID, String spanClass, String spanContent, int indentLevel) {
        HTMLElement span = new HTMLElement("SPAN");
        if (spanID != null) {
            span.addAttribute("id", spanID);
        }
        if (spanClass != null) {
            span.addAttribute("class", spanClass);
        }
        if (spanContent != null) {
            span.addContent(spanContent);
        }
        if (type != null) {
            FormattedHTMLElement text = new FormattedHTMLElement(type, indentLevel, false);
            text.addContent(span);
            return text;
        }
        return span;
    }

    private HTMLElement generateDivElement(String divId, String divClass, int indentLevel) {
        HTMLElement div = this.generateDivElement(divId, indentLevel);
        div.addAttribute("class", divClass);
        return div;
    }

    private HTMLElement generateDivElement(String divId, int indentLevel) {
        FormattedHTMLElement div = new FormattedHTMLElement("DIV", indentLevel, true);
        if (divId != null) {
            div.addAttribute("id", divId);
        }
        return div;
    }

    private HTMLElement generateImageElement(String imageSrc, String altText, String title, String imageClass, int indentLevel) {
        boolean pngOnWin32;
        FormattedHTMLElement image = new FormattedHTMLElement("IMG", indentLevel, true, false);
        boolean bl = pngOnWin32 = imageSrc != null && Platform.getWS().equals("win32") && !this.backgroundSizeWorks && imageSrc.toLowerCase().endsWith(".png");
        if (imageSrc == null || pngOnWin32) {
            String blankImageURL = BundleUtil.getResolvedResourceLocation("icons/blank.gif", "org.eclipse.ui.intro");
            if (blankImageURL != null) {
                image.addAttribute("src", blankImageURL);
                if (pngOnWin32) {
                    String style = "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + imageSrc + "', sizingMethod='image')";
                    image.addAttribute("style", style);
                }
            }
        } else {
            image.addAttribute("src", imageSrc);
        }
        if (altText == null) {
            altText = "";
        }
        image.addAttribute("alt", altText);
        if (title != null) {
            image.addAttribute("title", title);
        }
        if (imageClass != null) {
            image.addAttribute("class", imageClass);
        }
        return image;
    }

    private HTMLElement generateSpanElement(String spanClass, int indentLevel) {
        FormattedHTMLElement span = new FormattedHTMLElement("SPAN", indentLevel, false);
        span.addAttribute("class", spanClass);
        return span;
    }

    private HTMLElement generateIFrameElement(String src, String frameborder, String scrolling, int indentLevel) {
        FormattedHTMLElement iframe = new FormattedHTMLElement("iFrame", indentLevel, false);
        if (src != null) {
            iframe.addAttribute("src", src);
        }
        if (frameborder != null) {
            iframe.addAttribute("frameborder", frameborder);
        }
        if (scrolling != null) {
            iframe.addAttribute("scrolling", scrolling);
        }
        return iframe;
    }

    private boolean filteredFromPresentation(AbstractIntroElement element) {
        if (element.isOfType(21245)) {
            return ((AbstractBaseIntroElement)element).isFiltered();
        }
        return false;
    }

    private StringBuffer readFromFile(String src, String charsetName) {
        if (src == null) {
            return null;
        }
        InputStream stream = null;
        StringBuffer content = new StringBuffer();
        BufferedReader reader = null;
        try {
            try {
                int character;
                URL url = new URL(src);
                stream = url.openStream();
                reader = charsetName == null ? new BufferedReader(new InputStreamReader(stream)) : new BufferedReader(new InputStreamReader(stream, charsetName));
                while ((character = reader.read()) != -1) {
                    if (character == 36) {
                        PluginIdParser parser = new PluginIdParser(character, reader);
                        String text = parser.parsePluginId();
                        if (text == null) continue;
                        content.append(text);
                        continue;
                    }
                    if (character > 0 && character < 65535) {
                        content.append((char)character);
                        continue;
                    }
                    content.append(character);
                }
            }
            catch (Exception exception) {
                Log.error("Error reading from file", exception);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    Log.error("Error closing input stream", e);
                    return null;
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                Log.error("Error closing input stream", e);
                return null;
            }
        }
        return content;
    }

    private static class PluginIdParser {
        private BufferedReader reader;
        private static final char SUBSTITUTION_BEGIN = '$';
        private static final char SUBSTITUTION_END = '$';
        private StringBuffer tokenContent;
        private StringBuffer pluginId;

        protected PluginIdParser(int tokenBegin, BufferedReader bufferedreader) {
            this.reader = bufferedreader;
            this.tokenContent = new StringBuffer();
            this.pluginId = new StringBuffer();
            if (tokenBegin > 0 && tokenBegin < 65535) {
                this.tokenContent.append((char)tokenBegin);
            }
        }

        protected String parsePluginId() {
            if (this.reader == null || this.tokenContent == null || this.pluginId == null) {
                return null;
            }
            try {
                this.reader.mark(1024);
                if (this.findValidPluginSegment()) {
                    String pluginPath = this.getPluginPath();
                    if (pluginPath == null) {
                        return this.tokenContent.toString();
                    }
                    return pluginPath;
                }
                this.reader.reset();
                return this.tokenContent.toString();
            }
            catch (IOException exception) {
                Log.error("Error reading from file", exception);
                return this.tokenContent.toString();
            }
        }

        private boolean findValidPluginSegment() {
            char[] PLUGIN_SEGMENT = new char[]{'p', 'l', 'u', 'g', 'i', 'n', ':'};
            char[] streamContent = new char[PLUGIN_SEGMENT.length];
            try {
                int peek = this.reader.read(streamContent, 0, PLUGIN_SEGMENT.length);
                if (peek == PLUGIN_SEGMENT.length && HTMLUtil.equalCharArrayContent(streamContent, PLUGIN_SEGMENT)) {
                    this.tokenContent.append(streamContent);
                    return true;
                }
                return false;
            }
            catch (IOException exception) {
                Log.error("Error reading from file", exception);
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getPluginPath() {
            try {
                while (true) {
                    int nextChar;
                    if ((nextChar = this.reader.read()) == -1) {
                        return null;
                    }
                    if (nextChar == 36) {
                        String path = BundleUtil.getResolvedBundleLocation(this.pluginId.toString());
                        if (path == null) {
                            this.reader.reset();
                        }
                        return path;
                    }
                    this.reader.mark(1024);
                    if (nextChar > 0 && nextChar < 65535) {
                        this.tokenContent.append((char)nextChar);
                        if (Character.isWhitespace((char)nextChar)) continue;
                        this.pluginId.append((char)nextChar);
                        continue;
                    }
                    this.tokenContent.append(nextChar);
                    this.pluginId.append(nextChar);
                }
            }
            catch (IOException exception) {
                Log.error("Error reading from file", exception);
                return null;
            }
        }
    }
}

