/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenExternalAntDocHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof AntEditor) {
            AntEditor editor = (AntEditor)part;
            ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (s instanceof ITextSelection) {
                ITextSelection ts = (ITextSelection)s;
                AntModel model = editor.getAntModel();
                AntElementNode node = null;
                if (model != null) {
                    node = model.getNode(ts.getOffset(), false);
                }
                if (node != null) {
                    try {
                        URL url = this.getExternalLocation(node, editor);
                        if (url != null) {
                            AntUtil.openBrowser(url.toString(), editor.getSite().getShell(), AntEditorActionMessages.getString("OpenExternalAntDocHandler_open_external_ant_doc"));
                        }
                    }
                    catch (MalformedURLException e) {
                        AntUIPlugin.log(e);
                    }
                }
            }
        }
        return null;
    }

    public URL getExternalLocation(AntElementNode node, AntEditor editor) throws MalformedURLException {
        URL baseLocation = this.getBaseLocation();
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer pathBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            pathBuffer.append('/');
        }
        if (node instanceof AntProjectNode) {
            pathBuffer.append("using.html#projects");
        } else if (node instanceof AntTargetNode) {
            if (((AntTargetNode)node).isExtensionPoint()) {
                pathBuffer.append("targets.html#extension-points");
            } else {
                pathBuffer.append("using.html#targets");
            }
        } else if (node instanceof AntTaskNode) {
            AntTaskNode taskNode = (AntTaskNode)node;
            if (editor.getAntModel().getDefininingTaskNode(taskNode.getTask().getTaskName()) == null) {
                this.appendTaskPath(taskNode, pathBuffer);
            }
        }
        try {
            return new URL(pathBuffer.toString());
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
            return null;
        }
    }

    private void appendTaskPath(AntTaskNode node, StringBuffer buffer) {
        String taskName = node.getTask().getTaskName();
        String taskPart = null;
        if (taskName.equalsIgnoreCase("path")) {
            buffer.append("using.html#path");
            return;
        }
        taskPart = this.getTaskTypePart(node);
        if (taskPart == null) {
            return;
        }
        buffer.append(taskPart);
        buffer.append('/');
        buffer.append(taskName);
        buffer.append(".html");
    }

    private URL getBaseLocation() throws MalformedURLException {
        IPreferenceStore prefs = AntUIPlugin.getDefault().getPreferenceStore();
        String base = prefs.getString("documentation.url");
        return new URL(base);
    }

    private String getTaskTypePart(AntTaskNode node) {
        AntProjectNode projectNode = node.getProjectNode();
        if (projectNode != null) {
            Project antProject = projectNode.getProject();
            AntTypeDefinition definition = ComponentHelper.getComponentHelper((Project)antProject).getDefinition(node.getTask().getTaskName());
            if (definition == null) {
                return null;
            }
            String className = definition.getClassName();
            if (className.indexOf("taskdef") != -1) {
                return "Tasks";
            }
            return "Types";
        }
        return null;
    }
}

