/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.problemview;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.ui.IJobCollector;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.markers.MarkerSupportView;

public class ProblemViewSupportProcessor
implements ITeslaCommandProcessor {
    private AbstractTeslaClient client;
    private Set<String> elements = new HashSet<String>();

    public boolean callMasterProcess(ContextManagement.Context currentContext) {
        return false;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        return true;
    }

    public void clean() {
        this.elements.clear();
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        return null;
    }

    public String getFeatureID() {
        return null;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
    }

    public boolean isCommandSupported(Command cmd) {
        return false;
    }

    public boolean isInactivityRequired() {
        return false;
    }

    public boolean isSelectorSupported(String kind) {
        return false;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
        SWTUIProcessor processor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        SWTUIElement swtuiElement = (SWTUIElement)processor.getMapper().get(element);
        if (swtuiElement == null) {
            return;
        }
        List parents = processor.getPlayer().getParentsList(swtuiElement);
        parents.add(swtuiElement);
        for (SWTUIElement w : parents) {
            WorkbenchUIElement wb;
            IWorkbenchPart part;
            if (!w.getKind().is(ElementKind.View) || !(w instanceof WorkbenchUIElement) || (part = (wb = (WorkbenchUIElement)w).getReference().getPart(true)) == null) continue;
            try {
                if (!(part instanceof MarkerSupportView)) continue;
                mapper.map(element, (ITeslaCommandProcessor)this);
                this.elements.add(String.valueOf(element.getId()) + ":" + element.getKind());
            }
            catch (Throwable throwable) {}
        }
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        if (command instanceof ElementCommand) {
            Element element = ((ElementCommand)command).getElement();
            if (!this.elements.contains(String.valueOf(element.getId()) + ":" + element.getKind())) {
                return null;
            }
        } else if (command instanceof SelectCommand) {
            SelectCommand selCmd = (SelectCommand)command;
            Element parent = selCmd.getData().getParent();
            if (parent == null) {
                return null;
            }
            if (parent != null && !this.elements.contains(String.valueOf(parent.getId()) + ":" + parent.getKind())) {
                return null;
            }
        } else {
            return null;
        }
        if (previousStatus instanceof WaitForJobsStatus) {
            WaitForJobsStatus s = (WaitForJobsStatus)previousStatus;
            if (!s.collector.isEmpty(ContextManagement.currentContext(), info)) {
                return s;
            }
            s.collector.disable();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)s.collector);
        }
        Job.getJobManager().find(null);
        WaitForJobsStatus st = new WaitForJobsStatus(false);
        st.collector.enable();
        if (st.collector.isEmpty(ContextManagement.currentContext(), info)) {
            st.collector.disable();
            return null;
        }
        Job.getJobManager().addJobChangeListener((IJobChangeListener)st.collector);
        Q7WaitUtils.updateInfo((String)"problems.view", (String)"wait", (Q7WaitInfoRoot)info);
        return st;
    }

    private boolean isMarkersJob(Job job) {
        String name = job.getClass().getName();
        if (name.equals("org.eclipse.ui.internal.views.markers.MarkerUpdateJob")) {
            return true;
        }
        if (this.is35job(job, "org.eclipse.ui.internal.views.markers.UIUpdateJob")) {
            return true;
        }
        if (this.is35job(job, "org.eclipse.ui.views.markers.internal.MarkerView", "org.eclipse.ui.views.markers.internal.ProblemView")) {
            return true;
        }
        return this.is35job(job, "org.eclipse.ui.internal.views.markers.CachedMarkerBuilder", "org.eclipse.ui.internal.views.markers.ExtendedMarkersView", "org.eclipse.jdt.internal.ui.viewsupport.ProblemMarkerManager");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean is35job(Job job, String ... list) {
        try {
            Class<?> class1 = job.getClass();
            Field this$0 = class1.getDeclaredField("this$0");
            this$0.setAccessible(true);
            Object obj = this$0.get(job);
            if (obj == null) return false;
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String name = stringArray[n2];
                if (class1.getName().contains(name)) {
                    return true;
                }
                if (obj.getClass().getName().equals(name)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        return null;
    }

    public void terminate() {
        this.clean();
        this.client = null;
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void notifyUI() {
    }

    private class WaitForJobsStatus
    extends ITeslaCommandProcessor.PreExecuteStatus {
        final UIJobCollector collector;

        public void clean() {
            this.collector.disable();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.collector);
        }

        public WaitForJobsStatus(boolean canExecute) {
            super(canExecute);
            this.collector = new UIJobCollector(){

                protected IJobCollector.JobStatus calcJobStatus(Job job, long delay) {
                    if (ProblemViewSupportProcessor.this.isMarkersJob(job)) {
                        return IJobCollector.JobStatus.REQUIRED;
                    }
                    if (job.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD)) {
                        return IJobCollector.JobStatus.REQUIRED;
                    }
                    return super.calcJobStatus(job, delay);
                }

                protected boolean isAsyncSupported() {
                    return false;
                }

                protected boolean isSyncSupported() {
                    return false;
                }
            };
        }
    }
}

