/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.Locale;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;

public class UnionScope
extends AbstractHelpScope {
    AbstractHelpScope[] scopes;

    public UnionScope(AbstractHelpScope[] scopes) {
        this.scopes = scopes;
    }

    public boolean inScope(IToc toc) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (this.scopes[scope].inScope(toc)) {
                return true;
            }
            ++scope;
        }
        return false;
    }

    public boolean inScope(ITopic topic) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (this.scopes[scope].inScope(topic)) {
                return true;
            }
            ++scope;
        }
        return false;
    }

    public boolean inScope(IIndexEntry entry) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (this.scopes[scope].inScope(entry)) {
                return true;
            }
            ++scope;
        }
        return false;
    }

    public boolean inScope(IIndexSee see) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (this.scopes[scope].inScope(see)) {
                return true;
            }
            ++scope;
        }
        return false;
    }

    public String getName(Locale locale) {
        return null;
    }

    public boolean isHierarchicalScope() {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (!this.scopes[scope].isHierarchicalScope()) {
                return false;
            }
            ++scope;
        }
        return true;
    }

    public String toString() {
        String str = "(";
        int s = 0;
        while (s < this.scopes.length) {
            str = String.valueOf(str) + this.scopes[s];
            if (s < this.scopes.length - 1) {
                str = String.valueOf(str) + " | ";
            }
            ++s;
        }
        return String.valueOf(str) + ')';
    }
}

