/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.IReconcilingParticipant;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEOutlinePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;

public class SourceOutlinePage
extends PDEOutlinePage
implements IReconcilingParticipant,
ISortableContentOutlinePage {
    private IEditingModel fModel;
    private IBaseLabelProvider fLabelProvider;
    private IContentProvider fContentProvider;
    private ViewerComparator fDefaultComparator;
    private ViewerComparator fViewerComparator;
    private boolean sorted;
    TreeViewer viewer;
    private ArrayList<ISelectionChangedListener> fListenerList;

    public SourceOutlinePage(PDEFormEditor editor, IEditingModel model, IBaseLabelProvider lProvider, IContentProvider cProvider, ViewerComparator defaultComparator, ViewerComparator comparator) {
        super(editor);
        this.fModel = model;
        this.fLabelProvider = lProvider;
        this.fContentProvider = cProvider;
        this.fDefaultComparator = defaultComparator;
        this.fViewerComparator = comparator;
        this.fListenerList = new ArrayList();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider(this.fContentProvider);
        this.viewer.setLabelProvider(this.fLabelProvider);
        if (this.sorted) {
            this.viewer.setComparator(this.fViewerComparator);
        } else {
            this.viewer.setComparator(this.fDefaultComparator);
        }
        this.viewer.setInput((Object)this.fModel);
        this.viewer.expandAll();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void reconciled(IDocument document) {
        final Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                control.setRedraw(false);
                SourceOutlinePage.this.removeAllSelectionChangedListeners();
                SourceOutlinePage.this.getTreeViewer().refresh();
                SourceOutlinePage.this.addAllSelectionChangedListeners();
                SourceOutlinePage.this.getTreeViewer().expandAll();
                control.setRedraw(true);
            }
        });
    }

    @Override
    public void sort(boolean sorting) {
        this.sorted = sorting;
        if (this.isViewerDefined()) {
            if (sorting) {
                this.viewer.setComparator(this.fViewerComparator);
            } else {
                this.viewer.setComparator(this.fDefaultComparator);
            }
        }
    }

    public void addAllSelectionChangedListeners() {
        if (this.isViewerDefined()) {
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        int i = 0;
        while (i < this.fListenerList.size()) {
            super.addSelectionChangedListener(this.fListenerList.get(i));
            ++i;
        }
    }

    private boolean isViewerDefined() {
        if (this.viewer == null) {
            return false;
        }
        return !this.viewer.getTree().isDisposed();
    }

    public void removeAllSelectionChangedListeners() {
        if (this.isViewerDefined()) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        int i = 0;
        while (i < this.fListenerList.size()) {
            super.removeSelectionChangedListener(this.fListenerList.get(i));
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListenerList.add(listener);
        super.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListenerList.remove(listener);
        super.removeSelectionChangedListener(listener);
    }
}

