/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

public class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    private Selection fSelection;

    private ExceptionAnalyzer(Selection selection) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
    }

    public static ITypeBinding[] perform(BodyDeclaration enclosingNode, Selection selection) {
        ExceptionAnalyzer analyzer = new ExceptionAnalyzer(selection);
        enclosingNode.accept((ASTVisitor)analyzer);
        List<ITypeBinding> exceptions = analyzer.getCurrentExceptions();
        if (enclosingNode.getNodeType() == 31) {
            List thrownExceptions = ((MethodDeclaration)enclosingNode).thrownExceptionTypes();
            Iterator thrown = thrownExceptions.iterator();
            while (thrown.hasNext()) {
                ITypeBinding thrownException = ((Type)thrown.next()).resolveBinding();
                if (thrownException == null) continue;
                Iterator<ITypeBinding> excep = exceptions.iterator();
                while (excep.hasNext()) {
                    ITypeBinding exception = excep.next();
                    if (!exception.isAssignmentCompatible(thrownException)) continue;
                    excep.remove();
                }
            }
        }
        Collections.sort(exceptions, new ExceptionComparator());
        return exceptions.toArray(new ITypeBinding[exceptions.size()]);
    }

    public boolean visit(LambdaExpression node) {
        return true;
    }

    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (!this.isSelected((ASTNode)node) || exception == null || Bindings.isRuntimeException(exception)) {
            return true;
        }
        this.addException(exception, node.getAST());
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveMethodBinding(), (ASTNode)node);
    }

    public boolean visit(SuperMethodInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveMethodBinding(), (ASTNode)node);
    }

    public boolean visit(ClassInstanceCreation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), (ASTNode)node);
    }

    public boolean visit(ConstructorInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), (ASTNode)node);
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), (ASTNode)node);
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return super.visit(node);
    }

    private boolean handleExceptions(IMethodBinding binding, ASTNode node) {
        if (binding == null) {
            return true;
        }
        ITypeBinding[] exceptions = binding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            this.addException(exceptions[i], node.getAST());
            ++i;
        }
        return true;
    }

    private boolean isSelected(ASTNode node) {
        return this.fSelection.getVisitSelectionMode(node) == 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExceptionComparator
    implements Comparator<ITypeBinding> {
        private ExceptionComparator() {
        }

        @Override
        public int compare(ITypeBinding o1, ITypeBinding o2) {
            int d2;
            int d1 = this.getDepth(o1);
            if (d1 < (d2 = this.getDepth(o2))) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }

        private int getDepth(ITypeBinding binding) {
            int result = 0;
            while (binding != null) {
                binding = binding.getSuperclass();
                ++result;
            }
            return result;
        }
    }
}

