/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.swt.reflection.JavaMembersHelper;

public abstract class BasicRecordingHelper<T>
implements IRecordingHelper<T> {
    protected Map<T, ElementEntry> elements = new HashMap<T, ElementEntry>();

    public ElementEntry get(T result) {
        return this.elements.get(result);
    }

    public void put(T element, ElementEntry value) {
        this.elements.put(element, value);
    }

    public void clear() {
        this.elements.clear();
    }

    public void remove(T obj) {
        this.elements.remove(obj);
    }

    public T findByElement(Element element) {
        for (Map.Entry<T, ElementEntry> entry : this.elements.entrySet()) {
            Element entryElement = entry.getValue().getElement();
            if (!entryElement.getId().equals(element.getId()) || !entryElement.getKind().equals(element.getKind())) continue;
            return entry.getKey();
        }
        return null;
    }

    public PropertyNodeList getNodeProperties(Element element, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyNodeList propertyNodeList;
        T original = this.findByElement(element);
        if (original != null && JavaMembersHelper.fillProperties(original, (String)nodePath, (EList)(propertyNodeList = UiFactory.eINSTANCE.createPropertyNodeList()).getPropertyNodes())) {
            return propertyNodeList;
        }
        return null;
    }

    public String getWidgetDetails(Element element) {
        return null;
    }

    public static class ElementEntry {
        private final Element element;
        private Map<String, Object> attributes = null;

        public ElementEntry(Element element) {
            this.element = element;
        }

        public void set(String attr, Object value) {
            this.init();
            this.attributes.put(attr, value);
        }

        public String get(String attr) {
            if (this.attributes == null) {
                return null;
            }
            return (String)this.attributes.get(attr);
        }

        public Object getObj(String attr) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(attr);
        }

        private void init() {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
        }

        public Element getElement() {
            return this.element;
        }

        public boolean isSet(String attr) {
            return this.get(attr) != null;
        }

        public boolean matchAttributes(ElementEntry el) {
            if (this.attributes != null && el.attributes != null && this.attributes.size() == el.attributes.size()) {
                Set<String> keySet = this.attributes.keySet();
                for (String key : keySet) {
                    Object v1 = this.attributes.get(key);
                    Object v2 = el.attributes.get(key);
                    if (v1 == null || v1.equals(v2)) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
    }
}

