/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.osgi.service.prefs.BackingStoreException;

public class JavaDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private Button fSuspendButton;
    private Button fSuspendOnCompilationErrors;
    private Button fSuspendDuringEvaluations;
    private Button fOpenInspector;
    private Button fPromptUnableToInstallBreakpoint;
    private Button fPromptDeleteConditionalBreakpoint;
    private Button fOnlyIncludeExportedEntries;
    private Combo fSuspendVMorThread;
    private Combo fWatchpoint;
    private Button fAlertHCRButton;
    private Button fAlertHCRNotSupportedButton;
    private Button fAlertObsoleteButton;
    private Button fPerformHCRWithCompilationErrors;
    private JavaDebugIntegerFieldEditor fTimeoutText;
    private JavaDebugIntegerFieldEditor fConnectionTimeoutText;

    public JavaDebugPreferencePage() {
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.JavaDebugPreferencePage_description);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_DEBUG_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)0, (int)0, (int)4);
        PreferenceLinkArea link = new PreferenceLinkArea(composite, 0, "org.eclipse.debug.ui.DebugPreferencePage", DebugUIMessages.JavaDebugPreferencePage_0, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        link.getControl().setFont(composite.getFont());
        Group group = SWTFactory.createGroup((Composite)composite, (String)DebugUIMessages.JavaDebugPreferencePage_Suspend_Execution_1, (int)2, (int)1, (int)768);
        this.fSuspendButton = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_Suspend__execution_on_uncaught_exceptions_1, null, (boolean)false, (int)2);
        this.fSuspendOnCompilationErrors = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_Suspend_execution_on_co_mpilation_errors_1, null, (boolean)false, (int)2);
        this.fSuspendDuringEvaluations = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_14, null, (boolean)false, (int)2);
        this.fOpenInspector = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_20, null, (boolean)false, (int)2);
        SWTFactory.createLabel((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_21, (int)1);
        this.fSuspendVMorThread = new Combo((Composite)group, 2056);
        this.fSuspendVMorThread.setItems(new String[]{DebugUIMessages.JavaDebugPreferencePage_22, DebugUIMessages.JavaDebugPreferencePage_23});
        this.fSuspendVMorThread.setFont(group.getFont());
        SWTFactory.createLabel((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_24, (int)1);
        this.fWatchpoint = new Combo((Composite)group, 2056);
        this.fWatchpoint.setItems(new String[]{DebugUIMessages.JavaDebugPreferencePage_25, DebugUIMessages.JavaDebugPreferencePage_26, DebugUIMessages.JavaDebugPreferencePage_27});
        this.fWatchpoint.setFont(group.getFont());
        group = SWTFactory.createGroup((Composite)composite, (String)DebugUIMessages.JavaDebugPreferencePage_Hot_Code_Replace_2, (int)1, (int)1, (int)768);
        this.fAlertHCRButton = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_Alert_me_when_hot_code_replace_fails_1, null, (boolean)false, (int)1);
        this.fAlertHCRNotSupportedButton = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_Alert_me_when_hot_code_replace_is_not_supported_1, null, (boolean)false, (int)1);
        this.fAlertObsoleteButton = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_Alert_me_when_obsolete_methods_remain_1, null, (boolean)false, (int)1);
        this.fPerformHCRWithCompilationErrors = SWTFactory.createCheckButton((Composite)group, (String)DebugUIMessages.JavaDebugPreferencePage_Replace_classfiles_containing_compilation_errors_1, null, (boolean)false, (int)1);
        group = SWTFactory.createGroup((Composite)composite, (String)DebugUIMessages.JavaDebugPreferencePage_Communication_1, (int)1, (int)1, (int)768);
        Composite space = SWTFactory.createComposite((Composite)group, (Font)group.getFont(), (int)1, (int)1, (int)768);
        this.fTimeoutText = new JavaDebugIntegerFieldEditor(JDIDebugModel.PREF_REQUEST_TIMEOUT, DebugUIMessages.JavaDebugPreferencePage_Debugger__timeout__2, space);
        this.fTimeoutText.setPage((DialogPage)this);
        this.fTimeoutText.setValidateStrategy(0);
        this.fTimeoutText.setValidRange(3000, Integer.MAX_VALUE);
        this.fTimeoutText.setErrorMessage(NLS.bind((String)DebugUIMessages.JavaDebugPreferencePage_Value_must_be_a_valid_integer_greater_than__0__ms_1, (Object[])new Object[]{new Integer(3000)}));
        this.fTimeoutText.load();
        this.fConnectionTimeoutText = new JavaDebugIntegerFieldEditor(JavaRuntime.PREF_CONNECT_TIMEOUT, DebugUIMessages.JavaDebugPreferencePage__Launch_timeout__ms___1, space);
        this.fConnectionTimeoutText.setPage((DialogPage)this);
        this.fConnectionTimeoutText.setValidateStrategy(0);
        this.fConnectionTimeoutText.setValidRange(20000, Integer.MAX_VALUE);
        this.fConnectionTimeoutText.setErrorMessage(NLS.bind((String)DebugUIMessages.JavaDebugPreferencePage_Value_must_be_a_valid_integer_greater_than__0__ms_1, (Object[])new Object[]{new Integer(20000)}));
        this.fConnectionTimeoutText.load();
        SWTFactory.createVerticalSpacer((Composite)composite, (int)1);
        this.fPromptUnableToInstallBreakpoint = SWTFactory.createCheckButton((Composite)composite, (String)DebugUIMessages.JavaDebugPreferencePage_19, null, (boolean)false, (int)1);
        this.fPromptDeleteConditionalBreakpoint = SWTFactory.createCheckButton((Composite)composite, (String)DebugUIMessages.JavaDebugPreferencePage_promptWhenDeletingCondidtionalBreakpoint, null, (boolean)false, (int)1);
        SWTFactory.createVerticalSpacer((Composite)composite, (int)1);
        this.fOnlyIncludeExportedEntries = SWTFactory.createCheckButton((Composite)composite, (String)DebugUIMessages.JavaDebugPreferencePage_only_include_exported_entries, null, (boolean)false, (int)1);
        this.setValues();
        this.fTimeoutText.setPropertyChangeListener(this);
        this.fConnectionTimeoutText.setPropertyChangeListener(this);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED, this.fAlertHCRButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED, this.fAlertHCRNotSupportedButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS, this.fAlertObsoleteButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS, this.fSuspendButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS, this.fSuspendOnCompilationErrors.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_UNABLE_TO_INSTALL_BREAKPOINT, this.fPromptUnableToInstallBreakpoint.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, this.fPromptDeleteConditionalBreakpoint.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION, this.fOpenInspector.getSelection());
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (prefs != null) {
            prefs.putBoolean(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION, this.fSuspendDuringEvaluations.getSelection());
            int selectionIndex = this.fSuspendVMorThread.getSelectionIndex();
            int policy = 2;
            if (selectionIndex > 0) {
                policy = 1;
            }
            prefs.putInt(JDIDebugPlugin.PREF_DEFAULT_BREAKPOINT_SUSPEND_POLICY, policy);
            prefs.putInt(JDIDebugPlugin.PREF_DEFAULT_WATCHPOINT_SUSPEND_POLICY, this.fWatchpoint.getSelectionIndex());
            prefs.putBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS, this.fPerformHCRWithCompilationErrors.getSelection());
            prefs.putInt(JDIDebugModel.PREF_REQUEST_TIMEOUT, this.fTimeoutText.getIntValue());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        if ((prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching")) != null) {
            prefs.putInt(JavaRuntime.PREF_CONNECT_TIMEOUT, this.fConnectionTimeoutText.getIntValue());
            prefs.putBoolean("org.eclipse.jdt.launching.only_include_exported_classpath_entries", this.fOnlyIncludeExportedEntries.getSelection());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fSuspendButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS));
        this.fSuspendOnCompilationErrors.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS));
        this.fAlertHCRButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED));
        this.fAlertHCRNotSupportedButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED));
        this.fAlertObsoleteButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS));
        this.fPromptUnableToInstallBreakpoint.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_UNABLE_TO_INSTALL_BREAKPOINT));
        this.fPromptDeleteConditionalBreakpoint.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT));
        this.fOpenInspector.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION));
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (prefs != null) {
            this.fSuspendDuringEvaluations.setSelection(prefs.getBoolean(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION, true));
            int value = prefs.getInt(JDIDebugPlugin.PREF_DEFAULT_BREAKPOINT_SUSPEND_POLICY, 2);
            this.fSuspendVMorThread.select(value == 2 ? 0 : 1);
            this.fWatchpoint.select(prefs.getInt(JDIDebugPlugin.PREF_DEFAULT_WATCHPOINT_SUSPEND_POLICY, 0));
            this.fPerformHCRWithCompilationErrors.setSelection(prefs.getBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS, true));
            this.fTimeoutText.setStringValue(new Integer(prefs.getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000)).toString());
        }
        if ((prefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.launching")) != null) {
            this.fConnectionTimeoutText.setStringValue(new Integer(prefs.getInt(JavaRuntime.PREF_CONNECT_TIMEOUT, 20000)).toString());
            this.fOnlyIncludeExportedEntries.setSelection(prefs.getBoolean("org.eclipse.jdt.launching.only_include_exported_classpath_entries", false));
        }
        super.performDefaults();
    }

    private void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fSuspendButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS));
        this.fSuspendOnCompilationErrors.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS));
        this.fAlertHCRButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED));
        this.fAlertHCRNotSupportedButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED));
        this.fAlertObsoleteButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS));
        this.fPromptUnableToInstallBreakpoint.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_UNABLE_TO_INSTALL_BREAKPOINT));
        this.fPromptDeleteConditionalBreakpoint.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT));
        this.fOpenInspector.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION));
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (prefs != null) {
            this.fSuspendDuringEvaluations.setSelection(prefs.getBoolean(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION, true));
            int value = prefs.getInt(JDIDebugPlugin.PREF_DEFAULT_BREAKPOINT_SUSPEND_POLICY, 2);
            this.fSuspendVMorThread.select(value == 2 ? 0 : 1);
            this.fWatchpoint.select(prefs.getInt(JDIDebugPlugin.PREF_DEFAULT_WATCHPOINT_SUSPEND_POLICY, 0));
            this.fPerformHCRWithCompilationErrors.setSelection(prefs.getBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS, true));
            this.fTimeoutText.setStringValue(new Integer(prefs.getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000)).toString());
        }
        if ((prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching")) != null) {
            this.fConnectionTimeoutText.setStringValue(new Integer(prefs.getInt(JavaRuntime.PREF_CONNECT_TIMEOUT, 20000)).toString());
            this.fOnlyIncludeExportedEntries.setSelection(prefs.getBoolean("org.eclipse.jdt.launching.only_include_exported_classpath_entries", false));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                if (this.fTimeoutText != null && event.getSource() != this.fTimeoutText) {
                    this.fTimeoutText.refreshValidState();
                }
                if (this.fConnectionTimeoutText != null && event.getSource() != this.fConnectionTimeoutText) {
                    this.fConnectionTimeoutText.refreshValidState();
                }
            }
            this.setValid(this.fTimeoutText.isValid() && this.fConnectionTimeoutText.isValid());
            this.getContainer().updateButtons();
            this.updateApplyButton();
        }
    }

    protected boolean canClearErrorMessage() {
        return this.fTimeoutText.isValid() && this.fConnectionTimeoutText.isValid();
    }

    protected class JavaDebugIntegerFieldEditor
    extends IntegerFieldEditor {
        public JavaDebugIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (JavaDebugPreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }
}

