/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rcptt.filesystem.FSFile;
import org.eclipse.rcptt.filesystem.FSFolder;
import org.eclipse.rcptt.filesystem.FSResource;
import org.eclipse.rcptt.filesystem.FilesystemContext;
import org.eclipse.swt.widgets.TreeItem;

public abstract class FSAction
extends Action {
    protected FSResource[] selection;
    protected TreeViewer viewer;

    public FSAction(String text, ImageDescriptor descriptor) {
        super(text, descriptor);
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    protected FilesystemContext getContext() {
        return (FilesystemContext)this.viewer.getInput();
    }

    protected FSFolder getFolder() {
        if (this.selection == null || this.selection.length == 0) {
            return this.getContext().getRoot();
        }
        if (this.selection.length > 1) {
            return null;
        }
        if (this.selection[0] instanceof FSFolder) {
            return (FSFolder)this.selection[0];
        }
        if (this.selection[0] instanceof FSFile) {
            TreeItem parent = this.viewer.getTree().getSelection()[0].getParentItem();
            if (parent == null) {
                return this.getContext().getRoot();
            }
            return (FSFolder)parent.getData();
        }
        return null;
    }

    protected FSFile getFile() {
        if (this.selection != null && this.selection.length == 1 && this.selection[0] instanceof FSFile) {
            return (FSFile)this.selection[0];
        }
        return null;
    }

    protected FSResource getResource() {
        if (this.selection != null && this.selection.length == 1) {
            return this.selection[0];
        }
        return this.getContext().getRoot();
    }

    public void setSelection(FSResource[] selection) {
        this.selection = selection;
        this.init();
    }

    protected abstract void init();
}

