/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.osgi.framework.Bundle;

public class ActionRunner {
    public IStatus runAction(Action cheatSheetAction, CheatSheetManager csm) {
        IAction action;
        Class actionClass;
        IStatus status = Status.OK_STATUS;
        String pluginId = cheatSheetAction.getPluginID();
        String className = cheatSheetAction.getActionClass();
        String[] params = cheatSheetAction.getParams();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            String message = NLS.bind((String)Messages.ERROR_FINDING_PLUGIN_FOR_ACTION, (Object[])new Object[]{pluginId});
            return new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
        }
        try {
            actionClass = bundle.loadClass(className);
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.ERROR_LOADING_CLASS_FOR_ACTION, (Object[])new Object[]{className});
            return new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
        }
        try {
            action = (IAction)actionClass.newInstance();
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.ERROR_CREATING_CLASS_FOR_ACTION, (Object[])new Object[]{className});
            return new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
        }
        final boolean[] listenerFired = new boolean[1];
        final boolean[] listenerResult = new boolean[1];
        IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("result") && event.getNewValue() instanceof Boolean) {
                    listenerFired[0] = true;
                    listenerResult[0] = (Boolean)event.getNewValue();
                }
            }
        };
        action.addPropertyChangeListener(propertyChangeListener);
        if (action instanceof ICheatSheetAction) {
            String[] clonedParams = null;
            if (params != null && params.length > 0) {
                clonedParams = new String[params.length];
                System.arraycopy(params, 0, clonedParams, 0, params.length);
                int i = 0;
                while (i < clonedParams.length) {
                    String param = clonedParams[i];
                    if (param != null && param.startsWith("${") && param.endsWith("}")) {
                        String value = csm.getDataQualified(param = param.substring(2, param.length() - 1));
                        clonedParams[i] = value == null ? "" : value;
                    }
                    ++i;
                }
            }
            ((ICheatSheetAction)action).run(clonedParams, csm);
        } else {
            try {
                action.run();
            }
            catch (Throwable e) {
                status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.EXCEPTION_RUNNING_ACTION, e);
            }
        }
        action.removePropertyChangeListener(propertyChangeListener);
        if (status.isOK() && listenerFired[0] && !listenerResult[0]) {
            status = new Status(2, "org.eclipse.ui.cheatsheets", 0, Messages.ACTION_FAILED, null);
        }
        return status;
    }
}

